/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gui;

import buildcraft.core.BCCoreSprites;
import buildcraft.lib.BCLibSprites;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.gui.GuiBC8;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.button.GuiSpriteButton;
import buildcraft.lib.gui.button.IButtonBehaviour;
import buildcraft.lib.gui.button.IButtonClickEventListener;
import buildcraft.lib.gui.button.IButtonClickEventTrigger;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.transport.BCTransportSprites;
import buildcraft.transport.container.ContainerEmzuliPipe_BC8;
import buildcraft.transport.pipe.behaviour.PipeBehaviourEmzuli;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;

public class GuiEmzuliPipe_BC8
extends GuiBC8<ContainerEmzuliPipe_BC8>
implements IButtonClickEventListener {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcrafttransport:textures/gui/pipe_emzuli.png");
    private static final int SIZE_X = 176;
    private static final int SIZE_Y = 166;
    private static final GuiIcon ICON_GUI = new GuiIcon(TEXTURE, 0, 0, 176, 166);
    private static final GuiIcon ICON_BUTTON_UP = new GuiIcon(TEXTURE, 176, 0, 20, 20);
    private static final GuiIcon ICON_BUTTON_DOWN = new GuiIcon(TEXTURE, 176, 20, 20, 20);
    private static final GuiIcon ICON_NO_PAINT = new GuiIcon(TEXTURE, 176, 40, 16, 16);
    private final EnumMap<PipeBehaviourEmzuli.SlotIndex, GuiSpriteButton> colourButtons = new EnumMap(PipeBehaviourEmzuli.SlotIndex.class);

    public GuiEmzuliPipe_BC8(EntityPlayer player, PipeBehaviourEmzuli behaviour) {
        super(new ContainerEmzuliPipe_BC8(player, behaviour));
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.colourButtons.clear();
        this.addButton(PipeBehaviourEmzuli.SlotIndex.SQUARE, 49, 19);
        this.addButton(PipeBehaviourEmzuli.SlotIndex.CIRCLE, 49, 47);
        this.addButton(PipeBehaviourEmzuli.SlotIndex.TRIANGLE, 106, 19);
        this.addButton(PipeBehaviourEmzuli.SlotIndex.CROSS, 106, 47);
    }

    private void addButton(PipeBehaviourEmzuli.SlotIndex index, int x, int y) {
        GuiPaintButton button = new GuiPaintButton(this, index.ordinal(), x + this.rootElement.getX(), y + this.rootElement.getY(), index);
        button.registerListener(this);
        this.colourButtons.put(index, button);
        this.guiElements.add(button);
    }

    @Override
    public void handleButtonClick(IButtonClickEventTrigger button, int buttonId, int buttonKey) {
        if (button instanceof GuiPaintButton) {
            GuiPaintButton paint = (GuiPaintButton)button;
            switch (buttonKey) {
                case 0: {
                    EnumDyeColor colour = paint.getCurrentColour();
                    colour = ColourUtil.getNextOrNull(colour);
                    ((ContainerEmzuliPipe_BC8)this.container).paintWidgets.get((Object)paint.index).setColour(colour);
                    break;
                }
                case 1: {
                    EnumDyeColor colour = paint.getCurrentColour();
                    colour = ColourUtil.getPrevOrNull(colour);
                    ((ContainerEmzuliPipe_BC8)this.container).paintWidgets.get((Object)paint.index).setColour(colour);
                    break;
                }
                case 2: {
                    ((ContainerEmzuliPipe_BC8)this.container).paintWidgets.get((Object)paint.index).setColour(null);
                }
            }
        }
    }

    @Override
    protected void drawBackgroundLayer(float partialTicks) {
        ICON_GUI.drawAt(this.rootElement);
        PipeBehaviourEmzuli.SlotIndex currentSlot = ((ContainerEmzuliPipe_BC8)this.container).behaviour.getCurrentSlot();
        for (PipeBehaviourEmzuli.SlotIndex index : ((ContainerEmzuliPipe_BC8)this.container).behaviour.getActiveSlots()) {
            boolean current = index == currentSlot;
            int x = index.ordinal() < 2 ? 4 : 155;
            int y = index.ordinal() % 2 == 0 ? 21 : 49;
            SpriteHolderRegistry.SpriteHolder sprite = current ? BCCoreSprites.TRIGGER_TRUE : BCLibSprites.LOCK;
            GuiIcon.drawAt(sprite, this.rootElement.getX() + x, this.rootElement.getY() + y, 16);
        }
    }

    @Override
    protected void drawForegroundLayer() {
        String title = LocaleUtil.localize("gui.pipes.emzuli.title");
        this.field_146289_q.func_78276_b(title, this.rootElement.getX() + (this.field_146999_f - this.field_146289_q.func_78256_a(title)) / 2, this.rootElement.getY() + 6, 0x404040);
        this.field_146289_q.func_78276_b(LocaleUtil.localize("gui.inventory"), this.rootElement.getX() + 8, this.rootElement.getY() + this.field_147000_g - 93, 0x404040);
    }

    public final class GuiPaintButton
    extends GuiSpriteButton {
        private final PipeBehaviourEmzuli.SlotIndex index;

        public GuiPaintButton(GuiBC8<?> gui, int buttonId, int x, int y, PipeBehaviourEmzuli.SlotIndex index) {
            super(gui, buttonId, x, y, 20, 20, ICON_BUTTON_UP, ICON_BUTTON_DOWN);
            this.index = index;
            this.setBehaviour(IButtonBehaviour.DEFAULT);
        }

        private EnumDyeColor getCurrentColour() {
            return ((ContainerEmzuliPipe_BC8)GuiEmzuliPipe_BC8.this.container).behaviour.slotColours.get((Object)this.index);
        }

        @Override
        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            super.func_146112_a(mc, mouseX, mouseY);
            EnumDyeColor colour = this.getCurrentColour();
            if (colour == null) {
                ICON_NO_PAINT.drawAt(this.getX() + 2, this.getY() + 2);
            } else {
                GuiIcon.drawAt(BCTransportSprites.ACTION_PIPE_COLOUR[colour.ordinal()], this.getX() + 2, this.getY() + 2, 16);
            }
        }

        @Override
        public void addToolTips(List<ToolTip> tooltips) {
            if (this.contains(this.gui.mouse)) {
                EnumDyeColor color = this.getCurrentColour();
                if (color != null) {
                    tooltips.add(new ToolTip(String.format(LocaleUtil.localize("gui.pipes.emzuli.paint"), ColourUtil.getTextFullTooltip(color))));
                } else {
                    tooltips.add(new ToolTip(LocaleUtil.localize("gui.pipes.emzuli.nopaint")));
                }
            }
        }
    }
}

