/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gui;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.misc.data.IReference;
import buildcraft.transport.container.ContainerGate;
import buildcraft.transport.gui.ElementGuiSlot;
import buildcraft.transport.gui.ElementStatement;
import buildcraft.transport.gui.GuiGate;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;

public class ElementStatementParam
extends ElementGuiSlot<IStatementParameter> {
    public final int paramIndex;
    public final ElementStatement<?> parent;

    public ElementStatementParam(GuiGate gui, IGuiArea element, IReference<IStatementParameter> reference, int paramIndex, ElementStatement<?> elemParent) {
        super(gui, element, reference);
        this.paramIndex = paramIndex;
        this.parent = elemParent;
    }

    @Override
    public void drawBackground(float partialTicks) {
        IStatementParameter param = (IStatementParameter)this.reference.get();
        if (!this.parent.hasParam(this.paramIndex)) {
            GuiGate.ICON_SLOT_BLOCKED.drawAt(this);
        } else if (param == null) {
            GuiGate.ICON_SLOT_NOT_SET.drawAt(this);
        } else {
            GuiGate.SLOT_COLOUR.drawAt(this);
            super.drawBackground(partialTicks);
            ItemStack stack = param.getItemStack();
            if (!stack.func_190926_b()) {
                ((GuiGate)this.gui).drawItemStackAt(stack, this.getX() + 1, this.getY() + 1);
            }
        }
    }

    @Override
    public void draw(IStatementParameter val, IGuiPosition element) {
        if (val == null) {
            GuiGate.ICON_SLOT_BLOCKED.drawAt(element);
        } else {
            GuiGate.SLOT_COLOUR.drawAt(element);
            super.draw(val, element);
            ItemStack stack = val.getItemStack();
            if (!stack.func_190926_b()) {
                ((GuiGate)this.gui).drawItemStackAt(stack, this.getX() + 1, this.getY() + 1);
            }
        }
    }

    @Override
    public void onMouseClicked(int button) {
        if (this.contains(((GuiGate)this.gui).mouse)) {
            IStatementParameter value = (IStatementParameter)this.reference.get();
            if (value == null) {
                return;
            }
            if (value.onClick(((ContainerGate)((GuiGate)this.gui).container).gate, (IStatement)this.parent.reference.get(), ((GuiGate)this.gui).field_146297_k.field_71439_g.field_71071_by.func_70445_o(), new StatementMouseClick(button, GuiScreen.func_146272_n()))) {
                this.reference.set(value);
                return;
            }
            this.displayPossible();
        }
    }

    protected IStatementParameter[] getPossible() {
        IStatementParameter value = (IStatementParameter)this.reference.get();
        if (value == null) {
            return null;
        }
        return value.getPossible(((ContainerGate)((GuiGate)this.gui).container).gate, (IStatement)this.parent.reference.get());
    }
}

