/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gui;

import buildcraft.api.core.EnumPipePart;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.data.IReference;
import buildcraft.transport.gate.ActionWrapper;
import buildcraft.transport.gate.StatementWrapper;
import buildcraft.transport.gate.TriggerWrapper;
import buildcraft.transport.gui.ElementGuiSlot;
import buildcraft.transport.gui.GuiGate;
import java.util.List;
import net.minecraft.util.EnumFacing;

public abstract class ElementStatement<T extends StatementWrapper>
extends ElementGuiSlot<T> {
    public ElementStatement(GuiGate gui, IGuiArea element, IReference<T> reference) {
        super(gui, element, reference);
    }

    public boolean hasParam(int param) {
        StatementWrapper statement = (StatementWrapper)this.reference.get();
        if (statement == null) {
            return false;
        }
        return param < statement.maxParameters();
    }

    @Override
    public void onMouseClicked(int button) {
        if (button == 1 && this.contains(((GuiGate)this.gui).mouse)) {
            StatementWrapper value;
            if (!((GuiGate)this.gui).isDraggingStatement && (value = (StatementWrapper)this.reference.get()) != null) {
                if (value instanceof TriggerWrapper) {
                    ((GuiGate)this.gui).draggingTrigger = (TriggerWrapper)value;
                    ((GuiGate)this.gui).isDraggingStatement = true;
                } else if (value instanceof ActionWrapper) {
                    ((GuiGate)this.gui).draggingAction = (ActionWrapper)value;
                    ((GuiGate)this.gui).isDraggingStatement = true;
                }
            }
        } else {
            super.onMouseClicked(button);
        }
    }

    @Override
    public void draw(T statement, IGuiPosition pos) {
        ElementStatement.draw((GuiGate)this.gui, statement, pos);
    }

    @Override
    protected void addToolTip(T value, List<ToolTip> tooltips) {
        String[] arr = new String[]{};
        String desc = ((StatementWrapper)value).getDescription();
        if (desc == null || desc.length() <= 0) {
            return;
        }
        arr = new String[]{desc};
        EnumFacing face = ((StatementWrapper)value).sourcePart.face;
        if (face != null) {
            String translated = ColourUtil.getTextFullTooltip(face);
            translated = LocaleUtil.localize("gate.side", translated);
            arr = new String[]{arr[0], translated};
        }
        tooltips.add(new ToolTip(arr));
    }

    public static void draw(GuiGate gui, StatementWrapper statement, IGuiPosition pos) {
        if (statement == null) {
            GuiGate.SLOT_COLOUR.drawAt(pos);
            return;
        }
        EnumPipePart part = statement.sourcePart;
        int yOffset = (part.getIndex() + 1) % 7;
        GuiGate.SLOT_COLOUR.offset(0, yOffset * 18).drawAt(pos);
        ElementGuiSlot.draw(gui, statement, pos);
    }
}

