/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gui;

import buildcraft.api.statements.IGuiSlot;
import buildcraft.lib.gui.GuiElementSimple;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.misc.SpriteUtil;
import buildcraft.lib.misc.data.IReference;
import buildcraft.transport.gui.GuiGate;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public abstract class ElementGuiSlot<T extends IGuiSlot>
extends GuiElementSimple<GuiGate> {
    private static final int[][] OFFSET_HOVER = new int[][]{{-1, -1}, {0, -1}, {1, -1}, {1, 0}, {1, 1}, {0, 1}, {-1, 1}, {-1, 0}, {-2, -2}, {-1, -2}, {0, -2}, {1, -2}, {2, -2}, {2, -1}, {2, 0}, {2, 1}, {2, 2}, {1, 2}, {0, 2}, {-1, 2}, {-2, 2}, {-2, 1}, {-2, 0}, {-2, -1}};
    private T[] possible = null;
    private IGuiArea[] posPossible = null;
    public final IReference<T> reference;

    public ElementGuiSlot(GuiGate gui, IGuiArea element, IReference<T> reference) {
        super(gui, element);
        this.reference = reference;
    }

    @Override
    public void addToolTips(List<ToolTip> tooltips) {
        if (this.possible != null) {
            for (int i = 0; i < this.possible.length; ++i) {
                if (this.possible[i] == null || !this.posPossible[i].contains(((GuiGate)this.gui).mouse)) continue;
                this.addToolTip(this.possible[i], tooltips);
                break;
            }
        }
        if (((GuiGate)this.gui).currentHover != null && ((GuiGate)this.gui).currentHover != this) {
            return;
        }
        IGuiSlot value = (IGuiSlot)this.reference.get();
        if (value != null && this.contains(((GuiGate)this.gui).mouse)) {
            this.addToolTip(value, tooltips);
        }
    }

    protected void addToolTip(T value, List<ToolTip> tooltips) {
        String desc = value.getDescription();
        if (desc != null && desc.length() > 0) {
            tooltips.add(new ToolTip(desc));
        }
    }

    @Override
    public void drawBackground(float partialTicks) {
        this.draw((IGuiSlot)this.reference.get(), this);
    }

    @Override
    public void drawForeground(float partialTicks) {
        if (this.possible != null) {
            GlStateManager.func_179097_i();
            int sub = 18 * (this.possible.length > 8 ? 2 : 1);
            int add = 18 * (this.possible.length > 8 ? 3 : 1);
            int x = this.getX() - sub - 4;
            int y = this.getY() - sub - 4;
            int size = 8 + add + 36;
            GuiGate.SELECTION_HOVER.draw(x, y, size, size);
            for (int i = 0; i < this.possible.length; ++i) {
                this.draw(this.possible[i], this.posPossible[i]);
            }
            this.draw((IGuiSlot)this.reference.get(), this);
            GlStateManager.func_179126_j();
        }
    }

    public void draw(T val, IGuiPosition position) {
        ElementGuiSlot.draw((GuiGate)this.gui, val, position);
    }

    public static void draw(GuiGate gui, IGuiSlot slot, IGuiPosition pos) {
        TextureAtlasSprite sprite;
        if (slot != null && (sprite = slot.getGuiSprite()) != null) {
            SpriteUtil.bindBlockTextureMap();
            gui.func_175175_a(pos.getX() + 1, pos.getY() + 1, sprite, 16, 16);
        }
    }

    protected abstract T[] getPossible();

    @Override
    public void onMouseClicked(int button) {
        if (this.contains(((GuiGate)this.gui).mouse)) {
            if (GuiScreen.func_146272_n()) {
                this.reference.set(null);
            } else {
                this.displayPossible();
            }
        }
    }

    public void displayPossible() {
        if (((GuiGate)this.gui).currentHover != null) {
            return;
        }
        this.possible = this.getPossible();
        if (this.possible != null) {
            ((GuiGate)this.gui).currentHover = this;
            this.posPossible = new IGuiArea[this.possible.length];
            for (int i = 0; i < this.possible.length; ++i) {
                this.posPossible[i] = i < OFFSET_HOVER.length ? this.offset(OFFSET_HOVER[i][0] * 18, OFFSET_HOVER[i][1] * 18) : new GuiRectangle(-200, -200, 18, 18);
            }
        }
    }

    @Override
    public void onMouseReleased(int button) {
        ((GuiGate)this.gui).currentHover = null;
        if (this.possible != null) {
            for (int i = 0; i < this.possible.length; ++i) {
                if (!this.posPossible[i].contains(((GuiGate)this.gui).mouse)) continue;
                this.reference.set(this.possible[i]);
                break;
            }
        }
        this.possible = null;
        this.posPossible = null;
    }
}

