/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gate;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import java.util.Arrays;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.tileentity.TileEntity;

public abstract class StatementWrapper
implements IStatement,
Comparable<StatementWrapper> {
    public final IStatement delegate;
    public final EnumPipePart sourcePart;

    public StatementWrapper(IStatement delegate, EnumPipePart sourcePart) {
        this.delegate = delegate;
        this.sourcePart = sourcePart;
    }

    @Override
    public String getUniqueTag() {
        return this.delegate.getUniqueTag();
    }

    @Override
    public int maxParameters() {
        return this.delegate.maxParameters();
    }

    @Override
    public int minParameters() {
        return this.delegate.minParameters();
    }

    @Override
    public String getDescription() {
        return this.delegate.getDescription();
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return this.delegate.createParameter(index);
    }

    @Override
    public IStatement rotateLeft() {
        return this.delegate.rotateLeft();
    }

    @Override
    public TextureAtlasSprite getGuiSprite() {
        return this.delegate.getGuiSprite();
    }

    public TileEntity getNeighbourTile(IStatementContainer source) {
        return source.getNeighbourTile(this.sourcePart.face);
    }

    public abstract StatementWrapper[] getPossible();

    @Override
    public int compareTo(StatementWrapper o) {
        Object[] oPoss;
        Object[] poss;
        if (this.sourcePart != o.sourcePart) {
            return Integer.compare(o.sourcePart.getIndex(), this.sourcePart.getIndex());
        }
        if (this.delegate == o.delegate) {
            return 0;
        }
        if (this.delegate.getClass() == o.delegate.getClass() && Arrays.equals(poss = this.delegate.getPossible(), oPoss = o.delegate.getPossible())) {
            int idxThis = -1;
            int idxThat = -1;
            for (int i = 0; i < poss.length; ++i) {
                if (poss[i] == this.delegate) {
                    idxThis = i;
                }
                if (poss[i] != o.delegate) continue;
                idxThat = i;
            }
            if (idxThis != idxThat && idxThis != -1 && idxThat != -1) {
                return Integer.compare(idxThis, idxThat);
            }
        }
        return this.getUniqueTag().compareTo(o.getUniqueTag());
    }
}

