/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gate;

import buildcraft.api.core.BCLog;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.gates.IGate;
import buildcraft.api.statements.IActionExternal;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IActionInternalSided;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.ITriggerInternalSided;
import buildcraft.api.statements.StatementManager;
import buildcraft.api.statements.StatementSlot;
import buildcraft.api.statements.containers.IRedstoneStatementContainer;
import buildcraft.api.transport.IWireManager;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.PipeEventActionActivate;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.net.IPayloadWriter;
import buildcraft.transport.gate.ActionWrapper;
import buildcraft.transport.gate.EnumGateLogic;
import buildcraft.transport.gate.GateVariant;
import buildcraft.transport.gate.StatementWrapper;
import buildcraft.transport.gate.TriggerWrapper;
import buildcraft.transport.plug.PluggableGate;
import buildcraft.transport.wire.IWireEmitter;
import buildcraft.transport.wire.WorldSavedDataWireSystems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class GateLogic
implements IGate,
IWireEmitter,
IRedstoneStatementContainer {
    public static final int NET_ID_RESOLVE = 3;
    public final PluggableGate pluggable;
    public final GateVariant variant;
    public final TriggerWrapper[] triggers;
    public final IStatementParameter[][] triggerParameters;
    public final ActionWrapper[] actions;
    public final IStatementParameter[][] actionParameters;
    public final List<StatementSlot> activeActions = new ArrayList<StatementSlot>();
    public final boolean[] connections;
    public final boolean[] triggerOn;
    public final boolean[] actionOn;
    public int redstoneOutput;
    public int redstoneOutputSide;
    private final EnumSet<EnumDyeColor> wireBroadcasts;
    public boolean isOn;

    public GateLogic(PluggableGate pluggable, GateVariant variant) {
        this.pluggable = pluggable;
        this.variant = variant;
        this.triggers = new TriggerWrapper[variant.numSlots];
        this.triggerParameters = new IStatementParameter[variant.numSlots][variant.numTriggerArgs];
        this.actions = new ActionWrapper[variant.numSlots];
        this.actionParameters = new IStatementParameter[variant.numSlots][variant.numActionArgs];
        this.connections = new boolean[variant.numSlots - 1];
        this.triggerOn = new boolean[variant.numSlots];
        this.actionOn = new boolean[variant.numSlots];
        this.wireBroadcasts = EnumSet.noneOf(EnumDyeColor.class);
    }

    public GateLogic(PluggableGate pluggable, NBTTagCompound nbt) {
        this(pluggable, new GateVariant(nbt.func_74775_l("variant")));
        IStatementParameter param;
        NBTTagCompound cpt;
        int j;
        StatementWrapper wrapper;
        EnumPipePart part;
        String tag;
        int i;
        short c = nbt.func_74765_d("connections");
        for (i = 0; i < this.connections.length; ++i) {
            this.connections[i] = (c >>> i & 1) == 1;
        }
        for (i = 0; i < this.triggers.length; ++i) {
            tag = nbt.func_74779_i("trigger[" + i + "]");
            part = EnumPipePart.fromMeta(nbt.func_74771_c("trigger[" + i + "].side"));
            wrapper = TriggerWrapper.wrap(StatementManager.statements.get(tag), part.face);
            this.triggers[i] = wrapper;
            if (wrapper == null) continue;
            for (j = 0; j < this.triggerParameters[i].length; ++j) {
                cpt = nbt.func_74775_l("triggerParameters[" + i + "][" + j + "]");
                if (cpt.func_82582_d()) {
                    this.triggerParameters[i][j] = wrapper.createParameter(j);
                    continue;
                }
                tag = cpt.func_74779_i("kind");
                param = StatementManager.createParameter(tag);
                if (param != null) {
                    param.readFromNBT(cpt);
                    this.triggerParameters[i][j] = param;
                    continue;
                }
                BCLog.logger.warn("Didn't find an IStatementParameter for " + tag);
            }
        }
        for (i = 0; i < this.actions.length; ++i) {
            tag = nbt.func_74779_i("action[" + i + "]");
            part = EnumPipePart.fromMeta(nbt.func_74771_c("action[" + i + "].side"));
            wrapper = ActionWrapper.wrap(StatementManager.statements.get(tag), part.face);
            this.actions[i] = wrapper;
            if (wrapper == null) continue;
            for (j = 0; j < this.actionParameters[i].length; ++j) {
                cpt = nbt.func_74775_l("actionParameters[" + i + "][" + j + "]");
                if (cpt.func_82582_d()) {
                    this.actionParameters[i][j] = wrapper.createParameter(j);
                    continue;
                }
                tag = cpt.func_74779_i("kind");
                param = StatementManager.createParameter(tag);
                if (param != null) {
                    param.readFromNBT(cpt);
                    this.actionParameters[i][j] = param;
                    continue;
                }
                BCLog.logger.warn("Didn't find an IStatementParameter for " + tag);
            }
        }
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound cpt;
        IStatementParameter param;
        int j;
        int i;
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("variant", (NBTBase)this.variant.writeToNBT());
        short c = 0;
        for (i = 0; i < this.connections.length; ++i) {
            if (!this.connections[i]) continue;
            c = (short)(c | 1 << i);
        }
        nbt.func_74777_a("connections", c);
        for (i = 0; i < this.triggers.length; ++i) {
            TriggerWrapper trigger = this.triggers[i];
            if (trigger == null) continue;
            nbt.func_74778_a("trigger[" + i + "]", trigger.getUniqueTag());
            nbt.func_74774_a("trigger[" + i + "].side", (byte)trigger.sourcePart.getIndex());
            for (j = 0; j < this.triggerParameters[i].length; ++j) {
                param = this.triggerParameters[i][j];
                if (param == null) continue;
                cpt = new NBTTagCompound();
                param.writeToNBT(cpt);
                cpt.func_74778_a("kind", param.getUniqueTag());
                nbt.func_74782_a("triggerParameters[" + i + "][" + j + "]", (NBTBase)cpt);
            }
        }
        for (i = 0; i < this.actions.length; ++i) {
            ActionWrapper action = this.actions[i];
            if (action != null) {
                nbt.func_74778_a("action[" + i + "]", action.getUniqueTag());
                nbt.func_74774_a("action[" + i + "].side", (byte)action.sourcePart.getIndex());
            }
            for (j = 0; j < this.actionParameters[i].length; ++j) {
                param = this.actionParameters[i][j];
                if (param == null) continue;
                cpt = new NBTTagCompound();
                param.writeToNBT(cpt);
                cpt.func_74778_a("kind", param.getUniqueTag());
                nbt.func_74782_a("actionParameters[" + i + "][" + j + "]", (NBTBase)cpt);
            }
        }
        return nbt;
    }

    public GateLogic(PluggableGate pluggable, PacketBuffer buffer) {
        this(pluggable, new GateVariant(buffer));
        MessageUtil.readBooleanArray(buffer, this.triggerOn);
        MessageUtil.readBooleanArray(buffer, this.actionOn);
        MessageUtil.readBooleanArray(buffer, this.connections);
        boolean on = false;
        for (boolean b : this.actionOn) {
            on |= b;
        }
        this.isOn = on;
    }

    public void writeCreationToBuf(PacketBuffer buffer) {
        this.variant.writeToBuffer(buffer);
        MessageUtil.writeBooleanArray(buffer, this.triggerOn);
        MessageUtil.writeBooleanArray(buffer, this.actionOn);
        MessageUtil.writeBooleanArray(buffer, this.connections);
    }

    public final void sendPayload(int id, IPayloadWriter writer) {
        this.pluggable.sendMessage(id, writer);
    }

    public void readPayload(int id, PacketBuffer buffer, Side side, MessageContext ctx) {
        if (side == Side.CLIENT) {
            if (id == 3) {
                MessageUtil.readBooleanArray(buffer, this.triggerOn);
                MessageUtil.readBooleanArray(buffer, this.actionOn);
                MessageUtil.readBooleanArray(buffer, this.connections);
                boolean on = false;
                for (boolean b : this.actionOn) {
                    on |= b;
                }
                this.isOn = on;
            } else {
                BCLog.logger.warn("Unknown ID " + id);
            }
        } else {
            BCLog.logger.warn("Unknown side + ID" + id);
        }
    }

    public void sendResolveData() {
        this.pluggable.sendMessage(3, buffer -> {
            MessageUtil.writeBooleanArray(buffer, this.triggerOn);
            MessageUtil.writeBooleanArray(buffer, this.actionOn);
            MessageUtil.writeBooleanArray(buffer, this.connections);
        });
    }

    @Override
    public EnumFacing getSide() {
        return this.pluggable.side;
    }

    @Override
    public TileEntity getTile() {
        return this.pluggable.holder.getPipeTile();
    }

    @Override
    public TileEntity getNeighbourTile(EnumFacing side) {
        return this.getPipeHolder().getNeighbourTile(side);
    }

    @Override
    public IPipeHolder getPipeHolder() {
        return this.pluggable.holder;
    }

    @Override
    public List<IStatement> getTriggers() {
        return Arrays.asList(this.triggers);
    }

    @Override
    public List<IStatement> getActions() {
        return Arrays.asList(this.actions);
    }

    @Override
    public List<StatementSlot> getActiveActions() {
        return this.activeActions;
    }

    @Override
    public List<IStatementParameter> getTriggerParameters(int slot) {
        return Arrays.asList(this.triggerParameters[slot]);
    }

    @Override
    public List<IStatementParameter> getActionParameters(int slot) {
        return Arrays.asList(this.actionParameters[slot]);
    }

    @Override
    public int getRedstoneInput(EnumFacing side) {
        return this.pluggable.holder.getRedstoneInput(side);
    }

    @Override
    public boolean setRedstoneOutput(EnumFacing side, int value) {
        return this.pluggable.holder.setRedstoneOutput(side, value);
    }

    public void setTrigger(int index, TriggerWrapper trigger) {
        GateLogic.setStatementInternal(index, this.triggers, this.triggerParameters, trigger);
    }

    public StatementWrapper getTrigger(int index) {
        return this.triggers[index];
    }

    public void setTriggerParam(int index, int pIndex, IStatementParameter param) {
        this.triggerParameters[index][pIndex] = param;
    }

    public IStatementParameter getTriggerParam(int index, int pIndex) {
        return this.triggerParameters[index][pIndex];
    }

    public void setAction(int index, ActionWrapper action) {
        GateLogic.setStatementInternal(index, this.actions, this.actionParameters, action);
    }

    public StatementWrapper getAction(int index) {
        return this.actions[index];
    }

    public void setActionParam(int index, int pIndex, IStatementParameter param) {
        this.actionParameters[index][pIndex] = param;
    }

    public IStatementParameter getActionParam(int index, int pIndex) {
        return this.actionParameters[index][pIndex];
    }

    private static void setStatementInternal(int index, StatementWrapper[] array, IStatementParameter[][] parameters, StatementWrapper statement) {
        StatementWrapper old = array[index];
        array[index] = statement;
        if (statement == null) {
            Arrays.fill(parameters[index], null);
        } else {
            int i;
            if (old != null && old.delegate == statement.delegate) {
                return;
            }
            int max = parameters[index].length;
            int maxTrigger = statement.maxParameters();
            for (i = 0; i < maxTrigger && i < max; ++i) {
                parameters[index][i] = statement.createParameter(i);
            }
            for (i = maxTrigger; i < max; ++i) {
                parameters[index][i] = null;
            }
        }
    }

    @Override
    public boolean isEmitting(EnumDyeColor colour) {
        return this.wireBroadcasts.contains(colour);
    }

    @Override
    public void emitWire(EnumDyeColor colour) {
        this.wireBroadcasts.add(colour);
    }

    public boolean isSplitInTwo() {
        return this.variant.numSlots > 4;
    }

    public void resolveActions() {
        int groupCount = 0;
        int groupActive = 0;
        boolean[] prevTriggers = Arrays.copyOf(this.triggerOn, this.triggerOn.length);
        boolean[] prevActions = Arrays.copyOf(this.actionOn, this.actionOn.length);
        Arrays.fill(this.triggerOn, false);
        Arrays.fill(this.actionOn, false);
        this.activeActions.clear();
        EnumSet<EnumDyeColor> previousBroadcasts = EnumSet.copyOf(this.wireBroadcasts);
        this.wireBroadcasts.clear();
        for (int triggerIndex = 0; triggerIndex < this.triggers.length; ++triggerIndex) {
            TriggerWrapper trigger = this.triggers[triggerIndex];
            ++groupCount;
            if (trigger != null && trigger.isTriggerActive(this, this.triggerParameters[triggerIndex])) {
                ++groupActive;
                this.triggerOn[triggerIndex] = true;
            }
            if (this.connections.length != triggerIndex && this.connections[triggerIndex]) continue;
            boolean allActionsActive = this.variant.logic == EnumGateLogic.AND ? groupActive == groupCount : groupActive > 0;
            for (int i = groupCount - 1; i >= 0; --i) {
                int actionIndex = triggerIndex - i;
                ActionWrapper action = this.actions[actionIndex];
                this.actionOn[actionIndex] = allActionsActive;
                if (action == null) continue;
                if (allActionsActive) {
                    StatementSlot slot = new StatementSlot();
                    slot.statement = action.delegate;
                    slot.parameters = this.actionParameters[actionIndex];
                    slot.part = action.sourcePart;
                    this.activeActions.add(slot);
                    action.actionActivate(this, this.actionParameters[actionIndex]);
                    this.getPipeHolder().fireEvent(new PipeEventActionActivate(this.getPipeHolder(), action.getDelegate(), this.actionParameters[actionIndex], action.sourcePart));
                    continue;
                }
                action.actionDeactivated(this, this.actionParameters[actionIndex]);
            }
            groupActive = 0;
            groupCount = 0;
        }
        if (!previousBroadcasts.equals(this.wireBroadcasts)) {
            IWireManager wires = this.getPipeHolder().getWireManager();
            EnumSet<EnumDyeColor> turnedOff = EnumSet.copyOf(previousBroadcasts);
            turnedOff.removeAll(this.wireBroadcasts);
            EnumSet<EnumDyeColor> turnedOn = EnumSet.copyOf(this.wireBroadcasts);
            turnedOn.removeAll(previousBroadcasts);
            if (!this.getPipeHolder().getPipeWorld().field_72995_K) {
                WorldSavedDataWireSystems.get((World)this.getPipeHolder().getPipeWorld()).gatesChanged = true;
            }
        }
        if (!Arrays.equals(prevTriggers, this.triggerOn) || !Arrays.equals(prevActions, this.actionOn)) {
            this.sendResolveData();
        }
    }

    public void onTick() {
        if (this.getPipeHolder().getPipeWorld().field_72995_K) {
            return;
        }
        this.resolveActions();
    }

    public SortedSet<TriggerWrapper> getAllValidTriggers() {
        TreeSet<TriggerWrapper> set = new TreeSet<TriggerWrapper>();
        for (ITriggerInternal trigger : StatementManager.getInternalTriggers(this)) {
            if (!this.isValidTrigger(trigger)) continue;
            set.add(new TriggerWrapper.TriggerWrapperInternal(trigger));
        }
        for (EnumFacing face : EnumFacing.field_82609_l) {
            for (ITriggerInternalSided trigger : StatementManager.getInternalSidedTriggers(this, face)) {
                if (!this.isValidTrigger(trigger)) continue;
                set.add(new TriggerWrapper.TriggerWrapperInternalSided(trigger, face));
            }
            TileEntity neighbour = this.getNeighbourTile(face);
            if (neighbour == null) continue;
            for (ITriggerExternal trigger : StatementManager.getExternalTriggers(face, neighbour)) {
                if (!this.isValidTrigger(trigger)) continue;
                set.add(new TriggerWrapper.TriggerWrapperExternal(trigger, face));
            }
        }
        return set;
    }

    public SortedSet<ActionWrapper> getAllValidActions() {
        TreeSet<ActionWrapper> set = new TreeSet<ActionWrapper>();
        for (IActionInternal trigger : StatementManager.getInternalActions(this)) {
            if (!this.isValidAction(trigger)) continue;
            set.add(new ActionWrapper.ActionWrapperInternal(trigger));
        }
        for (EnumFacing face : EnumFacing.field_82609_l) {
            for (IActionInternalSided trigger : StatementManager.getInternalSidedActions(this, face)) {
                if (!this.isValidAction(trigger)) continue;
                set.add(new ActionWrapper.ActionWrapperInternalSided(trigger, face));
            }
            TileEntity neighbour = this.getNeighbourTile(face);
            if (neighbour == null) continue;
            for (IActionExternal trigger : StatementManager.getExternalActions(face, neighbour)) {
                if (!this.isValidAction(trigger)) continue;
                set.add(new ActionWrapper.ActionWrapperExternal(trigger, face));
            }
        }
        return set;
    }

    public boolean isValidTrigger(IStatement statement) {
        return statement != null && statement.minParameters() <= this.variant.numTriggerArgs;
    }

    public boolean isValidAction(IStatement statement) {
        return statement != null && statement.minParameters() <= this.variant.numActionArgs;
    }
}

