/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gate;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.statements.IAction;
import buildcraft.api.statements.IActionExternal;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IActionInternalSided;
import buildcraft.api.statements.IActionReceptor;
import buildcraft.api.statements.IActionSingle;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.transport.gate.StatementWrapper;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public abstract class ActionWrapper
extends StatementWrapper
implements IActionInternal {
    protected boolean isActive = false;

    public ActionWrapper(IAction delegate, EnumPipePart sourcePart) {
        super(delegate, sourcePart);
    }

    public IAction getDelegate() {
        return (IAction)this.delegate;
    }

    public static ActionWrapper wrap(IStatement statement, EnumFacing side) {
        if (statement == null) {
            return null;
        }
        if (statement instanceof ActionWrapper) {
            return (ActionWrapper)statement;
        }
        if (statement instanceof IActionInternal && side == null) {
            return new ActionWrapperInternal((IActionInternal)statement);
        }
        if (statement instanceof IActionInternalSided) {
            if (side == null) {
                throw new NullPointerException("side");
            }
            return new ActionWrapperInternalSided((IActionInternalSided)statement, side);
        }
        if (statement instanceof IActionExternal) {
            if (side == null) {
                throw new NullPointerException("side");
            }
            return new ActionWrapperExternal((IActionExternal)statement, side);
        }
        throw new IllegalArgumentException("Unknown class or interface " + statement.getClass());
    }

    public ActionWrapper[] getPossible() {
        IStatement[] possible = this.delegate.getPossible();
        boolean andSides = this.sourcePart != EnumPipePart.CENTER;
        ActionWrapper[] real = new ActionWrapper[possible.length + (andSides ? 5 : 0)];
        for (int i = 0; i < possible.length; ++i) {
            real[i] = ActionWrapper.wrap(possible[i], this.sourcePart.face);
        }
        if (andSides) {
            EnumPipePart part = this.sourcePart;
            for (int j = 0; j < 5; ++j) {
                int i = j + possible.length;
                part = part.next();
                real[i] = ActionWrapper.wrap(this.delegate, part.face);
            }
        }
        return real;
    }

    public void actionDeactivated(IStatementContainer source, IStatementParameter[] parameters) {
        this.isActive = false;
    }

    public static class ActionWrapperExternal
    extends ActionWrapper {
        public final IActionExternal action;

        public ActionWrapperExternal(IActionExternal action, @Nonnull EnumFacing side) {
            super(action, EnumPipePart.fromFacing(side));
            this.action = action;
        }

        @Override
        public void actionActivate(IStatementContainer source, IStatementParameter[] parameters) {
            if (this.isActive && this.action instanceof IActionSingle && ((IActionSingle)((Object)this.action)).singleActionTick()) {
                return;
            }
            TileEntity neighbourTile = this.getNeighbourTile(source);
            if (neighbourTile == null) {
                return;
            }
            this.action.actionActivate(neighbourTile, this.sourcePart.face, source, parameters);
            if (neighbourTile instanceof IActionReceptor) {
                IActionReceptor receptor = (IActionReceptor)neighbourTile;
                receptor.actionActivated(this.action, parameters);
            }
            this.isActive = true;
        }
    }

    public static class ActionWrapperInternalSided
    extends ActionWrapper {
        public final IActionInternalSided action;

        public ActionWrapperInternalSided(IActionInternalSided action, @Nonnull EnumFacing side) {
            super(action, EnumPipePart.fromFacing(side));
            this.action = action;
        }

        @Override
        public void actionActivate(IStatementContainer source, IStatementParameter[] parameters) {
            if (this.isActive && this.action instanceof IActionSingle && ((IActionSingle)((Object)this.action)).singleActionTick()) {
                return;
            }
            this.action.actionActivate(this.sourcePart.face, source, parameters);
            this.isActive = true;
        }
    }

    public static class ActionWrapperInternal
    extends ActionWrapper {
        public final IActionInternal action;

        public ActionWrapperInternal(IActionInternal action) {
            super(action, EnumPipePart.CENTER);
            this.action = action;
        }

        @Override
        public void actionActivate(IStatementContainer source, IStatementParameter[] parameters) {
            if (this.isActive && this.action instanceof IActionSingle && ((IActionSingle)((Object)this.action)).singleActionTick()) {
                return;
            }
            this.action.actionActivate(source, parameters);
            this.isActive = true;
        }
    }
}

