/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.container;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementManager;
import buildcraft.lib.gui.ContainerBC_Neptune;
import buildcraft.lib.misc.data.ForwardingReference;
import buildcraft.lib.misc.data.IReference;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.transport.gate.ActionWrapper;
import buildcraft.transport.gate.GateLogic;
import buildcraft.transport.gate.GateVariant;
import buildcraft.transport.gate.StatementWrapper;
import buildcraft.transport.gate.TriggerWrapper;
import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ContainerGate
extends ContainerBC_Neptune {
    protected static final IdAllocator IDS = ContainerBC_Neptune.IDS.makeChild("gate");
    public static final int ID_CONNECTION = IDS.allocId("CONNECTION");
    public static final int ID_TRIGGER = IDS.allocId("TRIGGER");
    public static final int ID_TRIGGER_PARAM = IDS.allocId("TRIGGER_PARAM");
    public static final int ID_ACTION = IDS.allocId("ACTION");
    public static final int ID_ACTION_PARAM = IDS.allocId("ACTION_PARAM");
    public static final int ID_VALID_STATEMENTS = IDS.allocId("VALID_STATEMENTS");
    public static final int ID_CURRENT_SET = IDS.allocId("CURRENT_SET");
    public final GateLogic gate;
    public final int slotHeight;
    public final SlotPair[] pairs;
    public final SortedSet<TriggerWrapper> possibleTriggers;
    public final SortedSet<ActionWrapper> possibleActions;

    public ContainerGate(EntityPlayer player, GateLogic logic) {
        super(player);
        this.gate = logic;
        this.gate.getPipeHolder().onPlayerOpen(player);
        boolean split = this.gate.isSplitInTwo();
        int s = this.gate.variant.numSlots;
        if (split) {
            s = (int)Math.ceil((double)s / 2.0);
        }
        this.slotHeight = s;
        this.pairs = new SlotPair[this.gate.variant.numSlots];
        for (int i = 0; i < this.pairs.length; ++i) {
            this.pairs[i] = new SlotPair(i, this.gate.variant);
        }
        if (this.gate.getPipeHolder().getPipeWorld().field_72995_K) {
            this.possibleTriggers = new TreeSet<TriggerWrapper>();
            this.possibleActions = new TreeSet<ActionWrapper>();
        } else {
            this.possibleTriggers = this.gate.getAllValidTriggers();
            this.possibleActions = this.gate.getAllValidActions();
        }
        this.addFullPlayerInventory(33 + this.slotHeight * 18);
    }

    @Override
    public IdAllocator getIdAllocator() {
        return IDS;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        this.gate.getPipeHolder().onPlayerClose(player);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    @Override
    public void readMessage(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        block14: {
            block12: {
                block17: {
                    block16: {
                        block15: {
                            block13: {
                                if (side != Side.SERVER) break block12;
                                if (id != ID_CONNECTION) break block13;
                                short index = buffer.readUnsignedByte();
                                boolean to = buffer.readBoolean();
                                if (index >= this.gate.connections.length) break block14;
                                this.gate.connections[index] = to;
                                this.gate.sendResolveData();
                                break block14;
                            }
                            if (id != ID_TRIGGER && id != ID_ACTION) break block15;
                            short index = buffer.readUnsignedByte();
                            String tag = buffer.func_150789_c(64);
                            EnumFacing face = EnumPipePart.fromMeta((int)buffer.readUnsignedByte()).face;
                            IStatement statement = StatementManager.statements.get(tag);
                            if (id == ID_TRIGGER) {
                                this.gate.setTrigger(index, TriggerWrapper.wrap(statement, face));
                            } else {
                                this.gate.setAction(index, ActionWrapper.wrap(statement, face));
                            }
                            break block14;
                        }
                        if (id != ID_TRIGGER_PARAM && id != ID_ACTION_PARAM) break block16;
                        short index = buffer.readUnsignedByte();
                        short paramIndex = buffer.readUnsignedByte();
                        if (!buffer.readBoolean()) break block14;
                        NBTTagCompound nbt = buffer.func_150793_b();
                        IStatementParameter param = id == ID_TRIGGER_PARAM ? this.gate.getTriggerParam(index, paramIndex) : this.gate.getActionParam(index, paramIndex);
                        if (param != null) {
                            param.readFromNBT(nbt);
                        }
                        if (id == ID_TRIGGER_PARAM) {
                            this.gate.setTriggerParam(index, paramIndex, param);
                        } else {
                            this.gate.setActionParam(index, paramIndex, param);
                        }
                        break block14;
                    }
                    if (id != ID_VALID_STATEMENTS) break block17;
                    this.sendMessage(ID_VALID_STATEMENTS);
                    break block14;
                }
                if (id != ID_CURRENT_SET) break block14;
                this.sendMessage(ID_CURRENT_SET);
                break block14;
            }
            if (side == Side.CLIENT) {
                if (id == ID_VALID_STATEMENTS) {
                    StatementWrapper wrapper;
                    EnumPipePart part;
                    String tag;
                    int i;
                    this.possibleTriggers.clear();
                    this.possibleActions.clear();
                    int numTriggers = buffer.readInt();
                    int numActions = buffer.readInt();
                    for (i = 0; i < numTriggers; ++i) {
                        tag = buffer.func_150789_c(256);
                        part = buffer.func_179257_a(EnumPipePart.class);
                        wrapper = TriggerWrapper.wrap(StatementManager.statements.get(tag), part.face);
                        if (!this.gate.isValidTrigger(wrapper)) continue;
                        this.possibleTriggers.add((TriggerWrapper)wrapper);
                    }
                    for (i = 0; i < numActions; ++i) {
                        tag = buffer.func_150789_c(256);
                        part = buffer.func_179257_a(EnumPipePart.class);
                        wrapper = ActionWrapper.wrap(StatementManager.statements.get(tag), part.face);
                        if (!this.gate.isValidAction(wrapper)) continue;
                        this.possibleActions.add((ActionWrapper)wrapper);
                    }
                } else if (id == ID_CURRENT_SET) {
                    for (SlotPair pair : this.pairs) {
                        pair.readFromBuffer(buffer);
                    }
                }
            }
        }
    }

    @Override
    public void writeMessage(int id, PacketBufferBC buffer, Side side) {
        block3: {
            block4: {
                super.writeMessage(id, buffer, side);
                if (side != Side.SERVER) break block3;
                if (id != ID_VALID_STATEMENTS) break block4;
                buffer.writeInt(this.possibleTriggers.size());
                buffer.writeInt(this.possibleActions.size());
                for (TriggerWrapper triggerWrapper : this.possibleTriggers) {
                    buffer.func_180714_a(triggerWrapper.getUniqueTag());
                    buffer.writeEnumValue(triggerWrapper.sourcePart);
                }
                for (ActionWrapper actionWrapper : this.possibleActions) {
                    buffer.func_180714_a(actionWrapper.getUniqueTag());
                    buffer.writeEnumValue(actionWrapper.sourcePart);
                }
                break block3;
            }
            if (id != ID_CURRENT_SET) break block3;
            for (SlotPair pair : this.pairs) {
                pair.writeToBuffer(buffer);
            }
        }
    }

    public void setConnected(int index, boolean to) {
        this.sendMessage(ID_CONNECTION, buffer -> {
            buffer.writeByte(index);
            buffer.writeBoolean(to);
        });
    }

    private void setFirst(int id, int index, StatementWrapper to) {
        this.sendMessage(id, buffer -> {
            buffer.writeByte(index);
            if (to == null) {
                buffer.func_180714_a("");
                buffer.writeByte(0);
            } else {
                buffer.func_180714_a(to.getUniqueTag());
                buffer.writeByte(to.sourcePart.getIndex());
            }
        });
    }

    private void setParam(int id, int index, int paramIndex, IStatementParameter to) {
        this.sendMessage(id, buffer -> {
            buffer.writeByte(index);
            buffer.writeByte(paramIndex);
            if (to == null) {
                buffer.writeBoolean(false);
            } else {
                buffer.writeBoolean(true);
                NBTTagCompound nbt = new NBTTagCompound();
                to.writeToNBT(nbt);
                buffer.func_150786_a(nbt);
            }
        });
    }

    private void setTrigger(int index, TriggerWrapper to) {
        this.setFirst(ID_TRIGGER, index, to);
        this.gate.setTrigger(index, to);
    }

    private void setAction(int index, ActionWrapper to) {
        this.setFirst(ID_ACTION, index, to);
        this.gate.setAction(index, to);
    }

    private void setTriggerParam(int index, int paramIndex, IStatementParameter to) {
        this.setParam(ID_TRIGGER_PARAM, index, paramIndex, to);
        this.gate.setTriggerParam(index, paramIndex, to);
    }

    private void setActionParam(int index, int paramIndex, IStatementParameter to) {
        this.setParam(ID_ACTION_PARAM, index, paramIndex, to);
        this.gate.setActionParam(index, paramIndex, to);
    }

    private static class ParamRef
    extends ForwardingReference<IStatementParameter> {
        public ParamRef(Supplier<IStatementParameter> getter, Consumer<IStatementParameter> setter) {
            super(getter, setter);
        }

        public void writeToBuffer(PacketBuffer buffer) {
            IStatementParameter current = (IStatementParameter)this.get();
            if (current == null) {
                buffer.writeBoolean(false);
            } else {
                buffer.writeBoolean(true);
                NBTTagCompound nbt = new NBTTagCompound();
                current.writeToNBT(nbt);
                buffer.func_150786_a(nbt);
            }
        }

        public void readFromBuffer(PacketBuffer buffer) throws IOException {
            if (buffer.readBoolean()) {
                NBTTagCompound nbt = buffer.func_150793_b();
                IStatementParameter param = (IStatementParameter)this.get();
                if (param != null) {
                    param.readFromNBT(nbt);
                }
            }
        }
    }

    public class SlotPair {
        public final IReference<TriggerWrapper> trigger;
        public final IReference<ActionWrapper> action;
        public final ParamRef[] triggerParams;
        public final ParamRef[] actionParams;
        private final int index;

        public SlotPair(int slotIndex, GateVariant variant) {
            int idx;
            int i;
            this.index = slotIndex;
            this.trigger = new ForwardingReference<TriggerWrapper>(() -> this.logic().triggers[slotIndex], val -> ContainerGate.this.setTrigger(slotIndex, val));
            this.action = new ForwardingReference<ActionWrapper>(() -> this.logic().actions[slotIndex], val -> ContainerGate.this.setAction(slotIndex, val));
            this.triggerParams = new ParamRef[variant.numTriggerArgs];
            this.actionParams = new ParamRef[variant.numActionArgs];
            for (i = 0; i < this.triggerParams.length; ++i) {
                idx = i;
                this.triggerParams[i] = new ParamRef(() -> this.logic().triggerParameters[slotIndex][idx], val -> ContainerGate.this.setTriggerParam(slotIndex, idx, val));
            }
            for (i = 0; i < this.actionParams.length; ++i) {
                idx = i;
                this.actionParams[i] = new ParamRef(() -> this.logic().actionParameters[slotIndex][idx], val -> ContainerGate.this.setActionParam(slotIndex, idx, val));
            }
        }

        public void writeToBuffer(PacketBuffer buffer) {
            StatementWrapper wrapper = this.trigger.get();
            if (wrapper == null) {
                buffer.func_180714_a("");
                buffer.writeByte(0);
            } else {
                buffer.func_180714_a(wrapper.getUniqueTag());
                buffer.writeByte(wrapper.sourcePart.getIndex());
            }
            wrapper = this.action.get();
            if (wrapper == null) {
                buffer.func_180714_a("");
                buffer.writeByte(0);
            } else {
                buffer.func_180714_a(wrapper.getUniqueTag());
                buffer.writeByte(wrapper.sourcePart.getIndex());
            }
            for (ParamRef triggerParam : this.triggerParams) {
                triggerParam.writeToBuffer(buffer);
            }
            for (ParamRef actionParam : this.actionParams) {
                actionParam.writeToBuffer(buffer);
            }
        }

        public void readFromBuffer(PacketBuffer buffer) throws IOException {
            String tag = buffer.func_150789_c(256);
            EnumPipePart part = EnumPipePart.fromMeta(buffer.readUnsignedByte());
            StatementWrapper wrapper = TriggerWrapper.wrap(StatementManager.statements.get(tag), part.face);
            if (ContainerGate.this.gate.isValidTrigger(wrapper)) {
                ContainerGate.this.gate.setTrigger(this.index, (TriggerWrapper)wrapper);
            }
            tag = buffer.func_150789_c(256);
            part = EnumPipePart.fromMeta(buffer.readUnsignedByte());
            wrapper = ActionWrapper.wrap(StatementManager.statements.get(tag), part.face);
            if (ContainerGate.this.gate.isValidAction(wrapper)) {
                ContainerGate.this.gate.setAction(this.index, (ActionWrapper)wrapper);
            }
            for (ParamRef triggerParam : this.triggerParams) {
                triggerParam.readFromBuffer(buffer);
            }
            for (ParamRef actionParam : this.actionParams) {
                actionParam.readFromBuffer(buffer);
            }
        }

        private GateLogic logic() {
            return ContainerGate.this.gate;
        }
    }
}

