/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.render;

import buildcraft.api.transport.EnumWirePart;
import buildcraft.lib.client.model.ModelUtil;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.client.model.MutableVertex;
import buildcraft.lib.client.sprite.ISprite;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.lib.misc.VecUtil;
import buildcraft.transport.tile.TilePipeHolder;
import buildcraft.transport.wire.EnumWireBetween;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class PipeWireRenderer {
    private static final Map<EnumWirePart, MutableQuad[]> partQuads = new EnumMap<EnumWirePart, MutableQuad[]>(EnumWirePart.class);
    private static final Map<EnumWireBetween, MutableQuad[]> betweenQuads = new EnumMap<EnumWireBetween, MutableQuad[]>(EnumWireBetween.class);
    private static final Map<EnumDyeColor, SpriteHolderRegistry.SpriteHolder> wireSprites = new EnumMap<EnumDyeColor, SpriteHolderRegistry.SpriteHolder>(EnumDyeColor.class);
    private static final int[] wireRenderingCache = new int[(EnumWireBetween.VALUES.length + EnumWirePart.VALUES.length) * ColourUtil.COLOURS.length * 2];
    static final int WIRE_COUNT = EnumWirePart.VALUES.length * ColourUtil.COLOURS.length * 2;

    public static void clearWireCache() {
        Arrays.fill(wireRenderingCache, -1);
    }

    private static MutableQuad[] getQuads(EnumWirePart part) {
        MutableQuad[] quads = new MutableQuad[6];
        Point3f center = new Point3f(0.5f + (float)part.x.func_179524_a() * 4.51f / 16.0f, 0.5f + (float)part.y.func_179524_a() * 4.51f / 16.0f, 0.5f + (float)part.z.func_179524_a() * 4.51f / 16.0f);
        Point3f radius = new Point3f(0.03125f, 0.03125f, 0.03125f);
        ModelUtil.UvFaceData uvs = new ModelUtil.UvFaceData();
        int off = PipeWireRenderer.func(part.x) * 4 + PipeWireRenderer.func(part.y) * 2 + PipeWireRenderer.func(part.z);
        uvs.minU = (float)off / 16.0f;
        uvs.maxU = (float)(off + 1) / 16.0f;
        uvs.minV = 0.0f;
        uvs.maxV = 0.0625f;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            quads[face.ordinal()] = ModelUtil.createFace(face, (Tuple3f)center, (Tuple3f)radius, uvs);
        }
        return quads;
    }

    private static int func(EnumFacing.AxisDirection dir) {
        return dir == EnumFacing.AxisDirection.POSITIVE ? 1 : 0;
    }

    private static MutableQuad[] getQuads(EnumWireBetween between) {
        Vec3d radius;
        Vec3d center;
        double cU;
        double cL;
        boolean az;
        MutableQuad[] quads = new MutableQuad[4];
        int i = 0;
        boolean ax = between.mainAxis == EnumFacing.Axis.X;
        boolean ay = between.mainAxis == EnumFacing.Axis.Y;
        boolean bl = az = between.mainAxis == EnumFacing.Axis.Z;
        if (between.to == null) {
            cL = 0.21812498569488525;
            cU = 0.781875f;
            center = new Vec3d(ax ? 0.5 : (between.xy ? cU : cL), ay ? 0.5 : ((ax ? between.xy : between.yz) ? cU : cL), az ? 0.5 : (between.yz ? cU : cL));
            double rC = 0.250625f;
            double rN = 0.03125;
            radius = new Vec3d(ax ? rC : rN, ay ? rC : rN, az ? rC : rN);
        } else {
            cL = 0.218125;
            cU = 0.781875;
            radius = new Vec3d(ax ? 0.0934375 : 0.03125, ay ? 0.0934375 : 0.03125, az ? 0.0934375 : 0.03125);
            center = new Vec3d(ax ? 0.5 + 0.4065625 * (double)between.to.func_82601_c() : (between.xy ? cU : cL), ay ? 0.5 + 0.4065625 * (double)between.to.func_96559_d() : ((ax ? between.xy : between.yz) ? cU : cL), az ? 0.5 + 0.4065625 * (double)between.to.func_82599_e() : (between.yz ? cU : cL));
        }
        ModelUtil.UvFaceData uvBase = new ModelUtil.UvFaceData();
        uvBase.minU = (float)VecUtil.getValue(center.func_178788_d(radius), between.mainAxis);
        uvBase.maxU = (float)VecUtil.getValue(center.func_178787_e(radius), between.mainAxis);
        uvBase.minV = 0.0f;
        uvBase.maxV = 0.0625f;
        Tuple3f centerFloat = VecUtil.convertFloat(center);
        Tuple3f radiusFloat = VecUtil.convertFloat(radius);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            float t;
            if (face.func_176740_k() == between.mainAxis) continue;
            ModelUtil.UvFaceData uvs = new ModelUtil.UvFaceData(uvBase);
            EnumFacing.Axis aAxis = between.mainAxis;
            EnumFacing.Axis fAxis = face.func_176740_k();
            boolean fPositive = face.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
            int rotations = 0;
            boolean swapU = false;
            boolean swapV = false;
            if (aAxis == EnumFacing.Axis.X) {
                swapV = fPositive;
            } else if (aAxis == EnumFacing.Axis.Y) {
                rotations = 1;
                swapU = fAxis == EnumFacing.Axis.X != fPositive;
                swapV = fAxis == EnumFacing.Axis.Z;
            } else {
                if (fAxis == EnumFacing.Axis.Y) {
                    rotations = 1;
                }
                swapU = face == EnumFacing.DOWN;
                boolean bl2 = swapV = face != EnumFacing.EAST;
            }
            if (swapU) {
                t = uvs.minU;
                uvs.minU = uvs.maxU;
                uvs.maxU = t;
            }
            if (swapV) {
                t = uvs.minV;
                uvs.minV = uvs.maxV;
                uvs.maxV = t;
            }
            MutableQuad quad = ModelUtil.createFace(face, centerFloat, radiusFloat, uvs);
            if (rotations > 0) {
                quad.rotateTextureUp(rotations);
            }
            quads[i++] = quad;
        }
        return quads;
    }

    private static void renderQuads(MutableQuad[] quads, ISprite sprite, int level) {
        VertexFormat vf = DefaultVertexFormats.field_181707_g;
        Tessellator tessellator = new Tessellator(quads.length * vf.func_177338_f());
        VertexBuffer vb = tessellator.func_178180_c();
        vb.func_181668_a(7, vf);
        float vOffset = (float)(level & 0xF) / 16.0f;
        for (MutableQuad q : quads) {
            PipeWireRenderer.renderVertex(vb, q.vertex_0, sprite, vOffset);
            PipeWireRenderer.renderVertex(vb, q.vertex_1, sprite, vOffset);
            PipeWireRenderer.renderVertex(vb, q.vertex_2, sprite, vOffset);
            PipeWireRenderer.renderVertex(vb, q.vertex_3, sprite, vOffset);
        }
        tessellator.func_78381_a();
    }

    private static void renderVertex(VertexBuffer vb, MutableVertex vertex, ISprite sprite, float vOffset) {
        vertex.renderPosition(vb);
        double u = sprite.getInterpU(vertex.tex_u);
        double v = sprite.getInterpV(vertex.tex_v + vOffset);
        vb.func_187315_a(u, v);
        vb.func_181675_d();
    }

    private static int compileQuads(MutableQuad[] quads, EnumDyeColor colour, boolean isOn) {
        int index = GlStateManager.func_187442_t((int)1);
        GlStateManager.func_187423_f((int)index, (int)4864);
        ISprite sprite = wireSprites.get(colour);
        PipeWireRenderer.renderQuads(quads, sprite, isOn ? 15 : 0);
        GL11.glEndList();
        return index;
    }

    private static int getIndex(EnumWirePart part, EnumDyeColor colour, boolean isOn) {
        return part.ordinal() * 32 + colour.ordinal() * 2 + (isOn ? 1 : 0);
    }

    private static int getIndex(EnumWireBetween bet, EnumDyeColor colour, boolean isOn) {
        return WIRE_COUNT + bet.ordinal() * 32 + colour.ordinal() * 2 + (isOn ? 1 : 0);
    }

    private static int compileWire(EnumWirePart part, EnumDyeColor colour, boolean isOn) {
        return PipeWireRenderer.compileQuads(PipeWireRenderer.getQuads(part), colour, isOn);
    }

    private static int compileWire(EnumWireBetween between, EnumDyeColor colour, boolean isOn) {
        return PipeWireRenderer.compileQuads(PipeWireRenderer.getQuads(between), colour, isOn);
    }

    public static void renderWires(TilePipeHolder pipe, double x, double y, double z, VertexBuffer vb) {
        int idx;
        boolean isOn;
        EnumDyeColor color;
        int combinedLight = pipe.func_145831_w().func_175626_b(pipe.getPipePos(), 0);
        int skyLight = combinedLight >> 16 & 0xFFFF;
        int blockLight = combinedLight & 0xFFFF;
        RenderHelper.func_74518_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        for (Map.Entry<EnumWirePart, EnumDyeColor> entry : pipe.getWireManager().parts.entrySet()) {
            EnumWirePart part = entry.getKey();
            idx = PipeWireRenderer.getIndex(part, color = entry.getValue(), isOn = pipe.wireManager.isPowered(part));
            if (wireRenderingCache[idx] == -1) {
                PipeWireRenderer.wireRenderingCache[idx] = PipeWireRenderer.compileWire(part, color, isOn);
            }
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(isOn ? 240.0f : (float)blockLight), (float)skyLight);
            GlStateManager.func_179148_o((int)wireRenderingCache[idx]);
        }
        for (Map.Entry<Enum, EnumDyeColor> entry : pipe.getWireManager().betweens.entrySet()) {
            EnumWireBetween between = (EnumWireBetween)entry.getKey();
            idx = PipeWireRenderer.getIndex(between, color = entry.getValue(), isOn = pipe.wireManager.isPowered(between.parts[0]));
            if (wireRenderingCache[idx] == -1) {
                PipeWireRenderer.wireRenderingCache[idx] = PipeWireRenderer.compileWire(between, color, isOn);
            }
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(isOn ? 240.0f : (float)blockLight), (float)skyLight);
            GlStateManager.func_179148_o((int)wireRenderingCache[idx]);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    static {
        Arrays.fill(wireRenderingCache, -1);
        for (EnumDyeColor enumDyeColor : EnumDyeColor.values()) {
            wireSprites.put(enumDyeColor, SpriteHolderRegistry.getHolder("buildcrafttransport:wires/" + enumDyeColor.func_176610_l()));
        }
        for (EnumWirePart enumWirePart : EnumWirePart.VALUES) {
            partQuads.put(enumWirePart, PipeWireRenderer.getQuads(enumWirePart));
        }
        for (EnumWireBetween enumWireBetween : EnumWireBetween.VALUES) {
            betweenQuads.put(enumWireBetween, PipeWireRenderer.getQuads(enumWireBetween));
        }
    }
}

