/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.render;

import buildcraft.api.transport.pipe.IPipeFlowRenderer;
import buildcraft.lib.client.model.ModelUtil;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.client.render.ItemRenderUtil;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.transport.BCTransportSprites;
import buildcraft.transport.pipe.flow.PipeFlowItems;
import buildcraft.transport.pipe.flow.TravellingItem;
import java.util.List;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public enum PipeFlowRendererItems implements IPipeFlowRenderer<PipeFlowItems>
{
    INSTANCE;

    private static final MutableQuad[] COLOURED_QUADS;

    public static void onModelBake() {
        Point3f center = new Point3f();
        Vector3f radius = new Vector3f(0.2f, 0.2f, 0.2f);
        SpriteHolderRegistry.SpriteHolder sprite = BCTransportSprites.COLOUR_ITEM_BOX;
        ModelUtil.UvFaceData uvs = new ModelUtil.UvFaceData();
        uvs.minU = (float)sprite.getInterpU(0.0);
        uvs.maxU = (float)sprite.getInterpU(1.0);
        uvs.minV = (float)sprite.getInterpV(0.0);
        uvs.maxV = (float)sprite.getInterpV(1.0);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            MutableQuad q = ModelUtil.createFace(face, (Tuple3f)center, (Tuple3f)radius, uvs);
            q.setCalculatedDiffuse();
            PipeFlowRendererItems.COLOURED_QUADS[face.ordinal()] = q;
        }
    }

    @Override
    public void render(PipeFlowItems flow, double x, double y, double z, float partialTicks, VertexBuffer vb) {
        World world = flow.pipe.getHolder().getPipeWorld();
        long now = world.func_82737_E();
        int lightc = world.func_175626_b(flow.pipe.getHolder().getPipePos(), 0);
        List<TravellingItem> toRender = flow.getAllItemsForRender();
        for (TravellingItem item : toRender) {
            Vec3d pos = item.getRenderPosition(BlockPos.field_177992_a, now, partialTicks);
            ItemStack stack = item.clientItemLink.get();
            if (stack != null && !stack.func_190926_b()) {
                if (item.stackSize != stack.func_190916_E()) {
                    stack = stack.func_77946_l();
                    stack.func_190920_e(item.stackSize);
                }
                ItemRenderUtil.renderItemStack(x + pos.field_72450_a, y + pos.field_72448_b, z + pos.field_72449_c, stack, lightc, item.getRenderDirection(now, partialTicks), vb);
            }
            if (item.colour == null) continue;
            vb.func_178969_c(x + pos.field_72450_a, y + pos.field_72448_b, z + pos.field_72449_c);
            int col = ColourUtil.getLightHex(item.colour);
            int r = col >> 16 & 0xFF;
            int g = col >> 8 & 0xFF;
            int b = col & 0xFF;
            for (MutableQuad q : COLOURED_QUADS) {
                MutableQuad q2 = new MutableQuad(q);
                q2.lighti(lightc);
                q2.multColouri(r, g, b, 255);
                q2.render(vb);
            }
            vb.func_178969_c(0.0, 0.0, 0.0);
        }
        ItemRenderUtil.endItemBatch();
    }

    static {
        COLOURED_QUADS = new MutableQuad[6];
    }
}

