/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.model.plug;

import buildcraft.lib.client.model.ModelItemSimple;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.transport.BCTransportModels;
import buildcraft.transport.item.ItemPluggableLens;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public enum ModelLensItem implements IBakedModel
{
    INSTANCE;

    private static final List<List<BakedQuad>> cached;

    public static void onModelBake() {
        cached.clear();
    }

    private static List<BakedQuad> getQuads(int damage) {
        if (damage < 0 || damage >= 34) {
            damage = 0;
        }
        if (cached.isEmpty()) {
            for (int i = 0; i < 34; ++i) {
                MutableQuad[] translucent;
                MutableQuad[] cutout;
                ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
                ItemPluggableLens.LensData data = new ItemPluggableLens.LensData(i);
                EnumFacing side = EnumFacing.WEST;
                if (data.isFilter) {
                    cutout = BCTransportModels.getFilterCutoutQuads(side, data.colour);
                    translucent = BCTransportModels.getFilterTranslucentQuads(side, data.colour);
                } else {
                    cutout = BCTransportModels.getLensCutoutQuads(side, data.colour);
                    translucent = BCTransportModels.getLensTranslucentQuads(side, data.colour);
                }
                for (MutableQuad q : cutout) {
                    list.add(q.toBakedItem());
                }
                for (MutableQuad q : translucent) {
                    list.add(q.toBakedItem());
                }
                cached.add(list);
            }
        }
        return cached.get(damage);
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        return ImmutableList.of();
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    public ItemCameraTransforms func_177552_f() {
        return ModelItemSimple.TRANSFORM_PLUG_AS_ITEM;
    }

    public ItemOverrideList func_188617_f() {
        return LensOverride.LENS_OVERRIDE;
    }

    static {
        cached = new ArrayList<List<BakedQuad>>(34);
    }

    public static class LensOverride
    extends ItemOverrideList {
        public static final LensOverride LENS_OVERRIDE = new LensOverride();

        private LensOverride() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            return new ModelItemSimple(ModelLensItem.getQuads(stack.func_77952_i()), ModelItemSimple.TRANSFORM_PLUG_AS_ITEM);
        }
    }
}

