/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.model;

import buildcraft.lib.client.model.ModelItemSimple;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.misc.StackUtil;
import buildcraft.transport.BCTransportModels;
import buildcraft.transport.gate.GateVariant;
import buildcraft.transport.item.ItemPluggableGate;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public enum ModelGateItem implements IBakedModel
{
    INSTANCE;

    private static final Map<GateVariant, List<BakedQuad>> cached;

    public static void onModelBake() {
        cached.clear();
    }

    private static List<BakedQuad> getQuads(GateVariant variant) {
        if (!cached.containsKey(variant)) {
            MutableQuad[] quads;
            ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
            for (MutableQuad q : quads = BCTransportModels.getGateStaticQuads(EnumFacing.WEST, variant)) {
                list.add(q.toBakedItem());
            }
            for (MutableQuad q : BCTransportModels.GATE_DYNAMIC.getCutoutQuads()) {
                list.add(q.toBakedItem());
            }
            cached.put(variant, list);
        }
        return cached.get(variant);
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        return ImmutableList.of();
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    public ItemCameraTransforms func_177552_f() {
        return ModelItemSimple.TRANSFORM_PLUG_AS_ITEM_BIGGER;
    }

    public ItemOverrideList func_188617_f() {
        return GateOverride.GATE_OVERRIDE;
    }

    static {
        cached = new HashMap<GateVariant, List<BakedQuad>>();
    }

    public static final class GateOverride
    extends ItemOverrideList {
        public static final GateOverride GATE_OVERRIDE = new GateOverride();

        private GateOverride() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            GateVariant variant = ItemPluggableGate.getVariant(StackUtil.asNonNull(stack));
            return new ModelItemSimple(ModelGateItem.getQuads(variant), ModelItemSimple.TRANSFORM_PLUG_AS_ITEM_BIGGER);
        }
    }
}

