/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.BCBlocks;
import buildcraft.api.BCItems;
import buildcraft.api.enums.EnumEngineType;
import buildcraft.api.enums.EnumRedstoneChipset;
import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.StackDefinition;
import buildcraft.core.BCCoreBlocks;
import buildcraft.core.BCCoreItems;
import buildcraft.lib.inventory.filter.ArrayStackFilter;
import buildcraft.lib.inventory.filter.OreStackFilter;
import buildcraft.lib.item.ItemBC_Neptune;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.lib.recipe.AssemblyRecipeRegistry;
import buildcraft.lib.recipe.NBTAwareShapedOreRecipe;
import buildcraft.lib.recipe.RecipeBuilderShaped;
import buildcraft.transport.BCTransportBlocks;
import buildcraft.transport.BCTransportItems;
import buildcraft.transport.gate.EnumGateLogic;
import buildcraft.transport.gate.EnumGateMaterial;
import buildcraft.transport.gate.EnumGateModifier;
import buildcraft.transport.gate.GateVariant;
import buildcraft.transport.item.ItemPipeHolder;
import buildcraft.transport.recipe.FacadeAssemblyRecipes;
import buildcraft.transport.recipe.FacadeSwapRecipe;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class BCTransportRecipes {
    public static void init() {
        Object builder;
        RecipeBuilderShaped builder2;
        if (BCTransportItems.waterproof != null) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)BCTransportItems.waterproof), (Object[])new Object[]{new ItemStack(Items.field_151100_aR, 1, 2)});
        }
        if (BCTransportBlocks.filteredBuffer != null) {
            builder2 = new RecipeBuilderShaped();
            builder2.add("wdw");
            builder2.add("wcw");
            builder2.add("wpw");
            builder2.map('w', "plankWood");
            builder2.map('p', Blocks.field_150331_J);
            builder2.map('c', Blocks.field_150486_ae);
            builder2.map('d', BCItems.TRANSPORT_PIPE_DIAMOND_ITEM, Items.field_151045_i);
            builder2.setResult(new ItemStack((Block)BCTransportBlocks.filteredBuffer));
            builder2.register();
        }
        if (BCTransportItems.pipeStructure != null) {
            builder2 = new RecipeBuilderShaped();
            builder2.add("cgc");
            builder2.map('c', "cobblestone");
            builder2.map('g', Blocks.field_150351_n);
            builder2.setResult(new ItemStack((Item)BCTransportItems.pipeStructure, 8));
            builder2.register();
        }
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemWood, "plankWood");
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemCobble, "cobblestone");
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemStone, "stone");
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemQuartz, "blockQuartz");
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemIron, "ingotIron");
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemGold, "ingotGold");
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemClay, Blocks.field_150435_aG);
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemSandstone, new ItemStack(Blocks.field_150322_A, 1, Short.MAX_VALUE));
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemVoid, new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLACK.func_176767_b()), "dustRedstone");
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemObsidian, Blocks.field_150343_Z);
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemDiamond, Items.field_151045_i);
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemLapis, Blocks.field_150368_y);
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemDaizuli, Blocks.field_150368_y, Items.field_151045_i);
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemDiaWood, "plankWood", Items.field_151045_i);
        ItemBC_Neptune waterproof = BCTransportItems.waterproof;
        if (waterproof == null) {
            waterproof = Items.field_151123_aH;
        }
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemWood, BCTransportItems.pipeFluidWood, waterproof);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemCobble, BCTransportItems.pipeFluidCobble, waterproof);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemStone, BCTransportItems.pipeFluidStone, waterproof);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemQuartz, BCTransportItems.pipeFluidQuartz, waterproof);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemIron, BCTransportItems.pipeFluidIron, waterproof);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemGold, BCTransportItems.pipeFluidGold, waterproof);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemClay, BCTransportItems.pipeFluidClay, waterproof);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemSandstone, BCTransportItems.pipeFluidSandstone, waterproof);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemVoid, BCTransportItems.pipeFluidVoid, waterproof);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemObsidian, BCTransportItems.pipeFluidObsidian, waterproof);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemDiamond, BCTransportItems.pipeFluidDiamond, waterproof);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemDiaWood, BCTransportItems.pipeFluidDiaWood, waterproof);
        String upgrade = "dustRedstone";
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemWood, BCTransportItems.pipePowerWood, upgrade);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemCobble, BCTransportItems.pipePowerCobble, upgrade);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemStone, BCTransportItems.pipePowerStone, upgrade);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemQuartz, BCTransportItems.pipePowerQuartz, upgrade);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemGold, BCTransportItems.pipePowerGold, upgrade);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemSandstone, BCTransportItems.pipePowerSandstone, upgrade);
        if (BCTransportItems.plugBlocker != null) {
            builder = new RecipeBuilderShaped();
            ((RecipeBuilderShaped)builder).add("s");
            ((RecipeBuilderShaped)builder).map('s', BCTransportItems.pipeStructure);
            ((RecipeBuilderShaped)builder).setResult(new ItemStack((Item)BCTransportItems.plugBlocker, 4));
            ((RecipeBuilderShaped)builder).register();
        }
        if (BCTransportItems.plugPulsar != null) {
            ItemStack output = new ItemStack((Item)BCTransportItems.plugPulsar);
            ItemStack redstoneEngine = BCCoreBlocks.engine != null && BCCoreBlocks.engine.isRegistered(EnumEngineType.WOOD) ? BCCoreBlocks.engine.getStack(EnumEngineType.WOOD) : new ItemStack(Blocks.field_150451_bX);
            if (BCBlocks.SILICON_TABLE_ASSEMBLY != null) {
                HashSet<StackDefinition> input = new HashSet<StackDefinition>();
                input.add(ArrayStackFilter.definition(redstoneEngine));
                input.add(OreStackFilter.definition(2, "ingotIron"));
                EnumGateMaterial[] recipe = new AssemblyRecipe("plug_pulsar", 1000000000L, input, output);
                AssemblyRecipeRegistry.INSTANCE.addRecipe((AssemblyRecipe)recipe);
            } else {
                RecipeBuilderShaped builder3 = new RecipeBuilderShaped();
                builder3.add("rer");
                builder3.add("gpg");
                builder3.map('p', BCTransportItems.plugBlocker, Blocks.field_150347_e);
                builder3.map('r', "dustRedstone");
                builder3.map('e', redstoneEngine);
                builder3.map('g', "gearIron");
                builder3.setResult(output);
                builder3.register();
            }
        }
        if (BCTransportItems.plugGate != null) {
            builder = new RecipeBuilderShaped();
            ((RecipeBuilderShaped)builder).add(" m ");
            ((RecipeBuilderShaped)builder).add("mrm");
            ((RecipeBuilderShaped)builder).add(" b ");
            ((RecipeBuilderShaped)builder).map('r', "dustRedstone");
            ((RecipeBuilderShaped)builder).map('b', BCTransportItems.plugBlocker, Blocks.field_150347_e);
            ((RecipeBuilderShaped)builder).map('m', Items.field_151118_aC);
            BCTransportRecipes.makeGateRecipe((RecipeBuilderShaped)builder, EnumGateMaterial.CLAY_BRICK, EnumGateModifier.NO_MODIFIER);
            ((RecipeBuilderShaped)builder).map('m', "ingotIron");
            BCTransportRecipes.makeGateRecipe((RecipeBuilderShaped)builder, EnumGateMaterial.IRON, EnumGateModifier.NO_MODIFIER);
            ((RecipeBuilderShaped)builder).map('m', Items.field_151130_bT);
            BCTransportRecipes.makeGateRecipe((RecipeBuilderShaped)builder, EnumGateMaterial.NETHER_BRICK, EnumGateModifier.NO_MODIFIER);
            GateVariant variant = new GateVariant(EnumGateLogic.AND, EnumGateMaterial.IRON, EnumGateModifier.NO_MODIFIER);
            ItemStack ironGateBase = BCTransportItems.plugGate.getStack(variant);
            builder = new RecipeBuilderShaped();
            ((RecipeBuilderShaped)builder).add(" m ");
            ((RecipeBuilderShaped)builder).add("mgm");
            ((RecipeBuilderShaped)builder).add(" m ");
            ((RecipeBuilderShaped)builder).map('g', ironGateBase);
            ((RecipeBuilderShaped)builder).map('m', new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()));
            BCTransportRecipes.makeGateRecipe((RecipeBuilderShaped)builder, EnumGateMaterial.IRON, EnumGateModifier.LAPIS);
            ((RecipeBuilderShaped)builder).map('m', Items.field_151128_bU);
            BCTransportRecipes.makeGateRecipe((RecipeBuilderShaped)builder, EnumGateMaterial.IRON, EnumGateModifier.QUARTZ);
            if (BCCoreItems.diamondShard != null) {
                ((RecipeBuilderShaped)builder).map('m', BCCoreItems.diamondShard);
                BCTransportRecipes.makeGateRecipe((RecipeBuilderShaped)builder, EnumGateMaterial.IRON, EnumGateModifier.DIAMOND);
            }
            for (EnumGateMaterial material : EnumGateMaterial.VALUES) {
                if (material == EnumGateMaterial.CLAY_BRICK) continue;
                for (EnumGateModifier modifier : EnumGateModifier.VALUES) {
                    GateVariant varAnd = new GateVariant(EnumGateLogic.AND, material, modifier);
                    ItemStack resultAnd = BCTransportItems.plugGate.getStack(varAnd);
                    GateVariant varOr = new GateVariant(EnumGateLogic.OR, material, modifier);
                    ItemStack resultOr = BCTransportItems.plugGate.getStack(varOr);
                    GameRegistry.addRecipe((IRecipe)new NBTAwareShapedOreRecipe(resultAnd, "i", Character.valueOf('i'), resultOr));
                    GameRegistry.addRecipe((IRecipe)new NBTAwareShapedOreRecipe(resultOr, "i", Character.valueOf('i'), resultAnd));
                }
            }
            StackDefinition lapis = OreStackFilter.definition("gemLapis");
            BCTransportRecipes.makeGateAssembly(20000, EnumGateMaterial.IRON, EnumGateModifier.NO_MODIFIER, EnumRedstoneChipset.IRON, new StackDefinition[0]);
            BCTransportRecipes.makeGateAssembly(40000, EnumGateMaterial.NETHER_BRICK, EnumGateModifier.NO_MODIFIER, EnumRedstoneChipset.IRON, ArrayStackFilter.definition(new ItemStack(Blocks.field_150385_bj)));
            BCTransportRecipes.makeGateAssembly(80000, EnumGateMaterial.GOLD, EnumGateModifier.NO_MODIFIER, EnumRedstoneChipset.GOLD, new StackDefinition[0]);
            BCTransportRecipes.makeGateModifierAssembly(40000, EnumGateMaterial.IRON, EnumGateModifier.LAPIS, lapis);
            BCTransportRecipes.makeGateModifierAssembly(60000, EnumGateMaterial.IRON, EnumGateModifier.QUARTZ, ArrayStackFilter.definition(EnumRedstoneChipset.QUARTZ.getStack()));
            BCTransportRecipes.makeGateModifierAssembly(80000, EnumGateMaterial.IRON, EnumGateModifier.DIAMOND, ArrayStackFilter.definition(EnumRedstoneChipset.DIAMOND.getStack()));
            BCTransportRecipes.makeGateModifierAssembly(80000, EnumGateMaterial.NETHER_BRICK, EnumGateModifier.LAPIS, lapis);
            BCTransportRecipes.makeGateModifierAssembly(100000, EnumGateMaterial.NETHER_BRICK, EnumGateModifier.QUARTZ, ArrayStackFilter.definition(EnumRedstoneChipset.QUARTZ.getStack()));
            BCTransportRecipes.makeGateModifierAssembly(120000, EnumGateMaterial.NETHER_BRICK, EnumGateModifier.DIAMOND, ArrayStackFilter.definition(EnumRedstoneChipset.DIAMOND.getStack()));
            BCTransportRecipes.makeGateModifierAssembly(100000, EnumGateMaterial.GOLD, EnumGateModifier.LAPIS, lapis);
            BCTransportRecipes.makeGateModifierAssembly(140000, EnumGateMaterial.GOLD, EnumGateModifier.QUARTZ, ArrayStackFilter.definition(EnumRedstoneChipset.QUARTZ.getStack()));
            BCTransportRecipes.makeGateModifierAssembly(180000, EnumGateMaterial.GOLD, EnumGateModifier.DIAMOND, ArrayStackFilter.definition(EnumRedstoneChipset.DIAMOND.getStack()));
        }
        if (BCTransportItems.wire != null) {
            for (EnumDyeColor color : ColourUtil.COLOURS) {
                String name = String.format("wire-%s", color.func_176762_d());
                ImmutableSet input = ImmutableSet.of((Object)OreStackFilter.definition("dustRedstone"), (Object)OreStackFilter.definition(ColourUtil.getDyeName(color)));
                AssemblyRecipeRegistry.INSTANCE.addRecipe(new AssemblyRecipe(name, 10000000000L, (Set<StackDefinition>)input, new ItemStack((Item)BCTransportItems.wire, 8, color.func_176765_a())));
            }
        }
        if (BCTransportItems.plugLens != null) {
            for (EnumDyeColor colour : ColourUtil.COLOURS) {
                String name = String.format("lens-regular-%s", colour.func_176762_d());
                StackDefinition stainedGlass = OreStackFilter.definition("blockGlass" + ColourUtil.getName(colour));
                ImmutableSet input = ImmutableSet.of((Object)stainedGlass);
                ItemStack output = BCTransportItems.plugLens.getStack(colour, false);
                AssemblyRecipeRegistry.INSTANCE.addRecipe(new AssemblyRecipe(name, 500000000L, (Set<StackDefinition>)input, output));
                name = String.format("lens-filter-%s", colour.func_176762_d());
                output = BCTransportItems.plugLens.getStack(colour, true);
                input = ImmutableSet.of((Object)stainedGlass, (Object)ArrayStackFilter.definition(new ItemStack(Blocks.field_150411_aY)));
                AssemblyRecipeRegistry.INSTANCE.addRecipe(new AssemblyRecipe(name, 500000000L, (Set<StackDefinition>)input, output));
            }
            StackDefinition glass = OreStackFilter.definition("blockGlass");
            ImmutableSet input = ImmutableSet.of((Object)glass);
            ItemStack output = BCTransportItems.plugLens.getStack(null, false);
            AssemblyRecipeRegistry.INSTANCE.addRecipe(new AssemblyRecipe("lens-regular", 500000000L, (Set<StackDefinition>)input, output));
            output = BCTransportItems.plugLens.getStack(null, true);
            input = ImmutableSet.of((Object)glass, (Object)ArrayStackFilter.definition(new ItemStack(Blocks.field_150411_aY)));
            AssemblyRecipeRegistry.INSTANCE.addRecipe(new AssemblyRecipe("lens-filter", 500000000L, (Set<StackDefinition>)input, output));
        }
        if (BCTransportItems.plugLightSensor != null) {
            BuildcraftRecipeRegistry.assemblyRecipes.addRecipe(new AssemblyRecipe("light-sensor", 500000000L, (Set<StackDefinition>)ImmutableSet.of((Object)ArrayStackFilter.definition(new Block[]{Blocks.field_150453_bW})), new ItemStack((Item)BCTransportItems.plugLightSensor)));
        }
        if (BCTransportItems.plugFacade != null) {
            AssemblyRecipeRegistry.INSTANCE.addRecipeProvider(FacadeAssemblyRecipes.INSTANCE);
            RecipeSorter.register((String)"buildcraftlib:facade_swap", FacadeSwapRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"before:minecraft:shapeless");
            GameRegistry.addRecipe((IRecipe)FacadeSwapRecipe.INSTANCE);
        }
    }

    private static void makeGateModifierAssembly(int multiplier, EnumGateMaterial material, EnumGateModifier modifier, StackDefinition ... mods) {
        for (EnumGateLogic logic : EnumGateLogic.VALUES) {
            String name = String.format("gate-modifier-%s-%s-%s", new Object[]{logic, material, modifier});
            ItemStack toUpgrade = BCTransportItems.plugGate.getStack(new GateVariant(logic, material, EnumGateModifier.NO_MODIFIER));
            ItemStack output = BCTransportItems.plugGate.getStack(new GateVariant(logic, material, modifier));
            ImmutableSet input = new ImmutableSet.Builder().add((Object)ArrayStackFilter.definition(toUpgrade)).add((Object[])mods).build();
            AssemblyRecipeRegistry.INSTANCE.addRecipe(new AssemblyRecipe(name, 1000000L * (long)multiplier, (Set<StackDefinition>)input, output));
        }
    }

    private static void makeGateAssembly(int multiplier, EnumGateMaterial material, EnumGateModifier modifier, EnumRedstoneChipset chipset, StackDefinition ... additional) {
        ImmutableSet.Builder temp = ImmutableSet.builder();
        temp.add((Object)ArrayStackFilter.definition(chipset.getStack()));
        temp.add((Object[])additional);
        ImmutableSet input = temp.build();
        String name = String.format("gate-and-%s-%s", new Object[]{material, modifier});
        ItemStack output = BCTransportItems.plugGate.getStack(new GateVariant(EnumGateLogic.AND, material, modifier));
        AssemblyRecipeRegistry.INSTANCE.addRecipe(new AssemblyRecipe(name, 1000000L * (long)multiplier, (Set<StackDefinition>)input, output));
        name = String.format("gate-or-%s-%s", new Object[]{material, modifier});
        output = BCTransportItems.plugGate.getStack(new GateVariant(EnumGateLogic.OR, material, modifier));
        AssemblyRecipeRegistry.INSTANCE.addRecipe(new AssemblyRecipe(name, 1000000L * (long)multiplier, (Set<StackDefinition>)input, output));
    }

    private static void makeGateRecipe(RecipeBuilderShaped builder, EnumGateMaterial material, EnumGateModifier modifier) {
        GateVariant variant = new GateVariant(EnumGateLogic.AND, material, modifier);
        builder.setResult(BCTransportItems.plugGate.getStack(variant));
        builder.registerNbtAware();
    }

    private static void addPipeRecipe(ItemPipeHolder pipe, Object material) {
        BCTransportRecipes.addPipeRecipe(pipe, material, material);
    }

    private static void addPipeRecipe(ItemPipeHolder pipe, Object left, Object right) {
        if (pipe == null) {
            return;
        }
        RecipeBuilderShaped pipeBuilderSingle = new RecipeBuilderShaped();
        pipeBuilderSingle.add("lgr");
        pipeBuilderSingle.map('l', left);
        pipeBuilderSingle.map('r', right);
        pipeBuilderSingle.map('g', "blockGlassColorless");
        pipeBuilderSingle.setResult(new ItemStack((Item)pipe, 8, 0));
        pipeBuilderSingle.register();
        for (EnumDyeColor colour : EnumDyeColor.values()) {
            pipeBuilderSingle.map('g', "blockGlass" + ColourUtil.getName(colour));
            pipeBuilderSingle.setResult(new ItemStack((Item)pipe, 8, colour.func_176765_a() + 1));
            pipeBuilderSingle.register();
        }
    }

    private static void addPipeUpgradeRecipe(ItemPipeHolder from, ItemPipeHolder to, Object additional) {
        if (from == null || to == null) {
            return;
        }
        if (additional == null) {
            throw new NullPointerException("additional");
        }
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)from), (Object[])new Object[]{new ItemStack((Item)to)});
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)to), new Object[]{new ItemStack((Item)from), additional}));
        for (EnumDyeColor colour : ColourUtil.COLOURS) {
            ItemStack f = new ItemStack((Item)from, 1, colour.func_176765_a() + 1);
            ItemStack t = new ItemStack((Item)to, 1, colour.func_176765_a() + 1);
            GameRegistry.addShapelessRecipe((ItemStack)f, (Object[])new Object[]{t});
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(t, new Object[]{f, additional}));
        }
    }
}

