/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.PipeApiClient;
import buildcraft.api.transport.pipe.PipeBehaviour;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.transport.BCTransportBlocks;
import buildcraft.transport.BCTransportGuis;
import buildcraft.transport.BCTransportItems;
import buildcraft.transport.BCTransportModels;
import buildcraft.transport.BCTransportSprites;
import buildcraft.transport.client.PipeRegistryClient;
import buildcraft.transport.container.ContainerDiamondPipe;
import buildcraft.transport.container.ContainerDiamondWoodPipe;
import buildcraft.transport.container.ContainerEmzuliPipe_BC8;
import buildcraft.transport.container.ContainerFilteredBuffer_BC8;
import buildcraft.transport.container.ContainerGate;
import buildcraft.transport.gui.GuiDiamondPipe;
import buildcraft.transport.gui.GuiDiamondWoodPipe;
import buildcraft.transport.gui.GuiEmzuliPipe_BC8;
import buildcraft.transport.gui.GuiFilteredBuffer;
import buildcraft.transport.gui.GuiGate;
import buildcraft.transport.item.ItemPluggableFacade;
import buildcraft.transport.pipe.behaviour.PipeBehaviourDiamond;
import buildcraft.transport.pipe.behaviour.PipeBehaviourEmzuli;
import buildcraft.transport.pipe.behaviour.PipeBehaviourWoodDiamond;
import buildcraft.transport.plug.FacadeInstance;
import buildcraft.transport.plug.FacadePhasedState;
import buildcraft.transport.plug.PluggableGate;
import buildcraft.transport.tile.TileFilteredBuffer;
import buildcraft.transport.tile.TilePipeHolder;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BCTransportProxy
implements IGuiHandler {
    @SidedProxy(modId="buildcrafttransport")
    private static BCTransportProxy proxy;

    public static BCTransportProxy getProxy() {
        return proxy;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        BCTransportGuis gui = BCTransportGuis.get(id);
        if (gui == null) {
            return null;
        }
        TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
        switch (gui) {
            case FILTERED_BUFFER: {
                if (!(tile instanceof TileFilteredBuffer)) break;
                TileFilteredBuffer filteredBuffer = (TileFilteredBuffer)tile;
                return new ContainerFilteredBuffer_BC8(player, filteredBuffer);
            }
            case PIPE_DIAMOND: {
                if (!(tile instanceof IPipeHolder)) break;
                IPipeHolder holder = (IPipeHolder)tile;
                IPipe pipe = holder.getPipe();
                if (pipe == null) {
                    return null;
                }
                PipeBehaviour behaviour = pipe.getBehaviour();
                if (!(behaviour instanceof PipeBehaviourDiamond)) break;
                PipeBehaviourDiamond diaPipe = (PipeBehaviourDiamond)behaviour;
                return new ContainerDiamondPipe(player, diaPipe);
            }
            case PIPE_DIAMOND_WOOD: {
                if (!(tile instanceof IPipeHolder)) break;
                IPipeHolder holder = (IPipeHolder)tile;
                IPipe pipe = holder.getPipe();
                if (pipe == null) {
                    return null;
                }
                PipeBehaviour behaviour = pipe.getBehaviour();
                if (!(behaviour instanceof PipeBehaviourWoodDiamond)) break;
                PipeBehaviourWoodDiamond diaPipe = (PipeBehaviourWoodDiamond)behaviour;
                return new ContainerDiamondWoodPipe(player, diaPipe);
            }
            case PIPE_EMZULI: {
                if (!(tile instanceof IPipeHolder)) break;
                IPipeHolder holder = (IPipeHolder)tile;
                IPipe pipe = holder.getPipe();
                if (pipe == null) {
                    return null;
                }
                PipeBehaviour behaviour = pipe.getBehaviour();
                if (!(behaviour instanceof PipeBehaviourEmzuli)) break;
                PipeBehaviourEmzuli emPipe = (PipeBehaviourEmzuli)behaviour;
                return new ContainerEmzuliPipe_BC8(player, emPipe);
            }
            case GATE: {
                IPipeHolder holder;
                PipePluggable plug;
                int ry = y >> 3;
                EnumFacing gateSide = EnumFacing.func_82600_a((int)(y & 7));
                tile = world.func_175625_s(new BlockPos(x, ry, z));
                if (!(tile instanceof IPipeHolder) || !((plug = (holder = (IPipeHolder)tile).getPluggable(gateSide)) instanceof PluggableGate)) break;
                return new ContainerGate(player, ((PluggableGate)plug).logic);
            }
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public void fmlPreInit() {
    }

    public void fmlInit() {
    }

    public void fmlPostInit() {
    }

    @SideOnly(value=Side.CLIENT)
    public static class ClientProxy
    extends BCTransportProxy {
        @Override
        public void fmlPreInit() {
            BCTransportSprites.fmlPreInit();
            BCTransportModels.fmlPreInit();
            PipeApiClient.registry = PipeRegistryClient.INSTANCE;
        }

        @Override
        public void fmlInit() {
            BCTransportModels.fmlInit();
        }

        @Override
        public void fmlPostInit() {
            Minecraft.func_71410_x().func_184125_al().func_186722_a((state, world, pos, tintIndex) -> {
                EnumFacing side;
                TilePipeHolder tilePipeHolder;
                PipePluggable pluggable;
                TileEntity tile;
                if (world != null && pos != null && (tile = world.func_175625_s(pos)) instanceof TilePipeHolder && (pluggable = (tilePipeHolder = (TilePipeHolder)tile).getPluggable(side = EnumFacing.func_82600_a((int)(tintIndex % EnumFacing.field_82609_l.length)))) != null) {
                    return pluggable.getBlockColor(tintIndex / 6);
                }
                return -1;
            }, new Block[]{BCTransportBlocks.pipeHolder});
            Minecraft.func_71410_x().getItemColors().func_186730_a((item, tintIndex) -> {
                FacadeInstance states = ItemPluggableFacade.getStates(item);
                FacadePhasedState state = states.getCurrentStateForStack();
                return Minecraft.func_71410_x().func_184125_al().func_189991_a(state.stateInfo.state);
            }, new Item[]{BCTransportItems.plugFacade});
        }

        @Override
        public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            BCTransportGuis gui = BCTransportGuis.get(id);
            if (gui == null) {
                return null;
            }
            TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
            switch (gui) {
                case FILTERED_BUFFER: {
                    if (!(tile instanceof TileFilteredBuffer)) break;
                    TileFilteredBuffer filteredBuffer = (TileFilteredBuffer)tile;
                    return new GuiFilteredBuffer(new ContainerFilteredBuffer_BC8(player, filteredBuffer));
                }
                case PIPE_DIAMOND: {
                    if (!(tile instanceof IPipeHolder)) break;
                    IPipeHolder holder = (IPipeHolder)tile;
                    IPipe pipe = holder.getPipe();
                    if (pipe == null) {
                        return null;
                    }
                    PipeBehaviour behaviour = pipe.getBehaviour();
                    if (!(behaviour instanceof PipeBehaviourDiamond)) break;
                    PipeBehaviourDiamond diaPipe = (PipeBehaviourDiamond)behaviour;
                    return new GuiDiamondPipe(player, diaPipe);
                }
                case PIPE_DIAMOND_WOOD: {
                    if (!(tile instanceof IPipeHolder)) break;
                    IPipeHolder holder = (IPipeHolder)tile;
                    IPipe pipe = holder.getPipe();
                    if (pipe == null) {
                        return null;
                    }
                    PipeBehaviour behaviour = pipe.getBehaviour();
                    if (!(behaviour instanceof PipeBehaviourWoodDiamond)) break;
                    PipeBehaviourWoodDiamond diaPipe = (PipeBehaviourWoodDiamond)behaviour;
                    return new GuiDiamondWoodPipe(player, diaPipe);
                }
                case PIPE_EMZULI: {
                    if (!(tile instanceof IPipeHolder)) break;
                    IPipeHolder holder = (IPipeHolder)tile;
                    IPipe pipe = holder.getPipe();
                    if (pipe == null) {
                        return null;
                    }
                    PipeBehaviour behaviour = pipe.getBehaviour();
                    if (!(behaviour instanceof PipeBehaviourEmzuli)) break;
                    PipeBehaviourEmzuli emzPipe = (PipeBehaviourEmzuli)behaviour;
                    return new GuiEmzuliPipe_BC8(player, emzPipe);
                }
                case GATE: {
                    IPipeHolder holder;
                    PipePluggable plug;
                    int ry = y >> 3;
                    EnumFacing gateSide = EnumFacing.func_82600_a((int)(y & 7));
                    tile = world.func_175625_s(new BlockPos(x, ry, z));
                    if (!(tile instanceof IPipeHolder) || !((plug = (holder = (IPipeHolder)tile).getPluggable(gateSide)) instanceof PluggableGate)) break;
                    return new GuiGate(new ContainerGate(player, ((PluggableGate)plug).logic));
                }
            }
            return null;
        }
    }

    @SideOnly(value=Side.SERVER)
    public static class ServerProxy
    extends BCTransportProxy {
    }
}

