/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.transport.pipe.PipeApiClient;
import buildcraft.api.transport.pluggable.IPluggableStaticBaker;
import buildcraft.lib.client.model.ModelHolderStatic;
import buildcraft.lib.client.model.ModelHolderVariable;
import buildcraft.lib.client.model.ModelPluggableItem;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.expression.DefaultContexts;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.node.value.NodeVariableString;
import buildcraft.lib.misc.data.ModelVariableData;
import buildcraft.transport.BCTransportItems;
import buildcraft.transport.client.model.GateMeshDefinition;
import buildcraft.transport.client.model.ModelGateItem;
import buildcraft.transport.client.model.ModelPipe;
import buildcraft.transport.client.model.ModelPipeItem;
import buildcraft.transport.client.model.key.KeyPlugBlocker;
import buildcraft.transport.client.model.key.KeyPlugFacade;
import buildcraft.transport.client.model.key.KeyPlugGate;
import buildcraft.transport.client.model.key.KeyPlugLens;
import buildcraft.transport.client.model.key.KeyPlugLightSensor;
import buildcraft.transport.client.model.key.KeyPlugPulsar;
import buildcraft.transport.client.model.plug.ModelFacadeItem;
import buildcraft.transport.client.model.plug.ModelLensItem;
import buildcraft.transport.client.model.plug.PlugBakerFacade;
import buildcraft.transport.client.model.plug.PlugBakerLens;
import buildcraft.transport.client.model.plug.PlugBakerSimple;
import buildcraft.transport.client.model.plug.PlugGateBaker;
import buildcraft.transport.client.render.PipeBehaviourRendererStripes;
import buildcraft.transport.client.render.PipeFlowRendererFluids;
import buildcraft.transport.client.render.PipeFlowRendererItems;
import buildcraft.transport.client.render.PipeFlowRendererPower;
import buildcraft.transport.client.render.PlugGateRenderer;
import buildcraft.transport.client.render.PlugPulsarRenderer;
import buildcraft.transport.client.render.RenderPipeHolder;
import buildcraft.transport.gate.GateVariant;
import buildcraft.transport.pipe.behaviour.PipeBehaviourStripes;
import buildcraft.transport.pipe.flow.PipeFlowFluids;
import buildcraft.transport.pipe.flow.PipeFlowItems;
import buildcraft.transport.pipe.flow.PipeFlowPower;
import buildcraft.transport.plug.PluggableGate;
import buildcraft.transport.plug.PluggablePulsar;
import buildcraft.transport.tile.TilePipeHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BCTransportModels {
    public static final ModelHolderStatic BLOCKER = BCTransportModels.getModel("plugs/blocker.json");
    public static final ModelHolderStatic LIGHT_SENSOR = BCTransportModels.getModel("plugs/light_sensor.json");
    public static final ModelHolderStatic POWER_ADAPTER = BCTransportModels.getModel("plugs/power_adapter.json");
    public static final ModelHolderVariable GATE_STATIC;
    public static final ModelHolderVariable GATE_DYNAMIC;
    private static final ModelVariableData GATE_VAR_DATA_STATIC;
    private static final ModelHolderVariable LENS;
    private static final ModelHolderVariable FILTER;
    private static final NodeVariableString LENS_COLOUR;
    private static final NodeVariableString LENS_SIDE;
    public static final ModelHolderStatic PULSAR_STATIC;
    public static final ModelHolderVariable PULSAR_DYNAMIC;
    private static final ModelHolderVariable STRIPES;
    private static final NodeVariableString STRIPES_DIRECTION;
    public static final IPluggableStaticBaker<KeyPlugPulsar> BAKER_PLUG_PULSAR;
    public static final IPluggableStaticBaker<KeyPlugBlocker> BAKER_PLUG_BLOCKER;
    public static final IPluggableStaticBaker<KeyPlugLightSensor> BAKER_PLUG_LIGHT_SENSOR;

    private static ModelHolderStatic getModel(String loc) {
        return BCTransportModels.getModel(loc, null, false);
    }

    private static ModelHolderStatic getModel(String loc, String[][] textures, boolean allowTextureFallthrough) {
        return new ModelHolderStatic("buildcrafttransport:models/" + loc, textures, allowTextureFallthrough);
    }

    private static ModelHolderVariable getModel(String loc, FunctionContext fnCtx) {
        return new ModelHolderVariable("buildcrafttransport:models/" + loc, fnCtx);
    }

    public static void fmlPreInit() {
        MinecraftForge.EVENT_BUS.register(BCTransportModels.class);
    }

    public static void fmlInit() {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178080_a((Item)BCTransportItems.plugGate, (ItemMeshDefinition)GateMeshDefinition.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TilePipeHolder.class, (TileEntitySpecialRenderer)new RenderPipeHolder());
        PipeApiClient.registry.registerBaker(KeyPlugGate.class, PlugGateBaker.INSTANCE);
        PipeApiClient.registry.registerBaker(KeyPlugBlocker.class, BAKER_PLUG_BLOCKER);
        PipeApiClient.registry.registerBaker(KeyPlugPulsar.class, BAKER_PLUG_PULSAR);
        PipeApiClient.registry.registerBaker(KeyPlugLightSensor.class, BAKER_PLUG_LIGHT_SENSOR);
        PipeApiClient.registry.registerBaker(KeyPlugLens.class, PlugBakerLens.INSTANCE);
        PipeApiClient.registry.registerBaker(KeyPlugFacade.class, PlugBakerFacade.INSTANCE);
        PipeApiClient.registry.registerRenderer(PluggableGate.class, PlugGateRenderer.INSTANCE);
        PipeApiClient.registry.registerRenderer(PluggablePulsar.class, PlugPulsarRenderer.INSTANCE);
        PipeApiClient.registry.registerRenderer(PipeFlowItems.class, PipeFlowRendererItems.INSTANCE);
        PipeApiClient.registry.registerRenderer(PipeFlowFluids.class, PipeFlowRendererFluids.INSTANCE);
        PipeApiClient.registry.registerRenderer(PipeFlowPower.class, PipeFlowRendererPower.INSTANCE);
        PipeApiClient.registry.registerRenderer(PipeBehaviourStripes.class, PipeBehaviourRendererStripes.INSTANCE);
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        IRegistry modelRegistry = event.getModelRegistry();
        String start = "buildcrafttransport:";
        BCTransportModels.registerModel((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, start + "pipe_holder#normal", ModelPipe.INSTANCE);
        BCTransportModels.registerModel((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, start + "pipe_item#inventory", ModelPipeItem.INSTANCE);
        BCTransportModels.registerModel((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, start + "gate_item#inventory", ModelGateItem.INSTANCE);
        BCTransportModels.registerModel((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, start + "lens_item#inventory", ModelLensItem.INSTANCE);
        BCTransportModels.registerModel((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, start + "plug_blocker#inventory", new ModelPluggableItem(new MutableQuad[][]{BLOCKER.getCutoutQuads()}));
        PluggablePulsar.setModelVariablesForItem();
        BCTransportModels.registerModel((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, start + "plug_pulsar#inventory", new ModelPluggableItem(PULSAR_STATIC.getCutoutQuads(), PULSAR_DYNAMIC.getCutoutQuads()));
        BCTransportModels.registerModel((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, start + "plug_light_sensor#inventory", new ModelPluggableItem(new MutableQuad[][]{LIGHT_SENSOR.getCutoutQuads()}));
        BCTransportModels.registerModel((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, start + "plug_facade#inventory", ModelFacadeItem.INSTANCE);
        PlugGateBaker.onModelBake();
        PlugBakerLens.onModelBake();
        ModelGateItem.onModelBake();
        ModelLensItem.onModelBake();
        ModelFacadeItem.onModelBake();
        PlugPulsarRenderer.onModelBake();
        PlugGateRenderer.onModelBake();
    }

    private static void registerModel(IRegistry<ModelResourceLocation, IBakedModel> modelRegistry, String reg, IBakedModel val) {
        modelRegistry.func_82595_a((Object)new ModelResourceLocation(reg), (Object)val);
    }

    public static MutableQuad[] getGateStaticQuads(EnumFacing side, GateVariant variant) {
        PluggableGate.setClientModelVariables(side, variant);
        if (GATE_VAR_DATA_STATIC.hasNoNodes()) {
            GATE_VAR_DATA_STATIC.setNodes(GATE_STATIC.createTickableNodes());
        }
        GATE_VAR_DATA_STATIC.refresh();
        return GATE_STATIC.getCutoutQuads();
    }

    private static void setupLensVariables(ModelHolderVariable model, EnumFacing side, EnumDyeColor colour) {
        BCTransportModels.LENS_COLOUR.value = colour == null ? "clear" : colour.func_176610_l();
        BCTransportModels.LENS_SIDE.value = side.func_176610_l();
        ModelVariableData varData = new ModelVariableData();
        varData.setNodes(model.createTickableNodes());
        varData.tick();
        varData.refresh();
    }

    public static MutableQuad[] getLensCutoutQuads(EnumFacing side, EnumDyeColor colour) {
        BCTransportModels.setupLensVariables(LENS, side, colour);
        return LENS.getCutoutQuads();
    }

    public static MutableQuad[] getLensTranslucentQuads(EnumFacing side, EnumDyeColor colour) {
        BCTransportModels.setupLensVariables(LENS, side, colour);
        return LENS.getTranslucentQuads();
    }

    public static MutableQuad[] getFilterCutoutQuads(EnumFacing side, EnumDyeColor colour) {
        BCTransportModels.setupLensVariables(FILTER, side, colour);
        return FILTER.getCutoutQuads();
    }

    public static MutableQuad[] getFilterTranslucentQuads(EnumFacing side, EnumDyeColor colour) {
        BCTransportModels.setupLensVariables(FILTER, side, colour);
        return FILTER.getTranslucentQuads();
    }

    public static MutableQuad[] getStripesDynQuads(EnumFacing side) {
        BCTransportModels.STRIPES_DIRECTION.value = side.func_176610_l();
        return STRIPES.getCutoutQuads();
    }

    static {
        PULSAR_STATIC = BCTransportModels.getModel("plugs/pulsar_static.json");
        GATE_STATIC = BCTransportModels.getModel("plugs/gate.json", PluggableGate.MODEL_FUNC_CTX_STATIC);
        GATE_DYNAMIC = BCTransportModels.getModel("plugs/gate_dynamic.json", PluggableGate.MODEL_FUNC_CTX_DYNAMIC);
        GATE_VAR_DATA_STATIC = new ModelVariableData();
        FunctionContext fnCtx = DefaultContexts.createWithAll();
        LENS_COLOUR = fnCtx.putVariableString("colour");
        LENS_SIDE = fnCtx.putVariableString("side");
        LENS = BCTransportModels.getModel("plugs/lens.json", fnCtx);
        FILTER = BCTransportModels.getModel("plugs/filter.json", fnCtx);
        PULSAR_DYNAMIC = BCTransportModels.getModel("plugs/pulsar_dynamic.json", PluggablePulsar.MODEL_FUNC_CTX);
        fnCtx = DefaultContexts.createWithAll();
        STRIPES_DIRECTION = fnCtx.putVariableString("side");
        STRIPES = BCTransportModels.getModel("pipes/stripes.json", fnCtx);
        BAKER_PLUG_PULSAR = new PlugBakerSimple<KeyPlugPulsar>(PULSAR_STATIC::getCutoutQuads);
        BAKER_PLUG_BLOCKER = new PlugBakerSimple<KeyPlugBlocker>(BLOCKER::getCutoutQuads);
        BAKER_PLUG_LIGHT_SENSOR = new PlugBakerSimple<KeyPlugLightSensor>(LIGHT_SENSOR::getCutoutQuads);
    }
}

