/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.BCModules;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.api.transport.pipe.PipeDefinition;
import buildcraft.core.BCCoreConfig;
import buildcraft.lib.config.EnumRestartRequirement;
import buildcraft.lib.misc.ConfigUtil;
import buildcraft.lib.misc.MathUtil;
import buildcraft.transport.BCTransportPipes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BCTransportConfig {
    private static final long MJ_REQ_MILLIBUCKET_MIN = 100L;
    private static final long MJ_REQ_ITEM_MIN = 50000L;
    public static long mjPerMillibucket = 1000L;
    public static long mjPerItem = 1000000L;
    public static int baseFlowRate = 10;
    public static PowerLossMode lossMode = PowerLossMode.DEFAULT;
    private static Property propMjPerMillibucket;
    private static Property propMjPerItem;
    private static Property propBaseFlowRate;
    private static Property propLossMode;

    public static void preInit() {
        Configuration config = BCCoreConfig.config;
        propMjPerMillibucket = config.get("general", "pipes.mjPerMillibucket", (int)mjPerMillibucket).setMinValue(100);
        EnumRestartRequirement.WORLD.setTo(propMjPerMillibucket);
        propMjPerItem = config.get("general", "pipes.mjPerItem", (int)mjPerItem).setMinValue(50000);
        EnumRestartRequirement.WORLD.setTo(propMjPerItem);
        propBaseFlowRate = config.get("general", "pipes.baseFluidRate", baseFlowRate).setMinValue(1).setMaxValue(40);
        EnumRestartRequirement.WORLD.setTo(propBaseFlowRate);
        propLossMode = config.get("experimental", "kinesisLossMode", "lossless");
        ConfigUtil.setEnumProperty((Property)propLossMode, (Enum[])PowerLossMode.VALUES);
        EnumRestartRequirement.WORLD.setTo(propLossMode);
        MinecraftForge.EVENT_BUS.register(BCTransportConfig.class);
    }

    public static void reloadConfig(EnumRestartRequirement restarted) {
        if (EnumRestartRequirement.WORLD.hasBeenRestarted(restarted)) {
            mjPerMillibucket = propMjPerMillibucket.getLong();
            if (mjPerMillibucket < 100L) {
                mjPerMillibucket = 100L;
            }
            if ((mjPerItem = propMjPerItem.getLong()) < 50000L) {
                mjPerItem = 50000L;
            }
            baseFlowRate = MathUtil.clamp(propBaseFlowRate.getInt(), 1, 40);
            int basePowerRate = 4;
            lossMode = (PowerLossMode)ConfigUtil.parseEnumForConfig((String)propLossMode.getString(), (Enum[])PowerLossMode.VALUES, (Enum)PowerLossMode.DEFAULT);
            BCTransportConfig.fluidTransfer(BCTransportPipes.cobbleFluid, baseFlowRate, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.woodFluid, baseFlowRate, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.voidFluid, baseFlowRate, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.stoneFluid, baseFlowRate * 2, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.sandstoneFluid, baseFlowRate * 2, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.clayFluid, baseFlowRate * 4, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.ironFluid, baseFlowRate * 4, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.quartzFluid, baseFlowRate * 4, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.diamondFluid, baseFlowRate * 8, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.diaWoodFluid, baseFlowRate * 8, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.goldFluid, baseFlowRate * 8, 2);
            BCTransportConfig.powerTransfer(BCTransportPipes.cobblePower, basePowerRate, 16, false);
            BCTransportConfig.powerTransfer(BCTransportPipes.stonePower, basePowerRate * 2, 32, false);
            BCTransportConfig.powerTransfer(BCTransportPipes.woodPower, basePowerRate * 4, 128, true);
            BCTransportConfig.powerTransfer(BCTransportPipes.sandstonePower, basePowerRate * 4, 32, false);
            BCTransportConfig.powerTransfer(BCTransportPipes.quartzPower, basePowerRate * 8, 32, false);
            BCTransportConfig.powerTransfer(BCTransportPipes.goldPower, basePowerRate * 16, 32, false);
        }
    }

    private static void fluidTransfer(PipeDefinition def, int rate, int delay) {
        PipeApi.fluidTransferData.put(def, new PipeApi.FluidTransferInfo(rate, delay));
    }

    private static void powerTransfer(PipeDefinition def, int transferMultiplier, int resistanceDivisor, boolean recv) {
        long transfer = 1000000L * (long)transferMultiplier;
        long resistance = 1000000L / (long)resistanceDivisor;
        PipeApi.powerTransferData.put(def, PipeApi.PowerTransferInfo.createFromResistance(transfer, resistance, recv));
    }

    @SubscribeEvent
    public static void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent cce) {
        if (BCModules.isBcMod(cce.getModID())) {
            EnumRestartRequirement req = EnumRestartRequirement.NONE;
            if (Loader.instance().isInState(LoaderState.AVAILABLE)) {
                req = EnumRestartRequirement.WORLD;
            }
            BCTransportConfig.reloadConfig(req);
        }
    }

    public static enum PowerLossMode {
        LOSSLESS,
        PERCENTAGE,
        ABSOLUTE;

        public static final PowerLossMode DEFAULT;
        public static final PowerLossMode[] VALUES;

        static {
            DEFAULT = LOSSLESS;
            VALUES = PowerLossMode.values();
        }
    }
}

