/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.tile;

import buildcraft.api.mj.ILaserTarget;
import buildcraft.api.mj.ILaserTargetBlock;
import buildcraft.api.mj.MjBattery;
import buildcraft.api.mj.MjCapabilityHelper;
import buildcraft.api.properties.BuildCraftProperties;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.lib.client.render.DetachedRenderer;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.VolumeUtil;
import buildcraft.lib.misc.data.AverageLong;
import buildcraft.lib.misc.data.Box;
import buildcraft.lib.mj.MjBatteryReceiver;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.silicon.BCSiliconBlocks;
import buildcraft.silicon.client.render.AdvDebuggerLaser;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileLaser
extends TileBC_Neptune
implements ITickable,
IDebuggable {
    private int ticks = 0;
    private BlockPos targetPos;
    private final AverageLong avgPower = new AverageLong(100);
    private long averageClient;
    private final MjBattery battery = new MjBattery(1024000000L);
    public Vec3d laserPos;

    public TileLaser() {
        this.caps.addProvider(new MjCapabilityHelper(new MjBatteryReceiver(this.battery)));
    }

    private void findTarget() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() != BCSiliconBlocks.laser) {
            return;
        }
        EnumFacing face = (EnumFacing)state.func_177229_b(BuildCraftProperties.BLOCK_FACING_6);
        ArrayList possible = new ArrayList();
        VolumeUtil.iterateCone(this.field_145850_b, this.field_174879_c, face, 6, true, (w, s, p, visible) -> {
            ILaserTarget targetAt;
            TileEntity tileAt;
            if (!visible) {
                return;
            }
            IBlockState stateAt = this.field_145850_b.func_180495_p(p);
            if (stateAt.func_177230_c() instanceof ILaserTargetBlock && (tileAt = this.field_145850_b.func_175625_s(p)) instanceof ILaserTarget && (targetAt = (ILaserTarget)tileAt).getRequiredLaserPower() > 0L) {
                possible.add(p);
            }
        });
        if (possible.isEmpty()) {
            this.targetPos = null;
            return;
        }
        this.targetPos = (BlockPos)possible.get(this.field_145850_b.field_73012_v.nextInt(possible.size()));
    }

    private ILaserTarget getTarget() {
        if (this.targetPos != null) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.targetPos);
            if (tile instanceof ILaserTarget) {
                ILaserTarget target = (ILaserTarget)tile;
                return target.getRequiredLaserPower() > 0L ? target : null;
            }
            return null;
        }
        return null;
    }

    private void updateLaser() {
        this.laserPos = this.getTarget() != null ? new Vec3d((Vec3i)this.targetPos).func_72441_c(((double)(5 + this.field_145850_b.field_73012_v.nextInt(6)) + 0.5) / 16.0, 0.5625, ((double)(5 + this.field_145850_b.field_73012_v.nextInt(6)) + 0.5) / 16.0) : null;
    }

    public long getAverageClient() {
        return this.averageClient;
    }

    public long getMaxPowerPerTick() {
        return 4000000L;
    }

    public void func_73660_a() {
        ILaserTarget target;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.avgPower.tick();
        ++this.ticks;
        if (this.getTarget() == null) {
            this.targetPos = null;
        }
        if (this.ticks % (10 + this.field_145850_b.field_73012_v.nextInt(20)) == 0 || this.getTarget() == null) {
            this.findTarget();
        }
        if (this.ticks % (5 + this.field_145850_b.field_73012_v.nextInt(10)) == 0 || this.getTarget() == null) {
            this.updateLaser();
        }
        if ((target = this.getTarget()) != null) {
            long max = this.getMaxPowerPerTick();
            max *= this.battery.getStored() + max;
            max /= this.battery.getCapacity() / 2L;
            long power = this.battery.extractPower(0L, max = Math.min(Math.min(max, this.getMaxPowerPerTick()), target.getRequiredLaserPower()));
            long excess = target.receiveLaserPower(power);
            if (excess > 0L) {
                this.battery.addPowerChecking(excess, false);
            }
            this.avgPower.push(power - excess);
        } else {
            this.avgPower.clear();
        }
        this.sendNetworkUpdate(NET_RENDER_DATA);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("mj_battery", (NBTBase)this.battery.serializeNBT());
        if (this.laserPos != null) {
            nbt.func_74782_a("laser_pos", (NBTBase)NBTUtilBC.writeVec3d(this.laserPos));
        }
        if (this.targetPos != null) {
            nbt.func_74782_a("target_pos", (NBTBase)NBTUtilBC.writeBlockPos(this.targetPos));
        }
        this.avgPower.writeToNbt(nbt, "average_power");
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.battery.deserializeNBT(nbt.func_74775_l("mj_battery"));
        this.targetPos = NBTUtilBC.readBlockPos(nbt.func_74781_a("target_pos"));
        this.laserPos = NBTUtilBC.readVec3d(nbt.func_74781_a("laser_pos"));
        this.avgPower.readFromNbt(nbt, "average_power");
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER && id == NET_RENDER_DATA) {
            this.battery.writeToBuffer((ByteBuf)buffer);
            buffer.writeBoolean(this.targetPos != null);
            if (this.targetPos != null) {
                MessageUtil.writeBlockPos(buffer, this.targetPos);
            }
            buffer.writeBoolean(this.laserPos != null);
            if (this.laserPos != null) {
                MessageUtil.writeVec3d(buffer, this.laserPos);
            }
            buffer.writeLong((long)this.avgPower.getAverage());
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT && id == NET_RENDER_DATA) {
            this.battery.readFromBuffer((ByteBuf)buffer);
            this.targetPos = buffer.readBoolean() ? MessageUtil.readBlockPos(buffer) : null;
            this.laserPos = buffer.readBoolean() ? MessageUtil.readVec3d(buffer) : null;
            this.averageClient = buffer.readLong();
        }
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("battery = " + this.battery.getDebugString());
        left.add("target = " + this.targetPos);
        left.add("laser = " + this.laserPos);
        left.add("average = " + LocaleUtil.localizeMjFlow(this.averageClient == 0L ? (long)this.avgPower.getAverage() : this.averageClient));
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new Box(this).extendToEncompass(this.targetPos).getBoundingBox();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public DetachedRenderer.IDetachedRenderer getDebugRenderer() {
        return AdvDebuggerLaser.getForTile(this);
    }
}

