/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.api.recipes.StackDefinition;
import buildcraft.lib.misc.InventoryUtil;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.net.MessageManager;
import buildcraft.lib.net.MessageUpdateTile;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.recipe.AssemblyRecipeRegistry;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.lib.tile.item.ItemHandlerManager;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import buildcraft.silicon.EnumAssemblyRecipeState;
import buildcraft.silicon.tile.TileLaserTableBase;
import com.google.common.collect.ImmutableCollection;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class TileAssemblyTable
extends TileLaserTableBase {
    public static final IdAllocator IDS = TileBC_Neptune.IDS.makeChild("assembly_table");
    public static final int NET_RECIPE_STATE = IDS.allocId("RECIPE_STATE");
    public final ItemHandlerSimple inv;
    public SortedMap<AssemblyRecipe, EnumAssemblyRecipeState> recipesStates;

    public TileAssemblyTable() {
        this.inv = this.itemManager.addInvHandler("inv", 12, ItemHandlerManager.EnumAccess.BOTH, EnumPipePart.VALUES);
        this.recipesStates = new TreeMap<AssemblyRecipe, EnumAssemblyRecipeState>();
    }

    @Override
    public IdAllocator getIdAllocator() {
        return IDS;
    }

    private void updateRecipes() {
        int count = this.recipesStates.size();
        AssemblyRecipeRegistry.INSTANCE.getRecipesFor(this.inv.stacks).forEach(recipe -> this.recipesStates.putIfAbsent((AssemblyRecipe)recipe, EnumAssemblyRecipeState.POSSIBLE));
        boolean findActive = false;
        Iterator<Map.Entry<AssemblyRecipe, EnumAssemblyRecipeState>> iterator = this.recipesStates.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<AssemblyRecipe, EnumAssemblyRecipeState> entry = iterator.next();
            AssemblyRecipe recipe2 = entry.getKey();
            EnumAssemblyRecipeState state = entry.getValue();
            boolean enough = this.extract(this.inv, (ImmutableCollection<StackDefinition>)recipe2.requiredStacks, true, false);
            if (state == EnumAssemblyRecipeState.POSSIBLE) {
                if (!enough) {
                    iterator.remove();
                }
            } else if (enough) {
                if (state == EnumAssemblyRecipeState.SAVED) {
                    state = EnumAssemblyRecipeState.SAVED_ENOUGH;
                }
            } else if (state != EnumAssemblyRecipeState.SAVED) {
                state = EnumAssemblyRecipeState.SAVED;
            }
            if (state == EnumAssemblyRecipeState.SAVED_ENOUGH_ACTIVE) {
                findActive = true;
            }
            entry.setValue(state);
        }
        if (!findActive) {
            for (Map.Entry<AssemblyRecipe, EnumAssemblyRecipeState> entry : this.recipesStates.entrySet()) {
                EnumAssemblyRecipeState state = entry.getValue();
                if (state != EnumAssemblyRecipeState.SAVED_ENOUGH) continue;
                state = EnumAssemblyRecipeState.SAVED_ENOUGH_ACTIVE;
                entry.setValue(state);
                break;
            }
        }
        if (count != this.recipesStates.size()) {
            this.sendNetworkGuiUpdate(NET_GUI_DATA);
        }
    }

    private AssemblyRecipe getActiveRecipe() {
        return this.recipesStates.entrySet().stream().filter(entry -> entry.getValue() == EnumAssemblyRecipeState.SAVED_ENOUGH_ACTIVE).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    private void activateNextRecipe() {
        AssemblyRecipe activeRecipe = this.getActiveRecipe();
        if (activeRecipe != null) {
            int index = 0;
            int activeIndex = 0;
            boolean isActiveLast = false;
            long enoughCount = this.recipesStates.values().stream().filter(state -> state == EnumAssemblyRecipeState.SAVED_ENOUGH || state == EnumAssemblyRecipeState.SAVED_ENOUGH_ACTIVE).count();
            if (enoughCount <= 1L) {
                return;
            }
            for (Map.Entry<AssemblyRecipe, EnumAssemblyRecipeState> entry : this.recipesStates.entrySet()) {
                EnumAssemblyRecipeState state2 = entry.getValue();
                if (state2 == EnumAssemblyRecipeState.SAVED_ENOUGH) {
                    isActiveLast = false;
                }
                if (state2 == EnumAssemblyRecipeState.SAVED_ENOUGH_ACTIVE) {
                    state2 = EnumAssemblyRecipeState.SAVED_ENOUGH;
                    entry.setValue(state2);
                    activeIndex = index;
                    isActiveLast = true;
                }
                ++index;
            }
            index = 0;
            for (Map.Entry<AssemblyRecipe, EnumAssemblyRecipeState> entry : this.recipesStates.entrySet()) {
                AssemblyRecipe recipe = entry.getKey();
                EnumAssemblyRecipeState state3 = entry.getValue();
                if (state3 == EnumAssemblyRecipeState.SAVED_ENOUGH && recipe != activeRecipe && (index > activeIndex || isActiveLast)) {
                    state3 = EnumAssemblyRecipeState.SAVED_ENOUGH_ACTIVE;
                    entry.setValue(state3);
                    break;
                }
                ++index;
            }
        }
    }

    @Override
    public long getTarget() {
        return Optional.ofNullable(this.getActiveRecipe()).map(recipe -> recipe.requiredMicroJoules).orElse(0L);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.updateRecipes();
        if (this.getTarget() > 0L && this.power >= this.getTarget()) {
            AssemblyRecipe recipe = this.getActiveRecipe();
            this.extract(this.inv, (ImmutableCollection<StackDefinition>)recipe.requiredStacks, false, false);
            InventoryUtil.addToBestAcceptor(this.func_145831_w(), this.func_174877_v(), null, recipe.output.func_77946_l());
            this.power -= this.getTarget();
            this.activateNextRecipe();
        }
        this.sendNetworkGuiUpdate(NET_GUI_DATA);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagList recipesStatesTag = new NBTTagList();
        this.recipesStates.forEach((recipe, state) -> {
            NBTTagCompound entryTag = new NBTTagCompound();
            entryTag.func_74778_a("recipe", recipe.name.toString());
            if (recipe.recipeTag != null) {
                entryTag.func_74782_a("recipe_tag", (NBTBase)recipe.recipeTag);
            }
            entryTag.func_74768_a("state", state.ordinal());
            recipesStatesTag.func_74742_a((NBTBase)entryTag);
        });
        nbt.func_74782_a("recipes_states", (NBTBase)recipesStatesTag);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.recipesStates.clear();
        NBTTagList recipesStatesTag = nbt.func_150295_c("recipes_states", 10);
        for (int i = 0; i < recipesStatesTag.func_74745_c(); ++i) {
            NBTTagCompound entryTag = recipesStatesTag.func_150305_b(i);
            String name = entryTag.func_74779_i("recipe");
            NBTTagCompound recipeTag = entryTag.func_74764_b("recipe_tag") ? entryTag.func_74775_l("recipe_tag") : null;
            this.recipesStates.put(this.lookupRecipe(name, recipeTag), EnumAssemblyRecipeState.values()[entryTag.func_74762_e("state")]);
        }
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (id == NET_GUI_DATA) {
            buffer.writeInt(this.recipesStates.size());
            this.recipesStates.forEach((recipe, state) -> {
                buffer.func_180714_a(recipe.name.toString());
                buffer.func_150786_a(recipe.recipeTag);
                buffer.writeInt(state.ordinal());
            });
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (id == NET_GUI_DATA) {
            this.recipesStates.clear();
            int count = buffer.readInt();
            for (int i = 0; i < count; ++i) {
                AssemblyRecipe recipe = this.lookupRecipe(buffer.readString(), buffer.func_150793_b());
                this.recipesStates.put(recipe, EnumAssemblyRecipeState.values()[buffer.readInt()]);
            }
        }
        if (id == NET_RECIPE_STATE) {
            AssemblyRecipe recipe = this.lookupRecipe(buffer.readString(), buffer.func_150793_b());
            EnumAssemblyRecipeState state = EnumAssemblyRecipeState.values()[buffer.readInt()];
            if (this.recipesStates.containsKey(recipe)) {
                this.recipesStates.put(recipe, state);
            }
        }
    }

    public void sendRecipeStateToServer(AssemblyRecipe recipe, EnumAssemblyRecipeState state) {
        MessageUpdateTile message = this.createMessage(NET_RECIPE_STATE, buffer -> {
            buffer.func_180714_a(recipe.name.toString());
            buffer.func_150786_a(recipe.recipeTag);
            buffer.writeInt(state.ordinal());
        });
        MessageManager.sendToServer(message);
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        super.getDebugInfo(left, right, side);
        left.add("recipes - " + this.recipesStates.size());
        left.add("target - " + LocaleUtil.localizeMj(this.getTarget()));
    }

    private AssemblyRecipe lookupRecipe(String name, NBTTagCompound recipeTag) {
        return AssemblyRecipeRegistry.INSTANCE.getRecipe(new ResourceLocation(name), recipeTag).orElseThrow(() -> new RuntimeException("Assembly recipe with name " + name + " not found"));
    }
}

