/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gui;

import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.lib.gui.GuiBC8;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.gui.pos.PositionAbsolute;
import buildcraft.silicon.EnumAssemblyRecipeState;
import buildcraft.silicon.container.ContainerAssemblyTable;
import buildcraft.silicon.tile.TileAssemblyTable;
import buildcraft.transport.gui.LedgerTablePower;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class GuiAssemblyTable
extends GuiBC8<ContainerAssemblyTable> {
    private static final ResourceLocation TEXTURE_BASE = new ResourceLocation("buildcraftsilicon:textures/gui/assembly_table.png");
    private static final int SIZE_X = 176;
    private static final int SIZE_Y = 220;
    private static final GuiIcon ICON_GUI = new GuiIcon(TEXTURE_BASE, 0, 0, 176, 220);
    private static final GuiIcon ICON_SAVED = new GuiIcon(TEXTURE_BASE, 176, 0, 16, 16);
    private static final GuiIcon ICON_SAVED_ENOUGH = new GuiIcon(TEXTURE_BASE, 176, 16, 16, 16);
    private static final GuiIcon ICON_SAVED_ENOUGH_ACTIVE = new GuiIcon(TEXTURE_BASE, 176, 32, 16, 16);
    private static final GuiIcon ICON_PROGRESS = new GuiIcon(TEXTURE_BASE, 176, 48, 4, 70);
    private static final GuiRectangle RECT_PROGRESS = new GuiRectangle(86, 36, 4, 70);

    public GuiAssemblyTable(ContainerAssemblyTable container) {
        super(container);
        this.field_146999_f = 176;
        this.field_147000_g = 220;
        this.ledgersRight.ledgers.add(new LedgerTablePower(this.ledgersRight, (TileAssemblyTable)container.tile));
    }

    private IGuiPosition getPos(int index) {
        int posX = index % 3;
        int posY = index / 3;
        return new PositionAbsolute(116 + posX * 18, 36 + posY * 18);
    }

    private IGuiArea getArea(int index) {
        return index < 12 ? new GuiRectangle(16, 16).offset(this.rootElement).offset(this.getPos(index)) : GuiRectangle.ZERO;
    }

    @Override
    protected void drawBackgroundLayer(float partialTicks) {
        ICON_GUI.drawAt(this.rootElement);
        long target = ((TileAssemblyTable)((ContainerAssemblyTable)this.container).tile).getTarget();
        if (target != 0L) {
            double v = (double)((TileAssemblyTable)((ContainerAssemblyTable)this.container).tile).power / (double)target;
            ICON_PROGRESS.drawCutInside(new GuiRectangle(GuiAssemblyTable.RECT_PROGRESS.x, (int)((double)GuiAssemblyTable.RECT_PROGRESS.y + (double)GuiAssemblyTable.RECT_PROGRESS.height * Math.max(1.0 - v, 0.0)), GuiAssemblyTable.RECT_PROGRESS.width, (int)Math.ceil((double)GuiAssemblyTable.RECT_PROGRESS.height * Math.min(v, 1.0))).offset(this.rootElement));
        }
        for (int i = 0; i < ((TileAssemblyTable)((ContainerAssemblyTable)this.container).tile).recipesStates.size(); ++i) {
            EnumAssemblyRecipeState state = new ArrayList<EnumAssemblyRecipeState>(((TileAssemblyTable)((ContainerAssemblyTable)this.container).tile).recipesStates.values()).get(i);
            if (state == EnumAssemblyRecipeState.SAVED) {
                ICON_SAVED.drawAt(this.getArea(i));
            }
            if (state == EnumAssemblyRecipeState.SAVED_ENOUGH) {
                ICON_SAVED_ENOUGH.drawAt(this.getArea(i));
            }
            if (state != EnumAssemblyRecipeState.SAVED_ENOUGH_ACTIVE) continue;
            ICON_SAVED_ENOUGH_ACTIVE.drawAt(this.getArea(i));
        }
    }

    @Override
    protected void drawForegroundLayer() {
        String title = I18n.func_135052_a((String)"tile.assemblyTableBlock.name", (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(title, this.field_147003_i + (this.field_146999_f - this.field_146289_q.func_78256_a(title)) / 2, this.field_147009_r + 15, 0x404040);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            for (int i = 0; i < ((TileAssemblyTable)((ContainerAssemblyTable)this.container).tile).recipesStates.size(); ++i) {
                AssemblyRecipe recipe = new ArrayList<AssemblyRecipe>(((TileAssemblyTable)((ContainerAssemblyTable)this.container).tile).recipesStates.keySet()).get(i);
                EnumAssemblyRecipeState state = new ArrayList<EnumAssemblyRecipeState>(((TileAssemblyTable)((ContainerAssemblyTable)this.container).tile).recipesStates.values()).get(i);
                if (!this.getArea(i).contains(mouseX, mouseY)) continue;
                ((TileAssemblyTable)((ContainerAssemblyTable)this.container).tile).sendRecipeStateToServer(recipe, state == EnumAssemblyRecipeState.POSSIBLE ? EnumAssemblyRecipeState.SAVED : EnumAssemblyRecipeState.POSSIBLE);
            }
        }
    }
}

