/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.api.BCBlocks;
import buildcraft.api.BCItems;
import buildcraft.api.enums.EnumRedstoneChipset;
import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.api.recipes.IntegrationRecipe;
import buildcraft.api.recipes.StackDefinition;
import buildcraft.lib.BCLib;
import buildcraft.lib.inventory.filter.ArrayStackFilter;
import buildcraft.lib.inventory.filter.OreStackFilter;
import buildcraft.lib.recipe.AssemblyRecipeRegistry;
import buildcraft.lib.recipe.IntegrationRecipeRegistry;
import buildcraft.lib.recipe.RecipeBuilderShaped;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class BCSiliconRecipes {
    public static void init() {
        RecipeBuilderShaped builder;
        if (BCBlocks.SILICON_LASER != null) {
            builder = new RecipeBuilderShaped();
            builder.add("rro");
            builder.add("rdd");
            builder.add("rro");
            builder.map('r', "dustRedstone");
            builder.map('o', Blocks.field_150343_Z);
            builder.map('d', "gemDiamond");
            builder.setResult(new ItemStack(BCBlocks.SILICON_LASER));
            builder.register();
            builder.registerRotated();
        }
        if (BCItems.SILICON_REDSTONE_CHIPSET != null) {
            BCSiliconRecipes.addChipsetAssembly(1, null, EnumRedstoneChipset.RED);
            BCSiliconRecipes.addChipsetAssembly(2, "ingotIron", EnumRedstoneChipset.IRON);
            BCSiliconRecipes.addChipsetAssembly(4, "ingotGold", EnumRedstoneChipset.GOLD);
            BCSiliconRecipes.addChipsetAssembly(6, "gemQuartz", EnumRedstoneChipset.QUARTZ);
            BCSiliconRecipes.addChipsetAssembly(8, "gemDiamond", EnumRedstoneChipset.DIAMOND);
        }
        if (BCBlocks.SILICON_TABLE_ASSEMBLY != null) {
            builder = new RecipeBuilderShaped();
            builder.setResult(new ItemStack(BCBlocks.SILICON_TABLE_ASSEMBLY));
            builder.add("OdO");
            builder.add("OrO");
            builder.add("OgO");
            builder.map('O', Blocks.field_150343_Z);
            builder.map('d', "gemDiamond");
            builder.map('r', "dustRedstone");
            builder.map('g', "gearDiamond");
            builder.register();
        }
        if (BCBlocks.SILICON_TABLE_ADV_CRAFT != null) {
            builder = new RecipeBuilderShaped();
            builder.setResult(new ItemStack(BCBlocks.SILICON_TABLE_ADV_CRAFT));
            builder.add("OtO");
            builder.add("OcO");
            builder.add("OrO");
            builder.map('O', Blocks.field_150343_Z);
            builder.map('t', "craftingTableWood");
            builder.map('c', "chestWood");
            builder.map('r', EnumRedstoneChipset.RED.getStack());
            builder.register();
        }
        if (BCBlocks.SILICON_TABLE_INTEGRATION != null) {
            builder = new RecipeBuilderShaped();
            builder.setResult(new ItemStack(BCBlocks.SILICON_TABLE_INTEGRATION));
            builder.add("OiO");
            builder.add("OrO");
            builder.add("OgO");
            builder.map('O', Blocks.field_150343_Z);
            builder.map('i', "ingotGold");
            builder.map('r', EnumRedstoneChipset.IRON.getStack(), "ingotIron");
            builder.map('g', "gearDiamond");
            builder.register();
        }
        if (BCBlocks.SILICON_TABLE_CHARGING != null) {
            builder = new RecipeBuilderShaped();
            builder.setResult(new ItemStack(BCBlocks.SILICON_TABLE_CHARGING));
            builder.add("OdO");
            builder.add("OrO");
            builder.add("OgO");
            builder.map('O', Blocks.field_150343_Z);
            builder.map('d', "dustRedstone");
            builder.map('r', EnumRedstoneChipset.RED.getStack(), Blocks.field_150451_bX);
            builder.map('g', "gearGold");
            builder.register();
        }
        if (BCBlocks.SILICON_TABLE_PROGRAMMING != null) {
            builder = new RecipeBuilderShaped();
            builder.setResult(new ItemStack(BCBlocks.SILICON_TABLE_PROGRAMMING));
            builder.add("OeO");
            builder.add("OrO");
            builder.add("OgO");
            builder.map('O', Blocks.field_150343_Z);
            builder.map('e', EnumRedstoneChipset.GOLD.getStack(), "ingotGold");
            builder.map('r', EnumRedstoneChipset.DIAMOND.getStack(), "gemDiamond");
            builder.map('g', "gearDiamond");
            builder.register();
        }
        if (BCLib.DEV) {
            OreDictionary.registerOre((String)"dyeYellow", (Block)Blocks.field_150340_R);
            OreDictionary.registerOre((String)"dyeBlue", (Block)Blocks.field_150368_y);
            OreDictionary.registerOre((String)"dyeRed", (Block)Blocks.field_150451_bX);
            StackDefinition target = ArrayStackFilter.definition(Items.field_151174_bG);
            ImmutableList required = ImmutableList.of((Object)OreStackFilter.definition("dustRedstone"));
            ItemStack output = new ItemStack(Items.field_151168_bH, 4);
            IntegrationRecipeRegistry.INSTANCE.addRecipe(new IntegrationRecipe("potato-baker", 100000000L, target, (List<StackDefinition>)required, output));
        }
    }

    private static void addChipsetAssembly(int multiplier, String additional, EnumRedstoneChipset type) {
        ItemStack output = type.getStack();
        ImmutableSet.Builder inputs = ImmutableSet.builder();
        inputs.add((Object)OreStackFilter.definition("dustRedstone"));
        if (additional != null) {
            inputs.add((Object)OreStackFilter.definition(additional));
        }
        String name = String.format("chipset-%s", new Object[]{type});
        AssemblyRecipe recp = new AssemblyRecipe(name, (long)multiplier * 10000L * 1000000L, (Set<StackDefinition>)inputs.build(), output);
        AssemblyRecipeRegistry.INSTANCE.addRecipe(recp);
    }
}

