/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.zone;

import buildcraft.lib.client.model.MutableVertex;
import buildcraft.robotics.zone.ZonePlannerMapChunk;
import buildcraft.robotics.zone.ZonePlannerMapChunkKey;
import buildcraft.robotics.zone.ZonePlannerMapDataClient;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import java.util.OptionalInt;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public enum ZonePlannerMapRenderer {
    INSTANCE;

    private static final Cache<ZonePlannerMapChunkKey, Integer> CHUNK_GL_CACHE;
    private final MutableVertex vertex = new MutableVertex();

    private static void onRemove(RemovalNotification<ZonePlannerMapChunkKey, Integer> notification) {
        Integer glList = (Integer)notification.getValue();
        if (glList != null) {
            GL11.glDeleteLists((int)glList, (int)1);
        }
    }

    private void vertex(VertexBuffer builder, double x, double y, double z) {
        this.vertex.positiond(x, y, z);
        this.vertex.render(builder);
    }

    public void drawBlockCuboid(VertexBuffer builder, double x, double y, double z, double height, double radius) {
        double rX = radius;
        double rY = height * 0.5;
        double rZ = radius;
        this.vertex.normalf(0.0f, 1.0f, 0.0f);
        this.vertex(builder, x - rX, (y -= rY) + rY, z + rZ);
        this.vertex(builder, x + rX, y + rY, z + rZ);
        this.vertex(builder, x + rX, y + rY, z - rZ);
        this.vertex(builder, x - rX, y + rY, z - rZ);
        this.vertex.normalf(-1.0f, 0.0f, 0.0f);
        this.vertex.multColourd(0.6);
        this.vertex(builder, x - rX, y - rY, z + rZ);
        this.vertex(builder, x - rX, y + rY, z + rZ);
        this.vertex(builder, x - rX, y + rY, z - rZ);
        this.vertex(builder, x - rX, y - rY, z - rZ);
        this.vertex.normalf(1.0f, 0.0f, 0.0f);
        this.vertex(builder, x + rX, y - rY, z - rZ);
        this.vertex(builder, x + rX, y + rY, z - rZ);
        this.vertex(builder, x + rX, y + rY, z + rZ);
        this.vertex(builder, x + rX, y - rY, z + rZ);
        this.vertex.multColourd(1.6666666666666667);
        this.vertex.normalf(0.0f, 0.0f, -1.0f);
        this.vertex.multColourd(0.8);
        this.vertex(builder, x - rX, y - rY, z - rZ);
        this.vertex(builder, x - rX, y + rY, z - rZ);
        this.vertex(builder, x + rX, y + rY, z - rZ);
        this.vertex(builder, x + rX, y - rY, z - rZ);
        this.vertex.normalf(0.0f, 0.0f, 1.0f);
        this.vertex(builder, x + rX, y - rY, z + rZ);
        this.vertex(builder, x + rX, y + rY, z + rZ);
        this.vertex(builder, x - rX, y + rY, z + rZ);
        this.vertex(builder, x - rX, y - rY, z + rZ);
        this.vertex.multColourd(1.25);
    }

    public void drawBlockCuboid(VertexBuffer builder, double x, double y, double z, double height) {
        this.drawBlockCuboid(builder, x, y, z, height, 0.5);
    }

    public void drawBlockCuboid(VertexBuffer builder, double x, double y, double z) {
        this.drawBlockCuboid(builder, x, y, z, 1.0);
    }

    public OptionalInt getChunkGlList(ZonePlannerMapChunkKey key) {
        Integer glList = (Integer)CHUNK_GL_CACHE.getIfPresent((Object)key);
        if (glList == null) {
            this.genChunk(key);
            glList = (Integer)CHUNK_GL_CACHE.getIfPresent((Object)key);
        }
        return glList != null ? OptionalInt.of(glList) : OptionalInt.empty();
    }

    public void setColor(int color) {
        this.vertex.colouri(color >> 16, color >> 8, color, color >> 24);
    }

    private void genChunk(ZonePlannerMapChunkKey key) {
        ZonePlannerMapChunk zonePlannerMapChunk = ZonePlannerMapDataClient.INSTANCE.getChunk((World)Minecraft.func_71410_x().field_71441_e, key);
        if (zonePlannerMapChunk == null) {
            return;
        }
        VertexBuffer builder = Tessellator.func_178181_a().func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                ZonePlannerMapChunk.MapColourData data = zonePlannerMapChunk.getData(x, z);
                if (data == null) continue;
                this.setColor(data.colour);
                this.drawBlockCuboid(builder, key.chunkPos.func_180334_c() + x, data.posY, key.chunkPos.func_180333_d() + z, data.posY);
            }
        }
        int glList = GL11.glGenLists((int)1);
        GL11.glNewList((int)glList, (int)4864);
        Tessellator.func_178181_a().func_78381_a();
        GL11.glEndList();
        CHUNK_GL_CACHE.put((Object)key, (Object)glList);
    }

    static {
        CHUNK_GL_CACHE = CacheBuilder.newBuilder().expireAfterAccess(20L, TimeUnit.SECONDS).removalListener(ZonePlannerMapRenderer::onRemove).build();
    }
}

