/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.zone;

import buildcraft.robotics.zone.ZonePlannerMapChunkKey;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ZonePlannerMapChunk {
    private final MapColourData[][] data = new MapColourData[16][16];

    public ZonePlannerMapChunk(World world, ZonePlannerMapChunkKey key) {
        Chunk chunk = world.func_72964_e(key.chunkPos.field_77276_a, key.chunkPos.field_77275_b);
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                for (int y = key.level * 32; y > 0; --y) {
                    int colour = chunk.func_186032_a((int)x, (int)y, (int)z).func_185909_g().field_76291_p;
                    if (colour == 0) continue;
                    this.data[x][z] = new MapColourData(y, colour);
                    continue block1;
                }
            }
        }
    }

    public ZonePlannerMapChunk(PacketBuffer buffer) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int posY = buffer.readInt();
                if (posY <= 0) continue;
                int colour = buffer.readInt();
                this.data[x][z] = new MapColourData(posY, colour);
            }
        }
    }

    public void write(PacketBuffer buffer) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                MapColourData colour = this.data[x][z];
                if (colour == null) {
                    buffer.writeInt(-1);
                    continue;
                }
                buffer.writeInt(colour.posY);
                buffer.writeInt(colour.colour);
            }
        }
    }

    public int getColour(int x, int z) {
        MapColourData col = this.getData(x, z);
        return col == null ? -1 : col.colour;
    }

    @Nullable
    public MapColourData getData(int x, int z) {
        return this.data[x & 0xF][z & 0xF];
    }

    public static final class MapColourData {
        public final int posY;
        public final int colour;

        public MapColourData(int posY, int colour) {
            this.posY = posY;
            this.colour = colour;
        }
    }
}

