/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.gui;

import buildcraft.core.BCCoreItems;
import buildcraft.core.item.ItemPaintbrush_BC8;
import buildcraft.lib.gui.GuiBC8;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.robotics.container.ContainerZonePlanner;
import buildcraft.robotics.tile.TileZonePlanner;
import buildcraft.robotics.zone.ZonePlan;
import buildcraft.robotics.zone.ZonePlannerMapChunk;
import buildcraft.robotics.zone.ZonePlannerMapChunkKey;
import buildcraft.robotics.zone.ZonePlannerMapDataClient;
import buildcraft.robotics.zone.ZonePlannerMapRenderer;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class GuiZonePlanner
extends GuiBC8<ContainerZonePlanner> {
    private static final ResourceLocation TEXTURE_BASE = new ResourceLocation("buildcraftrobotics:textures/gui/zone_planner.png");
    private static final int SIZE_X = 256;
    private static final int SIZE_Y = 228;
    private static final GuiIcon ICON_GUI = new GuiIcon(TEXTURE_BASE, 0, 0, 256, 228);
    private static final GuiIcon ICON_PROGRESS_INPUT = new GuiIcon(TEXTURE_BASE, 9, 228, 28, 9);
    private static final GuiIcon ICON_PROGRESS_OUTPUT = new GuiIcon(TEXTURE_BASE, 0, 228, 9, 28);
    private static final GuiRectangle RECT_PROGRESS_INPUT = new GuiRectangle(44, 128, 28, 9);
    private static final GuiRectangle RECT_PROGRESS_OUTPUT = new GuiRectangle(236, 45, 9, 28);
    private float startMouseX = 0.0f;
    private float startMouseY = 0.0f;
    private float startPositionX = 0.0f;
    private float startPositionZ = 0.0f;
    private float camY = 256.0f;
    private float scaleSpeed = 0.0f;
    private float positionX = 0.0f;
    private float positionZ = 0.0f;
    private boolean canDrag = false;
    private BlockPos lastSelected = null;
    private BlockPos selectionStartXZ = null;
    private ZonePlan bufferLayer = null;

    public GuiZonePlanner(ContainerZonePlanner container) {
        super(container);
        this.field_146999_f = 256;
        this.field_147000_g = 228;
        BlockPos tilePos = ((TileZonePlanner)container.tile).func_174877_v();
        this.positionX = tilePos.func_177958_n();
        this.positionZ = tilePos.func_177952_p();
    }

    private ItemStack getCurrentStack() {
        return this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
    }

    private ItemStack getPaintbrush() {
        ItemStack currentStack = this.getCurrentStack();
        if (!currentStack.func_190926_b() && currentStack.func_77973_b() instanceof ItemPaintbrush_BC8) {
            return currentStack;
        }
        return null;
    }

    private ItemPaintbrush_BC8.Brush getPaintbrushBrush() {
        ItemStack paintbrush = this.getPaintbrush();
        if (paintbrush != null) {
            ItemPaintbrush_BC8.Brush brush = BCCoreItems.paintbrush.getBrushFromStack(paintbrush);
            if (brush.colour != null) {
                return brush;
            }
        }
        return null;
    }

    public void func_146274_d() throws IOException {
        int wheel = Mouse.getEventDWheel();
        if (wheel != 0) {
            this.scaleSpeed -= (float)wheel / 30.0f;
        }
        super.func_146274_d();
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.canDrag = false;
        if (this.getPaintbrush() != null) {
            if (this.lastSelected != null) {
                this.selectionStartXZ = this.lastSelected;
            }
        } else if (this.getCurrentStack().func_190926_b()) {
            this.startPositionX = this.positionX;
            this.startPositionZ = this.positionZ;
            this.startMouseX = mouseX;
            this.startMouseY = mouseY;
            this.canDrag = true;
        }
    }

    @Override
    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (!this.canDrag) {
            if (this.lastSelected != null && this.getPaintbrushBrush() != null) {
                this.bufferLayer = new ZonePlan(((TileZonePlanner)((ContainerZonePlanner)this.container).tile).layers[this.getPaintbrushBrush().colour.func_176765_a()]);
                if (this.selectionStartXZ != null && this.getPaintbrushBrush() != null && this.lastSelected != null) {
                    for (int x = Math.min(this.selectionStartXZ.func_177958_n(), this.lastSelected.func_177958_n()); x < Math.max(this.selectionStartXZ.func_177958_n(), this.lastSelected.func_177958_n()); ++x) {
                        for (int z = Math.min(this.selectionStartXZ.func_177952_p(), this.lastSelected.func_177952_p()); z < Math.max(this.selectionStartXZ.func_177952_p(), this.lastSelected.func_177952_p()); ++z) {
                            if (clickedMouseButton == 0) {
                                this.bufferLayer.set(x - ((TileZonePlanner)((ContainerZonePlanner)this.container).tile).func_174877_v().func_177958_n(), z - ((TileZonePlanner)((ContainerZonePlanner)this.container).tile).func_174877_v().func_177952_p(), true);
                                continue;
                            }
                            if (clickedMouseButton != 1) continue;
                            this.bufferLayer.set(x - ((TileZonePlanner)((ContainerZonePlanner)this.container).tile).func_174877_v().func_177958_n(), z - ((TileZonePlanner)((ContainerZonePlanner)this.container).tile).func_174877_v().func_177952_p(), false);
                        }
                    }
                }
            }
            return;
        }
        float deltaX = (float)mouseX - this.startMouseX;
        float deltaY = (float)mouseY - this.startMouseY;
        float s = 0.3f;
        this.positionX = this.startPositionX - deltaX * s;
        this.positionZ = this.startPositionZ - deltaY * s;
    }

    @Override
    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.selectionStartXZ = null;
        if (this.getPaintbrushBrush() != null && this.bufferLayer != null) {
            ((TileZonePlanner)((ContainerZonePlanner)this.container).tile).layers[this.getPaintbrushBrush().colour.func_176765_a()] = this.bufferLayer;
            ((TileZonePlanner)((ContainerZonePlanner)this.container).tile).sendLayerToServer(this.getPaintbrushBrush().colour.func_176765_a());
        }
        this.bufferLayer = null;
    }

    @Override
    protected void drawBackgroundLayer(float partialTicks) {
        ICON_GUI.drawAt(this.rootElement);
        this.drawProgress(RECT_PROGRESS_INPUT, ICON_PROGRESS_INPUT, ((TileZonePlanner)((ContainerZonePlanner)this.container).tile).deltaProgressInput.getDynamic(partialTicks), 1.0);
        this.drawProgress(RECT_PROGRESS_OUTPUT, ICON_PROGRESS_OUTPUT, 1.0, ((TileZonePlanner)((ContainerZonePlanner)this.container).tile).deltaProgressOutput.getDynamic(partialTicks));
    }

    @Override
    protected void drawForegroundLayer() {
        ZonePlannerMapChunk.MapColourData data;
        this.camY += this.scaleSpeed;
        this.scaleSpeed *= 0.7f;
        int posX = (int)this.positionX;
        int posZ = (int)this.positionZ;
        int dimension = this.field_146297_k.field_71441_e.field_73011_w.getDimension();
        ChunkPos chunkPos = new ChunkPos(posX >> 4, posZ >> 4);
        ZonePlannerMapChunk zonePlannerMapChunk = ZonePlannerMapDataClient.INSTANCE.getChunk((World)this.field_146297_k.field_71441_e, new ZonePlannerMapChunkKey(chunkPos, dimension, ((TileZonePlanner)((ContainerZonePlanner)this.container).tile).getLevel()));
        BlockPos pos = null;
        if (zonePlannerMapChunk != null && (data = zonePlannerMapChunk.getData(posX, posZ)) != null) {
            pos = new BlockPos(posX, data.posY, posZ);
        }
        if (pos != null && (float)(pos.func_177956_o() + 10) > this.camY) {
            this.camY = Math.max(this.camY, (float)(pos.func_177956_o() + 10));
        }
        int x = this.field_147003_i;
        int y = this.field_147009_r;
        if (this.lastSelected != null) {
            String text = "X: " + this.lastSelected.func_177958_n() + " Y: " + this.lastSelected.func_177956_o() + " Z: " + this.lastSelected.func_177952_p();
            this.field_146289_q.func_78276_b(text, x + 130, y + 130, 0x404040);
        }
        int offsetX = 8;
        int offsetY = 9;
        int sizeX = 213;
        int sizeY = 100;
        GlStateManager.func_179094_E();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        ScaledResolution scaledResolution = new ScaledResolution(this.field_146297_k);
        int viewportX = (x + offsetX) * scaledResolution.func_78325_e();
        int viewportY = this.field_146297_k.field_71440_d - (sizeY + y + offsetY) * scaledResolution.func_78325_e();
        int viewportWidth = sizeX * scaledResolution.func_78325_e();
        int viewportHeight = sizeY * scaledResolution.func_78325_e();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GlStateManager.func_179086_m((int)256);
        GL11.glDisable((int)3089);
        GlStateManager.func_179083_b((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GlStateManager.func_179152_a((float)scaledResolution.func_78325_e(), (float)scaledResolution.func_78325_e(), (float)1.0f);
        GLU.gluPerspective((float)70.0f, (float)((float)sizeX / (float)sizeY), (float)1.0f, (float)1000.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        RenderHelper.func_74519_b();
        GlStateManager.func_179091_B();
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(-this.positionX), (float)(-this.camY), (float)(-this.positionZ));
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
        GlStateManager.func_179090_x();
        int chunkBaseX = posX >> 4;
        int chunkBaseZ = posZ >> 4;
        int radius = 8;
        for (int chunkX = chunkBaseX - radius; chunkX < chunkBaseX + radius; ++chunkX) {
            for (int chunkZ = chunkBaseZ - radius; chunkZ < chunkBaseZ + radius; ++chunkZ) {
                ZonePlannerMapRenderer.INSTANCE.getChunkGlList(new ZonePlannerMapChunkKey(new ChunkPos(chunkX, chunkZ), dimension, ((TileZonePlanner)((ContainerZonePlanner)this.container).tile).getLevel())).ifPresent(GlStateManager::func_179148_o);
            }
        }
        BlockPos found = null;
        int foundColor = 0;
        if (Mouse.getX() / scaledResolution.func_78325_e() > x + offsetX && Mouse.getX() / scaledResolution.func_78325_e() < x + offsetX + sizeX && scaledResolution.func_78328_b() - Mouse.getY() / scaledResolution.func_78325_e() > y + offsetY && scaledResolution.func_78328_b() - Mouse.getY() / scaledResolution.func_78325_e() < y + offsetY + sizeY) {
            int chunkZ;
            int chunkX;
            ZonePlannerMapChunk zonePlannerMapChunk2;
            FloatBuffer projectionBuffer = BufferUtils.createFloatBuffer((int)16);
            FloatBuffer modelViewBuffer = BufferUtils.createFloatBuffer((int)16);
            IntBuffer viewportBuffer = BufferUtils.createIntBuffer((int)16);
            GlStateManager.func_179111_a((int)2983, (FloatBuffer)projectionBuffer);
            GlStateManager.func_179111_a((int)2982, (FloatBuffer)modelViewBuffer);
            GlStateManager.func_187445_a((int)2978, (IntBuffer)viewportBuffer);
            FloatBuffer positionNearBuffer = BufferUtils.createFloatBuffer((int)3);
            FloatBuffer positionFarBuffer = BufferUtils.createFloatBuffer((int)3);
            GLU.gluUnProject((float)Mouse.getX(), (float)Mouse.getY(), (float)0.0f, (FloatBuffer)modelViewBuffer, (FloatBuffer)projectionBuffer, (IntBuffer)viewportBuffer, (FloatBuffer)positionNearBuffer);
            GLU.gluUnProject((float)Mouse.getX(), (float)Mouse.getY(), (float)1.0f, (FloatBuffer)modelViewBuffer, (FloatBuffer)projectionBuffer, (IntBuffer)viewportBuffer, (FloatBuffer)positionFarBuffer);
            Vector3d rayStart = new Vector3d((double)positionNearBuffer.get(0), (double)positionNearBuffer.get(1), (double)positionNearBuffer.get(2));
            Vector3d rayPosition = new Vector3d(rayStart);
            Vector3d rayDirection = new Vector3d((double)positionFarBuffer.get(0), (double)positionFarBuffer.get(1), (double)positionFarBuffer.get(2));
            rayDirection.sub((Tuple3d)rayStart);
            rayDirection.normalize();
            Vector3d offset = new Vector3d(rayDirection);
            offset.scale(100.0);
            rayPosition.add((Tuple3d)offset);
            rayDirection.negate();
            for (int i = 0; i < 100 && (zonePlannerMapChunk2 = ZonePlannerMapDataClient.INSTANCE.getChunk((World)this.field_146297_k.field_71441_e, new ZonePlannerMapChunkKey(new ChunkPos(chunkX = (int)Math.round(rayPosition.getX()) >> 4, chunkZ = (int)Math.round(rayPosition.getZ()) >> 4), this.field_146297_k.field_71441_e.field_73011_w.getDimension(), ((TileZonePlanner)((ContainerZonePlanner)this.container).tile).getLevel()))) != null; ++i) {
                BlockPos pos2 = new BlockPos((double)(Math.round(rayPosition.getX()) - (long)(chunkX << 4)), (double)Math.round(rayPosition.getY()), (double)(Math.round(rayPosition.getZ()) - (long)(chunkZ << 4)));
                ZonePlannerMapChunk.MapColourData data2 = zonePlannerMapChunk2.getData(pos2.func_177958_n(), pos2.func_177952_p());
                if (data2 != null && data2.posY >= pos2.func_177956_o()) {
                    found = new BlockPos(pos2.func_177958_n() + (chunkX << 4), data2.posY, pos2.func_177952_p() + chunkZ * 16);
                    foundColor = data2.colour;
                }
                rayPosition.add((Tuple3d)rayDirection);
            }
        }
        if (found != null) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179147_l();
            GlStateManager.func_187409_d((int)1032, (int)6913);
            GlStateManager.func_187441_d((float)2.0f);
            int r = (int)((double)(foundColor >> 16 & 0xFF) * 0.7);
            int g = (int)((double)(foundColor >> 8 & 0xFF) * 0.7);
            int b = (int)((double)(foundColor >> 0 & 0xFF) * 0.7);
            int a = 119;
            ZonePlannerMapRenderer.INSTANCE.setColor(r << 16 | g << 8 | b << 0 | a << 24);
            VertexBuffer builder = Tessellator.func_178181_a().func_178180_c();
            builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            ZonePlannerMapRenderer.INSTANCE.drawBlockCuboid(builder, found.func_177958_n(), found.func_177956_o(), found.func_177952_p());
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_187409_d((int)1032, (int)6914);
            GlStateManager.func_179084_k();
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        for (int i = 0; i < ((TileZonePlanner)((ContainerZonePlanner)this.container).tile).layers.length; ++i) {
            if (this.getPaintbrushBrush() != null && this.getPaintbrushBrush().colour.func_176765_a() != i) continue;
            ZonePlan layer = ((TileZonePlanner)((ContainerZonePlanner)this.container).tile).layers[i];
            if (this.getPaintbrushBrush() != null && this.getPaintbrushBrush().colour.func_176765_a() == i && this.bufferLayer != null) {
                layer = this.bufferLayer;
            }
            if (layer.getChunkPoses().isEmpty()) continue;
            Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181706_f);
            for (int chunkX = chunkBaseX - radius; chunkX < chunkBaseX + radius; ++chunkX) {
                for (int chunkZ = chunkBaseZ - radius; chunkZ < chunkBaseZ + radius; ++chunkZ) {
                    ChunkPos chunkPos2 = new ChunkPos(chunkX, chunkZ);
                    for (int blockX = chunkPos2.func_180334_c(); blockX <= chunkPos2.func_180332_e(); ++blockX) {
                        for (int blockZ = chunkPos2.func_180333_d(); blockZ <= chunkPos2.func_180330_f(); ++blockZ) {
                            ZonePlannerMapChunk.MapColourData data3;
                            ZonePlannerMapChunk zonePlannerMapChunk3;
                            if (!layer.get(blockX - ((TileZonePlanner)((ContainerZonePlanner)this.container).tile).func_174877_v().func_177958_n(), blockZ - ((TileZonePlanner)((ContainerZonePlanner)this.container).tile).func_174877_v().func_177952_p()) || (zonePlannerMapChunk3 = ZonePlannerMapDataClient.INSTANCE.getChunk((World)this.field_146297_k.field_71441_e, new ZonePlannerMapChunkKey(chunkPos2, dimension, ((TileZonePlanner)((ContainerZonePlanner)this.container).tile).getLevel()))) == null || (data3 = zonePlannerMapChunk3.getData(blockX, blockZ)) == null) continue;
                            int height = data3.posY;
                            int color = EnumDyeColor.func_176764_b((int)i).func_176768_e().field_76291_p;
                            int r = color >> 16 & 0xFF;
                            int g = color >> 8 & 0xFF;
                            int b = color >> 0 & 0xFF;
                            int a = 85;
                            ZonePlannerMapRenderer.INSTANCE.setColor(r << 16 | g << 8 | b << 0 | a << 24);
                            ZonePlannerMapRenderer.INSTANCE.drawBlockCuboid(Tessellator.func_178181_a().func_178180_c(), blockX, (double)height + 0.1, blockZ, height, 0.6);
                        }
                    }
                }
            }
            Tessellator.func_178181_a().func_78381_a();
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179140_f();
        GlStateManager.func_179098_w();
        this.lastSelected = found;
        GlStateManager.func_179121_F();
        GlStateManager.func_179101_C();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179083_b((int)0, (int)0, (int)this.field_146297_k.field_71443_c, (int)this.field_146297_k.field_71440_d);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179084_k();
    }
}

