/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.world.gen;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import gnu.trove.list.array.TByteArrayList;
import gnu.trove.map.hash.TObjectByteHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldSavedData;

public class RetroGenData
extends WorldSavedData {
    public static final boolean DEBUG = BCDebugging.shouldDebugLog("lib.gen.retro");
    public static final String NAME = "buildcraft_world_gen";
    private final Map<ChunkPos, Set<String>> gennedChunks = new HashMap<ChunkPos, Set<String>>();

    public RetroGenData() {
        this(NAME);
    }

    public RetroGenData(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        int i;
        this.gennedChunks.clear();
        NBTTagList registry = nbt.func_150295_c("registry", 8);
        String[] names = new String[registry.func_74745_c()];
        for (i = 0; i < registry.func_74745_c(); ++i) {
            names[i] = registry.func_150307_f(i);
        }
        if (DEBUG) {
            BCLog.logger.info("[lib.gen.retro] Read registry!");
            for (i = 0; i < names.length; ++i) {
                BCLog.logger.info("[lib.gen.retro]    " + i + " = \"" + names[i] + "\"");
            }
        }
        NBTTagCompound data = nbt.func_74775_l("data");
        for (String key : data.func_150296_c()) {
            ChunkPos pos = RetroGenData.deserializeChunkPos(key);
            if (pos == null) continue;
            byte[] genned = data.func_74770_j(key);
            HashSet<String> actualGenned = new HashSet<String>();
            for (byte i2 : genned) {
                if (i2 < 0 || i2 >= names.length) {
                    if (!DEBUG) continue;
                    BCLog.logger.warn("[lib.gen.retro] Invalid chunk registry id " + i2);
                    continue;
                }
                actualGenned.add(names[i2]);
            }
        }
    }

    private static ChunkPos deserializeChunkPos(String key) {
        String[] parts = key.split(",");
        if (parts.length != 2) {
            if (DEBUG) {
                BCLog.logger.warn("[lib.gen.retro] Invalid chunk key " + key);
            }
            return null;
        }
        String x = parts[0];
        String z = parts[1];
        try {
            int cx = Integer.parseInt(x);
            int cz = Integer.parseInt(z);
            return new ChunkPos(cx, cz);
        }
        catch (NumberFormatException nfe) {
            if (DEBUG) {
                BCLog.logger.warn("[lib.gen.retro] Invalid chunk key " + key + " (" + nfe.getMessage() + ")");
            }
            return null;
        }
    }

    private static String serializeChunkPos(ChunkPos pos) {
        return pos.field_77276_a + "," + pos.field_77275_b;
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        HashSet<String> allNames = new HashSet<String>();
        for (Set<String> used : this.gennedChunks.values()) {
            allNames.addAll(used);
        }
        TObjectByteHashMap map = new TObjectByteHashMap();
        ArrayList list = new ArrayList(allNames);
        NBTTagList registry = new NBTTagList();
        for (int i = 0; i < list.size(); ++i) {
            String name = (String)list.get(i);
            map.put((Object)name, (byte)i);
            registry.func_74742_a((NBTBase)new NBTTagString(name));
        }
        nbt.func_74782_a("registry", (NBTBase)registry);
        NBTTagCompound data = new NBTTagCompound();
        for (Map.Entry<ChunkPos, Set<String>> entry : this.gennedChunks.entrySet()) {
            String key = RetroGenData.serializeChunkPos(entry.getKey());
            Set<String> names = entry.getValue();
            TByteArrayList ids = new TByteArrayList();
            for (String s : names) {
                byte b = map.get((Object)s);
                ids.add(b);
            }
            data.func_74773_a(key, ids.toArray());
        }
        nbt.func_74782_a("data", (NBTBase)data);
        return nbt;
    }
}

