/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.tile.item;

import buildcraft.lib.misc.StackUtil;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

@FunctionalInterface
public interface StackInsertionFunction {
    @Nonnull
    public InsertionResult modifyForInsertion(int var1, @Nonnull ItemStack var2, @Nonnull ItemStack var3);

    public static StackInsertionFunction getInsertionFunction(int maxStackSize) {
        return (slot, addingTo, toInsert) -> {
            if (toInsert.func_190926_b()) {
                return new InsertionResult(addingTo, StackUtil.EMPTY);
            }
            if (addingTo.func_190926_b()) {
                int maxSize = Math.min(maxStackSize, toInsert.func_77976_d());
                if (toInsert.func_190916_E() <= maxSize) {
                    return new InsertionResult(toInsert, StackUtil.EMPTY);
                }
                ItemStack inserted = toInsert.func_77979_a(maxSize);
                return new InsertionResult(inserted, toInsert);
            }
            if (addingTo.func_190916_E() == maxStackSize) {
                return new InsertionResult(addingTo, toInsert);
            }
            if (StackUtil.canMerge(addingTo, toInsert)) {
                int maxSize;
                ItemStack complete = addingTo.func_77946_l();
                int count = addingTo.func_190916_E() + toInsert.func_190916_E();
                if (count <= (maxSize = Math.min(maxStackSize, complete.func_77976_d()))) {
                    complete.func_190920_e(count);
                    return new InsertionResult(complete, StackUtil.EMPTY);
                }
                complete.func_190920_e(maxSize);
                ItemStack leftOver = toInsert.func_77946_l();
                leftOver.func_190920_e(count - maxSize);
                return new InsertionResult(complete, leftOver);
            }
            return new InsertionResult(addingTo, toInsert);
        };
    }

    public static StackInsertionFunction getDefaultInserter() {
        return StackInsertionFunction.getInsertionFunction(64);
    }

    public static class InsertionResult {
        public static final InsertionResult EMPTY_STACKS = new InsertionResult(StackUtil.EMPTY, StackUtil.EMPTY);
        @Nonnull
        public final ItemStack toSet;
        @Nonnull
        public final ItemStack toReturn;

        public InsertionResult(@Nonnull ItemStack toSet, @Nonnull ItemStack toReturn) {
            this.toSet = toSet;
            this.toReturn = toReturn;
        }
    }
}

