/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.tile.item;

import buildcraft.api.core.BCLog;
import buildcraft.api.core.IStackFilter;
import buildcraft.lib.inventory.AbstractInvItemTransactor;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.tile.item.IItemHandlerAdv;
import buildcraft.lib.tile.item.StackChangeCallback;
import buildcraft.lib.tile.item.StackInsertionChecker;
import buildcraft.lib.tile.item.StackInsertionFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ReportedException;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemHandlerSimple
extends AbstractInvItemTransactor
implements IItemHandlerModifiable,
IItemHandlerAdv,
INBTSerializable<NBTTagCompound> {
    private StackInsertionChecker checker;
    private StackInsertionFunction inserter;
    @Nullable
    private final StackChangeCallback callback;
    public final NonNullList<ItemStack> stacks;
    private int firstUsed = Integer.MAX_VALUE;

    public ItemHandlerSimple(int size, @Nullable StackChangeCallback callback) {
        this(size, (slot, stack) -> true, StackInsertionFunction.getDefaultInserter(), callback);
    }

    public ItemHandlerSimple(int size, StackInsertionChecker checker, StackInsertionFunction insertionFunction, @Nullable StackChangeCallback callback) {
        this.stacks = NonNullList.func_191197_a((int)size, (Object)StackUtil.EMPTY);
        this.checker = checker;
        this.inserter = insertionFunction;
        this.callback = callback;
    }

    public void setChecker(StackInsertionChecker checker) {
        this.checker = checker;
    }

    public void setInsertor(StackInsertionFunction insertor) {
        this.inserter = insertor;
    }

    public void setLimitedInsertor(int maxStackSize) {
        this.setInsertor(StackInsertionFunction.getInsertionFunction(maxStackSize));
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (ItemStack stack : this.stacks) {
            NBTTagCompound itemNbt = new NBTTagCompound();
            stack.func_77955_b(itemNbt);
            list.func_74742_a((NBTBase)itemNbt);
        }
        nbt.func_74782_a("items", (NBTBase)list);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        int i;
        NBTTagList list = nbt.func_150295_c("items", 10);
        for (i = 0; i < list.func_74745_c() && i < this.getSlots(); ++i) {
            this.setStackInternal(i, StackUtil.EMPTY);
            ItemStack stack = new ItemStack(list.func_150305_b(i));
            ItemStack leftOver = this.insert(i, stack, false);
            if (leftOver.func_190926_b()) continue;
            BCLog.logger.error("Failed to insert a stack while reading! (" + leftOver + ")", new Throwable());
        }
        for (i = list.func_74745_c(); i < this.getSlots(); ++i) {
            this.setStackInternal(i, StackUtil.EMPTY);
        }
    }

    @Override
    public int getSlots() {
        return this.stacks.size();
    }

    private boolean badSlotIndex(int slot) {
        return slot < 0 || slot >= this.stacks.size();
    }

    @Override
    protected boolean isEmpty(int slot) {
        if (this.badSlotIndex(slot)) {
            return true;
        }
        return ((ItemStack)this.stacks.get(slot)).func_190926_b();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (this.badSlotIndex(slot)) {
            return StackUtil.EMPTY;
        }
        return ItemHandlerSimple.asValid((ItemStack)this.stacks.get(slot));
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.badSlotIndex(slot)) {
            return stack;
        }
        if (this.canSet(slot, stack)) {
            ItemStack current = (ItemStack)this.stacks.get(slot);
            StackInsertionFunction.InsertionResult result = this.inserter.modifyForInsertion(slot, ItemHandlerSimple.asValid(current.func_77946_l()), ItemHandlerSimple.asValid(stack.func_77946_l()));
            if (!this.canSet(slot, result.toSet)) {
                CrashReport report = new CrashReport("Inserting an item (buildcraft:ItemHandlerSimple)", (Throwable)new IllegalStateException("Conflicting Insertion!"));
                CrashReportCategory cat = report.func_85058_a("Inventory details");
                cat.func_71507_a("Existing Item", (Object)current);
                cat.func_71507_a("Inserting Item", (Object)stack);
                cat.func_71507_a("Slot", (Object)slot);
                cat.func_71507_a("Checker", this.checker.getClass());
                cat.func_71507_a("Inserter", this.inserter.getClass());
                throw new ReportedException(report);
            }
            if (!simulate) {
                this.setStackInternal(slot, result.toSet);
            }
            return ItemHandlerSimple.asValid(result.toReturn);
        }
        return stack;
    }

    @Override
    @Nonnull
    protected ItemStack insert(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.badSlotIndex(slot)) {
            return StackUtil.EMPTY;
        }
        ItemStack current = (ItemStack)this.stacks.get(slot);
        if (current.func_190926_b()) {
            return StackUtil.EMPTY;
        }
        if (current.func_190916_E() < amount) {
            if (simulate) {
                return ItemHandlerSimple.asValid(current.func_77946_l());
            }
            this.setStackInternal(slot, StackUtil.EMPTY);
            return current;
        }
        current = current.func_77946_l();
        ItemStack split = current.func_77979_a(amount);
        if (!simulate) {
            this.setStackInternal(slot, current);
        }
        return split;
    }

    @Override
    @Nonnull
    protected ItemStack extract(int slot, IStackFilter filter, int min, int max, boolean simulate) {
        if (this.badSlotIndex(slot)) {
            return StackUtil.EMPTY;
        }
        if (min <= 0) {
            min = 1;
        }
        if (max < min) {
            return StackUtil.EMPTY;
        }
        ItemStack current = (ItemStack)this.stacks.get(slot);
        if (current.func_190926_b() || current.func_190916_E() < min) {
            return StackUtil.EMPTY;
        }
        if (filter.matches(ItemHandlerSimple.asValid(current))) {
            if (simulate) {
                ItemStack copy = current.func_77946_l();
                return copy.func_77979_a(max);
            }
            ItemStack split = current.func_77979_a(max);
            this.setStackInternal(slot, current.func_77946_l());
            return split;
        }
        return StackUtil.EMPTY;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (this.badSlotIndex(slot)) {
            throw new IndexOutOfBoundsException("Slot index out of range: " + slot);
        }
        if (!this.canSet(slot, stack)) {
            throw new IllegalStateException("Attempted to set stack[" + slot + "] when it was invalid! (" + stack + ")");
        }
        this.setStackInternal(slot, stack);
    }

    @Override
    public final boolean canSet(int slot, @Nonnull ItemStack stack) {
        ItemStack copied = ItemHandlerSimple.asValid(stack);
        if (copied.func_190926_b()) {
            return true;
        }
        return this.checker.canSet(slot, copied);
    }

    private void setStackInternal(int slot, @Nonnull ItemStack stack) {
        ItemStack before = (ItemStack)this.stacks.get(slot);
        this.stacks.set(slot, (Object)ItemHandlerSimple.asValid(stack));
        if (stack.func_190926_b() && this.firstUsed == slot) {
            for (int s = this.firstUsed; s < this.getSlots(); ++s) {
                if (((ItemStack)this.stacks.get(s)).func_190926_b()) continue;
                this.firstUsed = s;
                break;
            }
            if (this.firstUsed == slot) {
                this.firstUsed = Integer.MAX_VALUE;
            }
        } else if (!stack.func_190926_b() && this.firstUsed > slot) {
            this.firstUsed = slot;
        }
        this.fireCallback(slot, before);
    }

    private void fireCallback(int slot, @Nonnull ItemStack before) {
        ItemStack after = (ItemStack)this.stacks.get(slot);
        if (!ItemStack.func_77989_b((ItemStack)before, (ItemStack)after) && this.callback != null) {
            this.callback.onStackChange(this, slot, before, after);
        }
    }

    public int getSlotLimit(int slot) {
        return 64;
    }
}

