/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.registry;

import buildcraft.api.transport.pipe.IItemPipe;
import buildcraft.lib.BCLibProxy;
import buildcraft.lib.block.BlockBCBase_Neptune;
import buildcraft.lib.item.IItemBuildCraft;
import java.io.File;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class RegistryHelper {
    private static final Map<ModContainer, Configuration> modObjectConfigs = new IdentityHashMap<ModContainer, Configuration>();

    public static Configuration setRegistryConfig(String modid, File file) {
        Configuration cfg = new Configuration(file);
        return RegistryHelper.setRegistryConfig(modid, cfg);
    }

    public static Configuration setRegistryConfig(String modid, Configuration config) {
        modObjectConfigs.put(RegistryHelper.getMod(modid), config);
        return config;
    }

    public static Configuration useOtherModConfigFor(String from, String to) {
        Configuration config = modObjectConfigs.get(RegistryHelper.getMod(to));
        if (config == null) {
            throw new IllegalStateException("Didn't find a config for " + to);
        }
        modObjectConfigs.put(RegistryHelper.getMod(from), config);
        return config;
    }

    public static boolean registerItem(Item item) {
        return RegistryHelper.registerItem(item, false);
    }

    public static boolean registerItem(Item item, boolean forced) {
        if (forced || RegistryHelper.isEnabled(RegistryHelper.getCategory(item), item.getRegistryName().func_110623_a(), item.func_77658_a() + ".name")) {
            GameRegistry.register((IForgeRegistryEntry)item);
            if (item instanceof IItemBuildCraft) {
                IItemBuildCraft itemBc = (IItemBuildCraft)item;
                BCLibProxy.getProxy().postRegisterItem(itemBc);
            }
            return true;
        }
        return false;
    }

    public static boolean registerBlock(Block block) {
        return RegistryHelper.registerBlock(block, false);
    }

    public static boolean registerBlock(Block block, boolean forced) {
        if (forced || RegistryHelper.isEnabled("blocks", block.getRegistryName().func_110623_a(), block.func_149739_a() + ".name")) {
            GameRegistry.register((IForgeRegistryEntry)block);
            if (block instanceof BlockBCBase_Neptune) {
                BlockBCBase_Neptune blockBc = (BlockBCBase_Neptune)block;
                BCLibProxy.getProxy().postRegisterBlock(blockBc);
            }
            return true;
        }
        return false;
    }

    public static boolean isEnabled(String category, String resourcePath, String langKey) {
        return RegistryHelper.isEnabled(RegistryHelper.getActiveMod(), category, resourcePath, langKey);
    }

    private static String getCategory(Item item) {
        if (item instanceof IItemPipe) {
            return "pipes";
        }
        return "items";
    }

    private static boolean isEnabled(ModContainer activeMod, String category, String resourcePath, String langKey) {
        Configuration config = modObjectConfigs.get(activeMod);
        if (config == null) {
            throw new RuntimeException("No config exists for the mod " + activeMod.getModId());
        }
        Property prop = config.get(category, resourcePath, true);
        prop.setLanguageKey(langKey);
        prop.setRequiresMcRestart(true);
        prop.setRequiresWorldRestart(true);
        return prop.getBoolean(true);
    }

    private static ModContainer getMod(String modid) {
        ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get(modid);
        if (container == null) {
            throw new RuntimeException("No mod with an id of \"" + modid + "\" is loaded!");
        }
        return container;
    }

    private static ModContainer getActiveMod() {
        ModContainer container = Loader.instance().activeModContainer();
        if (container == null) {
            throw new RuntimeException("Was not called within the scope of an active mod!");
        }
        return container;
    }
}

