/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.registry;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public enum MigrationManager {
    INSTANCE;

    private final Map<String, Item> itemMigrations = new HashMap<String, Item>();
    private final Map<String, Block> blockMigrations = new HashMap<String, Block>();

    public void addItemMigration(Item to, String ... oldNames) {
        if (to == null || ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)to) == null) {
            return;
        }
        for (String old : oldNames) {
            String oldLowerCase = old.toLowerCase(Locale.ROOT);
            if (this.itemMigrations.containsKey(oldLowerCase)) {
                throw new IllegalArgumentException("Already registered item migration \"" + oldLowerCase + "\"!");
            }
            this.itemMigrations.put(oldLowerCase, to);
        }
    }

    public void addBlockMigration(Block to, String ... oldNames) {
        if (to == null) {
            return;
        }
        for (String old : oldNames) {
            String oldLowerCase = old.toLowerCase(Locale.ROOT);
            if (this.blockMigrations.containsKey(oldLowerCase)) {
                throw new IllegalArgumentException("Already registered block migration \"" + oldLowerCase + "\"!");
            }
            this.blockMigrations.put(oldLowerCase, to);
        }
    }

    public void missingMappingEvent(FMLMissingMappingsEvent missing) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : missing.getAll()) {
            Item to;
            ResourceLocation loc = mapping.resourceLocation;
            String domain = loc.func_110624_b();
            String path = loc.func_110623_a().toLowerCase(Locale.ROOT);
            if (!domain.startsWith("buildcraft")) continue;
            if (mapping.type == GameRegistry.Type.ITEM) {
                if (!this.itemMigrations.containsKey(path)) continue;
                to = this.itemMigrations.get(path);
                mapping.remap(to);
                continue;
            }
            if (mapping.type != GameRegistry.Type.BLOCK || !this.blockMigrations.containsKey(path)) continue;
            to = this.blockMigrations.get(path);
            mapping.remap((Block)to);
        }
    }
}

