/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.recipe;

import buildcraft.lib.misc.StackUtil;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class NBTAwareShapedOreRecipe
extends ShapedOreRecipe {
    public NBTAwareShapedOreRecipe(@Nonnull ItemStack result, Object ... recipe) {
        super(result, recipe);
    }

    protected boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                ItemStack slot = StackUtil.asNonNull(inv.func_70463_b(x, y));
                if (target instanceof ItemStack) {
                    ItemStack targetStack = (ItemStack)target;
                    if (!OreDictionary.itemMatches((ItemStack)targetStack, (ItemStack)slot, (boolean)false)) {
                        return false;
                    }
                    if (StackUtil.doesStackNbtMatch(targetStack, slot)) continue;
                    return false;
                }
                if (target instanceof List) {
                    boolean matched = false;
                    Iterator itr = ((List)target).iterator();
                    while (itr.hasNext() && !matched) {
                        matched = OreDictionary.itemMatches((ItemStack)((ItemStack)StackUtil.asNonNull(itr.next())), (ItemStack)slot, (boolean)false);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot.func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }
}

