/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.recipe;

import buildcraft.api.recipes.IIntegrationRecipeProvider;
import buildcraft.api.recipes.IIntegrationRecipeRegistry;
import buildcraft.api.recipes.IntegrationRecipe;
import buildcraft.lib.misc.StackUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public enum IntegrationRecipeRegistry implements IIntegrationRecipeRegistry
{
    INSTANCE;

    private final Map<ResourceLocation, IntegrationRecipe> recipes = new HashMap<ResourceLocation, IntegrationRecipe>();
    private final List<IIntegrationRecipeProvider> providers = new ArrayList<IIntegrationRecipeProvider>();

    @Override
    public IntegrationRecipe getRecipeFor(@Nonnull ItemStack target, @Nonnull NonNullList<ItemStack> toIntegrate) {
        for (IntegrationRecipe recipe : this.recipes.values()) {
            if (!IntegrationRecipeRegistry.matches(recipe, target, toIntegrate)) continue;
            return recipe;
        }
        for (IIntegrationRecipeProvider provider : this.providers) {
            IntegrationRecipe possible = provider.getRecipeFor(target, toIntegrate);
            if (possible == null) continue;
            return possible;
        }
        return null;
    }

    public static boolean matches(IntegrationRecipe recipe, @Nonnull ItemStack target, NonNullList<ItemStack> toIntegrate) {
        if (!StackUtil.contains(recipe.target, target)) {
            return false;
        }
        NonNullList toIntegrateCopy = toIntegrate.stream().filter(stack -> !stack.func_190926_b()).collect(StackUtil.nonNullListCollector());
        boolean stackMatches = recipe.toIntegrate.stream().allMatch(definition -> {
            boolean matches = false;
            Iterator iterator = toIntegrateCopy.iterator();
            while (iterator.hasNext()) {
                ItemStack stack = (ItemStack)iterator.next();
                if (!StackUtil.contains(definition, stack)) continue;
                matches = true;
                iterator.remove();
                break;
            }
            return matches;
        });
        return stackMatches && toIntegrateCopy.isEmpty();
    }

    @Override
    public void addRecipe(IntegrationRecipe recipe) {
        if (this.recipes.containsKey(recipe.name)) {
            throw new IllegalStateException("Trying to override integration recipe with name " + recipe.name + ".\nIf you want replace recipe remove old one first.");
        }
        this.recipes.put(recipe.name, recipe);
    }

    @Override
    public void addRecipeProvider(IIntegrationRecipeProvider provider) {
        this.providers.add(provider);
    }

    @Override
    public Iterable<IntegrationRecipe> getAllRecipes() {
        return this.recipes.values();
    }

    @Override
    public Iterable<IIntegrationRecipeProvider> getAllRecipeProviders() {
        return this.providers;
    }

    @Override
    public Optional<IntegrationRecipe> getRecipe(@Nonnull ResourceLocation name, @Nullable NBTTagCompound recipeTag) {
        IntegrationRecipe recipe = this.recipes.get(name);
        if (recipe != null) {
            return Optional.of(recipe);
        }
        return this.providers.stream().map(provider -> provider.getRecipe(name, recipeTag).orElse(null)).filter(Objects::nonNull).findFirst();
    }
}

