/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.recipe;

import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.api.recipes.IAssemblyRecipeProvider;
import buildcraft.api.recipes.IAssemblyRecipeRegistry;
import buildcraft.lib.misc.StackUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public enum AssemblyRecipeRegistry implements IAssemblyRecipeRegistry
{
    INSTANCE;

    private final Map<ResourceLocation, AssemblyRecipe> recipes = new HashMap<ResourceLocation, AssemblyRecipe>();
    private final List<IAssemblyRecipeProvider> providers = new ArrayList<IAssemblyRecipeProvider>();

    @Override
    @Nonnull
    public List<AssemblyRecipe> getRecipesFor(@Nonnull NonNullList<ItemStack> possibleIn) {
        ArrayList<AssemblyRecipe> all = new ArrayList<AssemblyRecipe>();
        for (AssemblyRecipe ar : this.recipes.values()) {
            if (!ar.requiredStacks.stream().allMatch(definition -> StackUtil.contains(definition, possibleIn))) continue;
            all.add(ar);
        }
        for (IAssemblyRecipeProvider provider : this.providers) {
            all.addAll(provider.getRecipesFor(possibleIn));
        }
        return all;
    }

    @Override
    public void addRecipe(@Nonnull AssemblyRecipe recipe) {
        if (this.recipes.containsKey(recipe.name)) {
            throw new IllegalStateException("Trying to override assembly recipe with name " + recipe.name + ".\nIf you want replace recipe remove old one first.");
        }
        this.recipes.put(recipe.name, recipe);
    }

    @Override
    public void addRecipeProvider(@Nonnull IAssemblyRecipeProvider provider) {
        this.providers.add(provider);
    }

    @Override
    public Iterable<AssemblyRecipe> getAllRecipes() {
        return this.recipes.values();
    }

    @Override
    public Iterable<IAssemblyRecipeProvider> getAllRecipeProviders() {
        return this.providers;
    }

    @Override
    public Optional<AssemblyRecipe> getRecipe(@Nonnull ResourceLocation name, @Nullable NBTTagCompound recipeTag) {
        AssemblyRecipe recipe = this.recipes.get(name);
        if (recipe != null) {
            return Optional.of(recipe);
        }
        return this.providers.stream().map(provider -> provider.getRecipe(name, recipeTag).orElse(null)).filter(Objects::nonNull).findFirst();
    }
}

