/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.net.cache;

import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.net.cache.BuildCraftObjectCaches;
import buildcraft.lib.net.cache.NetworkedObjectCache;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;

public class MessageObjectCacheReply
implements IMessage {
    private int cacheId;
    private int[] ids;
    private byte[][] values;
    public static final IMessageHandler<MessageObjectCacheReply, IMessage> HANDLER = (message, ctx) -> {
        try {
            NetworkedObjectCache<?> cache = BuildCraftObjectCaches.CACHES.get(message.cacheId);
            for (int i = 0; i < message.ids.length; ++i) {
                int id = message.ids[i];
                byte[] payload = message.values[i];
                cache.readObjectClient(id, new PacketBufferBC(Unpooled.copiedBuffer((byte[])payload)));
            }
            return null;
        }
        catch (IOException io) {
            throw new Error(io);
        }
    };

    @Deprecated
    public MessageObjectCacheReply() {
    }

    MessageObjectCacheReply(int cacheId, int[] ids, byte[][] values) {
        this.cacheId = cacheId;
        this.ids = ids;
        this.values = values;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.cacheId);
        buf.writeShort(this.ids.length);
        for (int i = 0; i < this.ids.length; ++i) {
            buf.writeInt(this.ids[i]);
            buf.writeShort(this.values[i].length);
            buf.writeBytes(this.values[i]);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.cacheId = buf.readByte();
        int idCount = buf.readShort();
        this.ids = new int[idCount];
        this.values = new byte[idCount][];
        for (int i = 0; i < idCount; ++i) {
            this.ids[i] = buf.readInt();
            this.values[i] = new byte[buf.readShort()];
            buf.readBytes(this.values[i]);
        }
    }
}

