/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.net;

import buildcraft.api.core.BCLog;
import buildcraft.lib.BCLibProxy;
import buildcraft.lib.marker.MarkerCache;
import buildcraft.lib.marker.MarkerSubCache;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.net.MessageManager;
import buildcraft.lib.net.PacketBufferBC;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageMarker
implements IMessage {
    private static final boolean DEBUG = MessageManager.DEBUG;
    public boolean add;
    public boolean multiple;
    public boolean connection;
    public int cacheId;
    public int count;
    public final List<BlockPos> positions = new ArrayList<BlockPos>();
    private static final BiConsumer<MessageMarker, MessageContext> HANDLER_CLIENT = (message, ctx) -> {
        World world = BCLibProxy.getProxy().getClientWorld();
        if (world == null) {
            if (DEBUG) {
                BCLog.logger.warn("[lib.messages][marker] The world was null for a message!");
            }
            return;
        }
        if (message.cacheId < 0 || message.cacheId >= MarkerCache.CACHES.size()) {
            if (DEBUG) {
                BCLog.logger.warn("[lib.messages][marker] The cache ID " + message.cacheId + " was invalid!");
            }
            return;
        }
        MarkerCache<?> cache = MarkerCache.CACHES.get(message.cacheId);
        ((MarkerSubCache)cache.getSubCache(world)).handleMessageMain((MessageMarker)message);
    };
    public static final IMessageHandler<MessageMarker, IMessage> HANDLER = (message, ctx) -> {
        HANDLER_CLIENT.accept((MessageMarker)message, ctx);
        return null;
    };

    public void fromBytes(ByteBuf buf) {
        PacketBufferBC packet = PacketBufferBC.asPacketBufferBc(buf);
        this.add = packet.readBoolean();
        this.multiple = packet.readBoolean();
        this.connection = packet.readBoolean();
        this.cacheId = packet.readShort();
        this.count = this.multiple ? (int)packet.readShort() : 1;
        for (int i = 0; i < this.count; ++i) {
            this.positions.add(MessageUtil.readBlockPos(packet));
        }
    }

    public void toBytes(ByteBuf buf) {
        this.count = this.positions.size();
        this.multiple = this.count != 1;
        PacketBufferBC packet = PacketBufferBC.asPacketBufferBc(buf);
        packet.writeBoolean(this.add);
        packet.writeBoolean(this.multiple);
        packet.writeBoolean(this.connection);
        packet.writeShort(this.cacheId);
        if (this.multiple) {
            packet.writeShort(this.count);
        }
        for (BlockPos pos : this.positions) {
            MessageUtil.writeBlockPos(packet, pos);
        }
    }

    public String toString() {
        boolean[] flags = new boolean[]{this.add, this.multiple, this.connection};
        return "Message Marker [" + Arrays.toString(flags) + ", cacheId " + this.cacheId + ", count = " + this.count + ", positions = " + this.positions + "]";
    }
}

