/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.net;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import buildcraft.lib.BCLibProxy;
import buildcraft.lib.misc.MessageUtil;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class MessageManager {
    public static final boolean DEBUG = BCDebugging.shouldDebugLog("lib.messages");
    private static SimpleNetworkWrapper netWrapper;
    private static final Set<MessageType<?, ?>> MESSAGE_TYPES;

    public static <I extends IMessage, O extends IMessage> void addMessageType(Class<I> messageClass, IMessageHandler<I, O> handler, Side ... sides) {
        if (netWrapper != null) {
            throw new IllegalStateException("Must register all messages BEFORE post-init!");
        }
        MESSAGE_TYPES.add(new MessageType<I, O>(messageClass, handler, sides));
    }

    public static void fmlPostInit() {
        netWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("bc-lib");
        int i = 0;
        if (DEBUG) {
            BCLog.logger.info("[lib.messages] Sorted list of messages:");
        }
        for (MessageType<?, ?> messageType : MESSAGE_TYPES) {
            for (Side side : messageType.sides) {
                if (DEBUG) {
                    BCLog.logger.info("  " + i + " = " + messageType.messageClass.getName() + " " + Arrays.toString(messageType.sides));
                }
                MessageManager.addInternal(messageType, i++, side);
            }
        }
        if (DEBUG) {
            BCLog.logger.info("[lib.messages] Total of " + MESSAGE_TYPES.size() + " messages");
        }
    }

    private static <I extends IMessage, O extends IMessage> void addInternal(MessageType<I, O> messageType, int discriminator, Side side) {
        IMessageHandler handler = (message, context) -> {
            EntityPlayer player = BCLibProxy.getProxy().getPlayerForContext(context);
            if (player == null || player.field_70170_p == null) {
                return null;
            }
            BCLibProxy.getProxy().addScheduledTask(player.field_70170_p, () -> {
                IMessage reply = messageType.handler.onMessage(message, context);
                if (reply != null) {
                    MessageUtil.sendReturnMessage(context, reply);
                }
            });
            return null;
        };
        netWrapper.registerMessage(handler, messageType.messageClass, discriminator, side);
    }

    public static void sendToAll(IMessage message) {
        netWrapper.sendToAll(message);
    }

    public static void sendTo(IMessage message, EntityPlayerMP player) {
        netWrapper.sendTo(message, player);
    }

    public static void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        netWrapper.sendToAllAround(message, point);
    }

    public static void sendToDimension(IMessage message, int dimensionId) {
        netWrapper.sendToDimension(message, dimensionId);
    }

    public static void sendToServer(IMessage message) {
        netWrapper.sendToServer(message);
    }

    static {
        MESSAGE_TYPES = new TreeSet();
    }

    private static class MessageType<I extends IMessage, O extends IMessage>
    implements Comparable<MessageType<?, ?>> {
        @Nonnull
        public final Class<I> messageClass;
        @Nonnull
        public final IMessageHandler<I, O> handler;
        @Nonnull
        public final Side[] sides;

        public MessageType(@Nonnull Class<I> messageClass, @Nonnull IMessageHandler<I, O> handler, Side ... sides) {
            this.messageClass = messageClass;
            this.handler = handler;
            this.sides = sides;
        }

        @Override
        public int compareTo(@Nonnull MessageType<?, ?> o) {
            if (this.messageClass != o.messageClass) {
                return this.messageClass.getName().compareTo(o.messageClass.getName());
            }
            if (this.sides.length != o.sides.length) {
                return Integer.compare(this.sides.length, o.sides.length);
            }
            return this.sides.length != 1 ? 0 : this.sides[0].compareTo((Enum)o.sides[0]);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MessageType that = (MessageType)o;
            if (!this.messageClass.equals(that.messageClass)) {
                return false;
            }
            if (!this.handler.equals(that.handler)) {
                return false;
            }
            return Arrays.equals(this.sides, that.sides);
        }

        public int hashCode() {
            int result = this.messageClass.hashCode();
            result = 31 * result + this.handler.hashCode();
            result = 31 * result + Arrays.hashCode(this.sides);
            return result;
        }
    }
}

