/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.lib.misc.ColourUtil;
import com.google.common.base.Splitter;
import java.text.DecimalFormat;
import java.util.List;
import java.util.function.Function;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;

public final class StringUtilBC {
    public static final Splitter newLineSplitter = Splitter.on((String)"\\n");
    private static final DecimalFormat displayDecimalFormat = new DecimalFormat("#####0.00");

    private StringUtilBC() {
    }

    public static List<String> splitIntoLines(String string) {
        return newLineSplitter.splitToList((CharSequence)string.replaceAll("\\n", "\n"));
    }

    public static String formatStringForWhite(String string) {
        return StringUtilBC.formatStringImpl(string, ColourUtil.getTextFormatForWhite);
    }

    public static String formatStringForBlack(String string) {
        return StringUtilBC.formatStringImpl(string, ColourUtil.getTextFormatForBlack);
    }

    private static String formatStringImpl(String string, Function<TextFormatting, TextFormatting> fn) {
        StringBuilder out = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u00a7' & string.length() > i + 2) {
                char after = string.charAt(++i);
                TextFormatting colour = null;
                if (after >= '0' & after <= '9') {
                    colour = TextFormatting.func_175744_a((int)(after - 48));
                } else if (after >= 'a' & after <= 'f') {
                    colour = TextFormatting.func_175744_a((int)(after - 97 + 10));
                }
                if (colour == null) {
                    out.append(c);
                    out.append(after);
                    continue;
                }
                out.append(fn.apply(colour).toString());
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String blockPosToString(BlockPos pos) {
        return pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p();
    }

    public static String blockPosAsSizeToString(BlockPos pos) {
        return pos.func_177958_n() + "x" + pos.func_177956_o() + "x" + pos.func_177952_p();
    }

    public static String vec3ToDispString(Vec3d vec) {
        if (vec == null) {
            return "null";
        }
        return displayDecimalFormat.format(vec.field_72450_a) + ", " + displayDecimalFormat.format(vec.field_72448_b) + ", " + displayDecimalFormat.format(vec.field_72449_c);
    }

    public static String vec3ToDispString(Vec3i vec) {
        if (vec == null) {
            return "null";
        }
        return vec.func_177958_n() + ", " + vec.func_177956_o() + ", " + vec.func_177952_p();
    }

    public static String replaceCharactersForFilename(String original) {
        return original.replace("/", "-").replace("\\", "-").replace(":", "-").replace("*", "-").replace("?", "-").replace("\"", "-").replace("<", "-").replace(">", "-").replace("|", "-");
    }
}

