/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.lib.misc.VecUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class PositionUtil {
    @Nullable
    public static EnumFacing getDirectFacingOffset(BlockPos from, BlockPos to) {
        boolean z;
        BlockPos diff = to.func_177973_b((Vec3i)from);
        boolean x = diff.func_177958_n() != 0;
        boolean y = diff.func_177956_o() != 0;
        boolean bl = z = diff.func_177952_p() != 0;
        if (x && y || x && z || y && z) {
            return null;
        }
        if (x) {
            return diff.func_177958_n() > 0 ? EnumFacing.EAST : EnumFacing.WEST;
        }
        if (y) {
            return diff.func_177956_o() > 0 ? EnumFacing.UP : EnumFacing.DOWN;
        }
        if (z) {
            return diff.func_177952_p() > 0 ? EnumFacing.SOUTH : EnumFacing.NORTH;
        }
        return null;
    }

    public static Set<BlockPos> getCorners(BlockPos min, BlockPos max) {
        if (min == null || max == null) {
            return ImmutableSet.of();
        }
        if (min.equals((Object)max)) {
            return ImmutableSet.of((Object)min);
        }
        ImmutableSet.Builder set = ImmutableSet.builder();
        set.add((Object)min);
        set.add((Object)new BlockPos(max.func_177958_n(), min.func_177956_o(), min.func_177952_p()));
        set.add((Object)new BlockPos(min.func_177958_n(), max.func_177956_o(), min.func_177952_p()));
        set.add((Object)new BlockPos(max.func_177958_n(), max.func_177956_o(), min.func_177952_p()));
        set.add((Object)new BlockPos(min.func_177958_n(), min.func_177956_o(), max.func_177952_p()));
        set.add((Object)new BlockPos(max.func_177958_n(), min.func_177956_o(), max.func_177952_p()));
        set.add((Object)new BlockPos(min.func_177958_n(), max.func_177956_o(), max.func_177952_p()));
        set.add((Object)max);
        return set.build();
    }

    public static boolean isOnEdge(BlockPos min, BlockPos max, BlockPos pos) {
        if (min == null || max == null || pos == null) {
            return false;
        }
        int same = 0;
        if (min.func_177958_n() == pos.func_177958_n() || max.func_177958_n() == pos.func_177958_n()) {
            ++same;
        }
        if (min.func_177956_o() == pos.func_177956_o() || max.func_177956_o() == pos.func_177956_o()) {
            ++same;
        }
        if (min.func_177952_p() == pos.func_177952_p() || max.func_177952_p() == pos.func_177952_p()) {
            ++same;
        }
        return same >= 2;
    }

    public static boolean isNextTo(BlockPos one, BlockPos two) {
        boolean z;
        boolean y;
        BlockPos diff = one.func_177973_b((Vec3i)two);
        boolean x = diff.func_177958_n() == 1 || diff.func_177958_n() == -1;
        boolean bl = y = diff.func_177956_o() == 1 || diff.func_177956_o() == -1;
        if (x && y) {
            return false;
        }
        boolean bl2 = z = diff.func_177952_p() == 1 || diff.func_177952_p() == -1;
        if (y && z) {
            return false;
        }
        return x != z;
    }

    public static Rotation getRotatedFacing(EnumFacing from, EnumFacing to, EnumFacing.Axis axis) {
        if (from.func_176740_k() == axis || to.func_176740_k() == axis) {
            throw new IllegalArgumentException("Cannot rotate around " + axis + " with " + from + " and " + to);
        }
        if (from == to) {
            return Rotation.NONE;
        }
        if (from.func_176734_d() == to) {
            return Rotation.CLOCKWISE_180;
        }
        if (from.func_176732_a(axis) == to) {
            return Rotation.CLOCKWISE_90;
        }
        return Rotation.COUNTERCLOCKWISE_90;
    }

    public static EnumFacing rotateFacing(EnumFacing from, EnumFacing.Axis axis, Rotation rotation) {
        if (rotation == Rotation.NONE || rotation == null) {
            return from;
        }
        if (from.func_176740_k() == axis) {
            return from;
        }
        if (rotation == Rotation.CLOCKWISE_180) {
            return from.func_176734_d();
        }
        if (rotation == Rotation.COUNTERCLOCKWISE_90) {
            from = from.func_176734_d();
        }
        return from.func_176732_a(axis);
    }

    public static Vec3d rotateVec(Vec3d from, EnumFacing.Axis axis, Rotation rotation) {
        Vec3d rotated = new Vec3d(0.0, 0.0, 0.0);
        double numEast = from.field_72450_a;
        double numUp = from.field_72448_b;
        double numSouth = from.field_72449_c;
        EnumFacing newEast = PositionUtil.rotateFacing(EnumFacing.EAST, axis, rotation);
        EnumFacing newUp = PositionUtil.rotateFacing(EnumFacing.UP, axis, rotation);
        EnumFacing newSouth = PositionUtil.rotateFacing(EnumFacing.SOUTH, axis, rotation);
        rotated = VecUtil.replaceValue(rotated, newEast.func_176740_k(), numEast * (double)newEast.func_176743_c().func_179524_a());
        rotated = VecUtil.replaceValue(rotated, newUp.func_176740_k(), numUp * (double)newUp.func_176743_c().func_179524_a());
        rotated = VecUtil.replaceValue(rotated, newSouth.func_176740_k(), numSouth * (double)newSouth.func_176743_c().func_179524_a());
        return rotated;
    }

    public static BlockPos rotatePos(Vec3i from, EnumFacing.Axis axis, Rotation rotation) {
        BlockPos rotated = new BlockPos(0, 0, 0);
        int numEast = from.func_177958_n();
        int numUp = from.func_177956_o();
        int numSouth = from.func_177952_p();
        EnumFacing newEast = PositionUtil.rotateFacing(EnumFacing.EAST, axis, rotation);
        EnumFacing newUp = PositionUtil.rotateFacing(EnumFacing.UP, axis, rotation);
        EnumFacing newSouth = PositionUtil.rotateFacing(EnumFacing.SOUTH, axis, rotation);
        rotated = VecUtil.replaceValue((Vec3i)rotated, newEast.func_176740_k(), numEast * newEast.func_176743_c().func_179524_a());
        rotated = VecUtil.replaceValue((Vec3i)rotated, newUp.func_176740_k(), numUp * newUp.func_176743_c().func_179524_a());
        rotated = VecUtil.replaceValue((Vec3i)rotated, newSouth.func_176740_k(), numSouth * newSouth.func_176743_c().func_179524_a());
        return rotated;
    }

    public static LineSkewResult findLineSkewPoint(Line line, Vec3d start, Vec3d direction) {
        double ia = 0.0;
        double ib = 1.0;
        double da = 0.0;
        double db = 0.0;
        double id = 0.5;
        Vec3d best = null;
        for (int i = 0; i < 10; ++i) {
            Vec3d a = line.interpolate(ia);
            Vec3d b = line.interpolate(ib);
            Vec3d va = PositionUtil.closestPointOnLineToPoint(a, start, direction);
            Vec3d vb = PositionUtil.closestPointOnLineToPoint(b, start, direction);
            da = a.func_72436_e(va);
            if (da < (db = b.func_72436_e(vb))) {
                best = a;
                ib -= id;
            } else {
                best = b;
                ia += id;
            }
            id /= 2.0;
        }
        return new LineSkewResult(best, Math.sqrt(Math.min(da, db)));
    }

    public static Vec3d closestPointOnLineToPoint(Vec3d point, Vec3d linePoint, Vec3d lineVector) {
        Vec3d v = lineVector.func_72432_b();
        Vec3d p1 = linePoint;
        Vec3d p2 = point;
        Vec3d p2_minus_p1 = p2.func_178788_d(p1);
        double _dot_v = VecUtil.dot(p2_minus_p1, v);
        Vec3d _scale_v = VecUtil.scale(v, _dot_v);
        return p1.func_178787_e(_scale_v);
    }

    public static ImmutableList<BlockPos> getAllOnEdge(BlockPos min, BlockPos max) {
        boolean addZ;
        ImmutableList.Builder list = ImmutableList.builder();
        boolean addX = max.func_177958_n() != min.func_177958_n();
        boolean addY = max.func_177956_o() != min.func_177956_o();
        boolean bl = addZ = max.func_177952_p() != min.func_177952_p();
        if (addX & addY & addZ) {
            return PositionUtil.getAllOnEdgeFull(min, max);
        }
        for (int x = min.func_177958_n(); x <= max.func_177958_n(); ++x) {
            list.add((Object)new BlockPos(x, min.func_177956_o(), min.func_177952_p()));
            if (addY) {
                list.add((Object)new BlockPos(x, max.func_177956_o(), min.func_177952_p()));
                if (!addZ) continue;
                list.add((Object)new BlockPos(x, max.func_177956_o(), max.func_177952_p()));
                continue;
            }
            if (!addZ) continue;
            list.add((Object)new BlockPos(x, min.func_177956_o(), max.func_177952_p()));
        }
        if (addY) {
            for (int y = min.func_177956_o() + 1; y < max.func_177956_o(); ++y) {
                list.add((Object)new BlockPos(min.func_177958_n(), y, min.func_177952_p()));
                if (addX) {
                    list.add((Object)new BlockPos(max.func_177958_n(), y, min.func_177952_p()));
                    if (!addZ) continue;
                    list.add((Object)new BlockPos(max.func_177958_n(), y, max.func_177952_p()));
                    continue;
                }
                if (!addZ) continue;
                list.add((Object)new BlockPos(min.func_177958_n(), y, max.func_177952_p()));
            }
        }
        if (addZ) {
            for (int z = min.func_177952_p() + 1; z < max.func_177952_p(); ++z) {
                list.add((Object)new BlockPos(min.func_177958_n(), min.func_177956_o(), z));
                if (addX) {
                    list.add((Object)new BlockPos(max.func_177958_n(), min.func_177956_o(), z));
                    if (!addY) continue;
                    list.add((Object)new BlockPos(max.func_177958_n(), max.func_177956_o(), z));
                    continue;
                }
                list.add((Object)new BlockPos(min.func_177958_n(), max.func_177956_o(), z));
            }
        }
        return list.build();
    }

    private static ImmutableList<BlockPos> getAllOnEdgeFull(BlockPos min, BlockPos max) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (int x = min.func_177958_n(); x <= max.func_177958_n(); ++x) {
            list.add((Object)new BlockPos(x, min.func_177956_o(), min.func_177952_p()));
            list.add((Object)new BlockPos(x, max.func_177956_o(), min.func_177952_p()));
            list.add((Object)new BlockPos(x, max.func_177956_o(), max.func_177952_p()));
            list.add((Object)new BlockPos(x, min.func_177956_o(), max.func_177952_p()));
        }
        for (int y = min.func_177956_o() + 1; y < max.func_177956_o(); ++y) {
            list.add((Object)new BlockPos(min.func_177958_n(), y, min.func_177952_p()));
            list.add((Object)new BlockPos(max.func_177958_n(), y, min.func_177952_p()));
            list.add((Object)new BlockPos(max.func_177958_n(), y, max.func_177952_p()));
            list.add((Object)new BlockPos(min.func_177958_n(), y, max.func_177952_p()));
        }
        for (int z = min.func_177952_p() + 1; z < max.func_177952_p(); ++z) {
            list.add((Object)new BlockPos(min.func_177958_n(), min.func_177956_o(), z));
            list.add((Object)new BlockPos(max.func_177958_n(), min.func_177956_o(), z));
            list.add((Object)new BlockPos(max.func_177958_n(), max.func_177956_o(), z));
            list.add((Object)new BlockPos(min.func_177958_n(), max.func_177956_o(), z));
        }
        return list.build();
    }

    public static ImmutableList<BlockPos> getAllOnPath(BlockPos from, BlockPos to) {
        ImmutableList.Builder interp = ImmutableList.builder();
        BlockPos difference = to.func_177973_b((Vec3i)from);
        int ax = Math.abs(difference.func_177958_n());
        int ay = Math.abs(difference.func_177956_o());
        int az = Math.abs(difference.func_177952_p());
        int count = ax + ay + az;
        BlockPos current = from;
        int ddx = difference.func_177958_n() > 0 ? 1 : -1;
        int ddy = difference.func_177956_o() > 0 ? 1 : -1;
        int ddz = difference.func_177952_p() > 0 ? 1 : -1;
        int dx = count / 2;
        int dy = count / 2;
        int dz = count / 2;
        for (int j = 0; j < count; ++j) {
            dy += ay;
            dz += az;
            boolean changed = false;
            if ((dx += ax) >= count) {
                changed = true;
                dx -= count;
                current = current.func_177982_a(ddx, 0, 0);
            }
            if (dy >= count) {
                changed = true;
                dy -= count;
                current = current.func_177982_a(0, ddy, 0);
            }
            if (dz >= count) {
                changed = true;
                dz -= count;
                current = current.func_177982_a(0, 0, ddz);
            }
            if (!changed) continue;
            interp.add((Object)current);
        }
        return interp.build();
    }

    public static BlockPos randomBlockPos(Random rand, BlockPos size) {
        return new BlockPos(rand.nextInt(size.func_177958_n()), rand.nextInt(size.func_177956_o()), rand.nextInt(size.func_177952_p()));
    }

    public static BlockPos randomBlockPos(Random rand, BlockPos min, BlockPos max) {
        return new BlockPos(min.func_177958_n() + rand.nextInt(max.func_177958_n() - min.func_177958_n()), min.func_177956_o() + rand.nextInt(max.func_177956_o() - min.func_177956_o()), min.func_177952_p() + rand.nextInt(max.func_177952_p() - min.func_177952_p()));
    }

    public static class Line {
        public final Vec3d start;
        public final Vec3d end;

        public Line(Vec3d start, Vec3d end) {
            this.start = start;
            this.end = end;
        }

        public static Line createLongLine(Vec3d start, Vec3d direction) {
            return new Line(start, VecUtil.scale(direction, 1024.0));
        }

        public Vec3d interpolate(double interp) {
            return VecUtil.scale(this.start, 1.0 - interp).func_178787_e(VecUtil.scale(this.end, interp));
        }
    }

    public static class LineSkewResult {
        public final Vec3d closestPos;
        public final double distFromLine;

        public LineSkewResult(Vec3d closestPos, double distFromLine) {
            this.closestPos = closestPos;
            this.distFromLine = distFromLine;
        }
    }
}

