/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.api.core.BCLog;
import buildcraft.api.core.InvalidInputDataException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public final class NBTUtilBC {
    private static final String NULL_ENUM_STRING = "_NULL";

    private NBTUtilBC() {
    }

    public static NBTTagCompound load(byte[] data) {
        try {
            NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(data));
            return nbt;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static NBTTagCompound getItemData(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return new NBTTagCompound();
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        return nbt;
    }

    public static void writeUUID(NBTTagCompound data, String tag, UUID uuid) {
        if (uuid == null) {
            return;
        }
        NBTTagCompound nbtTag = new NBTTagCompound();
        nbtTag.func_74772_a("most", uuid.getMostSignificantBits());
        nbtTag.func_74772_a("least", uuid.getLeastSignificantBits());
        data.func_74782_a(tag, (NBTBase)nbtTag);
    }

    public static UUID readUUID(NBTTagCompound data, String tag) {
        if (data.func_74764_b(tag)) {
            NBTTagCompound nbtTag = data.func_74775_l(tag);
            return new UUID(nbtTag.func_74763_f("most"), nbtTag.func_74763_f("least"));
        }
        return null;
    }

    public static byte[] save(NBTTagCompound compound) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public static NBTTagIntArray writeBlockPos(BlockPos pos) {
        if (pos == null) {
            throw new NullPointerException("Cannot return a null NBTTag -- pos was null!");
        }
        return new NBTTagIntArray(new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
    }

    public static NBTTagCompound writeBlockPosAsCompound(BlockPos pos) {
        if (pos == null) {
            throw new NullPointerException("Cannot return a null NBTTag -- pos was null!");
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("x", pos.func_177958_n());
        nbt.func_74768_a("y", pos.func_177956_o());
        nbt.func_74768_a("z", pos.func_177952_p());
        return nbt;
    }

    @Nullable
    public static BlockPos readBlockPos(NBTBase base) {
        if (base == null) {
            return null;
        }
        switch (base.func_74732_a()) {
            case 11: {
                int[] array = ((NBTTagIntArray)base).func_150302_c();
                if (array.length == 3) {
                    return new BlockPos(array[0], array[1], array[2]);
                }
                return null;
            }
            case 10: {
                NBTTagCompound nbt = (NBTTagCompound)base;
                BlockPos pos = null;
                if (nbt.func_74764_b("i")) {
                    int i = nbt.func_74762_e("i");
                    int j = nbt.func_74762_e("j");
                    int k = nbt.func_74762_e("k");
                    pos = new BlockPos(i, j, k);
                } else if (nbt.func_74764_b("x")) {
                    int x = nbt.func_74762_e("x");
                    int y = nbt.func_74762_e("y");
                    int z = nbt.func_74762_e("z");
                    pos = new BlockPos(x, y, z);
                } else {
                    if (nbt.func_74764_b("pos")) {
                        return NBTUtilBC.readBlockPos(nbt.func_74781_a("pos"));
                    }
                    BCLog.logger.warn("Attempted to read a block positions from a compound tag without the correct sub-tags! (" + base + ")", new Throwable());
                }
                return pos;
            }
        }
        BCLog.logger.warn("Attempted to read a block position from an invalid tag! (" + base + ")", new Throwable());
        return null;
    }

    public static NBTTagList writeVec3d(Vec3d vec3) {
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagDouble(vec3.field_72450_a));
        list.func_74742_a((NBTBase)new NBTTagDouble(vec3.field_72448_b));
        list.func_74742_a((NBTBase)new NBTTagDouble(vec3.field_72449_c));
        return list;
    }

    @Nullable
    public static Vec3d readVec3d(NBTBase nbt) {
        if (nbt instanceof NBTTagList) {
            return NBTUtilBC.readVec3d((NBTTagList)nbt);
        }
        return null;
    }

    public static Vec3d readVec3d(NBTTagCompound nbt, String tagName) {
        return NBTUtilBC.readVec3d(nbt.func_150295_c(tagName, 6));
    }

    public static Vec3d readVec3d(NBTTagList list) {
        return new Vec3d(list.func_150309_d(0), list.func_150309_d(1), list.func_150309_d(2));
    }

    public static <E extends Enum<E>> NBTBase writeEnum(E value) {
        if (value == null) {
            return new NBTTagString(NULL_ENUM_STRING);
        }
        return new NBTTagString(value.name());
    }

    public static <E extends Enum<E>> E readEnum(NBTBase nbt, Class<E> clazz) {
        if (nbt instanceof NBTTagString) {
            String value = ((NBTTagString)nbt).func_150285_a_();
            if (NULL_ENUM_STRING.equals(value)) {
                return null;
            }
            try {
                return Enum.valueOf(clazz, value);
            }
            catch (Throwable t) {
                BCLog.logger.warn("Tried and failed to read the value(" + value + ") from " + clazz.getSimpleName(), t);
                return null;
            }
        }
        if (nbt instanceof NBTTagByte) {
            byte value = ((NBTTagByte)nbt).func_150290_f();
            if (value < 0 || value >= ((Enum[])clazz.getEnumConstants()).length) {
                return null;
            }
            return (E)((Enum[])clazz.getEnumConstants())[value];
        }
        if (nbt == null) {
            return null;
        }
        BCLog.logger.warn((Object)new IllegalArgumentException("Tried to read an enum value when it was not a string! This is probably not good!"));
        return null;
    }

    public static NBTBase writeDoubleArray(double[] data) {
        NBTTagList list = new NBTTagList();
        for (double d : data) {
            list.func_74742_a((NBTBase)new NBTTagDouble(d));
        }
        return list;
    }

    public static double[] readDoubleArray(NBTBase tag, int intendedLength) {
        double[] arr = new double[intendedLength];
        if (tag instanceof NBTTagList) {
            NBTTagList list = (NBTTagList)tag;
            for (int i = 0; i < list.func_74745_c() && i < intendedLength; ++i) {
                arr[i] = list.func_150309_d(i);
            }
        }
        return arr;
    }

    public static NBTTagCompound writeEntireBlockState(IBlockState state) {
        if (state == null || state == Blocks.field_150350_a.func_176223_P()) {
            return new NBTTagCompound();
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("block", state.func_177230_c().getRegistryName().toString());
        nbt.func_74782_a("state", (NBTBase)NBTUtilBC.writeBlockStateProperties(state));
        return nbt;
    }

    public static IBlockState readEntireBlockState(NBTTagCompound nbt) throws InvalidInputDataException {
        if (nbt.func_82582_d()) {
            return Blocks.field_150350_a.func_176223_P();
        }
        Block block = Block.func_149684_b((String)nbt.func_74779_i("block"));
        if (block == null || block == Blocks.field_150350_a) {
            throw new InvalidInputDataException("Unknown block " + nbt.func_74779_i("block"));
        }
        return NBTUtilBC.readBlockStateProperties(block.func_176223_P(), nbt.func_74775_l("state"));
    }

    public static NBTTagCompound writeBlockStateProperties(IBlockState state) {
        NBTTagCompound nbt = new NBTTagCompound();
        for (IProperty prop : state.func_177227_a()) {
            nbt.func_74778_a(prop.func_177701_a().toLowerCase(Locale.ROOT), NBTUtilBC.getPropName(state, prop));
        }
        return nbt;
    }

    private static <V extends Comparable<V>> String getPropName(IBlockState state, IProperty<V> prop) {
        return prop.func_177702_a(state.func_177229_b(prop)).toLowerCase(Locale.ROOT);
    }

    public static IBlockState readBlockStateProperties(IBlockState state, NBTTagCompound nbt) {
        for (IProperty prop : state.func_177227_a()) {
            state = NBTUtilBC.updateState(state, prop, nbt.func_74779_i(prop.func_177701_a().toLowerCase(Locale.ROOT)));
        }
        return state;
    }

    private static <V extends Comparable<V>> IBlockState updateState(IBlockState state, IProperty<V> prop, String string) {
        for (Comparable val : prop.func_177700_c()) {
            if (!prop.func_177702_a(val).equalsIgnoreCase(string)) continue;
            return state.func_177226_a(prop, val);
        }
        BCLog.logger.warn("[lib.nbt] Failed to read the state property " + string + " as " + prop);
        return state;
    }

    public static NBTTagCompound writeLocalDateTime(LocalDateTime localDateTime) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("year", localDateTime.getYear());
        nbt.func_74768_a("month", localDateTime.getMonthValue());
        nbt.func_74768_a("day", localDateTime.getDayOfMonth());
        nbt.func_74768_a("hour", localDateTime.getHour());
        nbt.func_74768_a("minute", localDateTime.getMinute());
        nbt.func_74768_a("second", localDateTime.getSecond());
        return nbt;
    }

    public static LocalDateTime readLocalDateTime(NBTTagCompound nbt) {
        int year = nbt.func_74762_e("year");
        int month = nbt.func_74762_e("month");
        int dayOfMonth = nbt.func_74762_e("day");
        LocalDate date = LocalDate.of(year, month, dayOfMonth);
        int hour = nbt.func_74762_e("hour");
        int minute = nbt.func_74762_e("minute");
        int second = nbt.func_74762_e("second");
        LocalTime time = LocalTime.of(hour, minute, second);
        return LocalDateTime.of(date, time);
    }

    public static <E extends Enum<E>> NBTBase writeEnumSet(EnumSet<E> set, Class<E> clazz) {
        Enum[] constants = (Enum[])clazz.getEnumConstants();
        if (constants == null) {
            throw new IllegalArgumentException("Not an enum type " + clazz);
        }
        BitSet bitset = new BitSet();
        for (Enum e : constants) {
            if (!set.contains(e)) continue;
            bitset.set(e.ordinal());
        }
        byte[] bytes = bitset.toByteArray();
        if (bytes.length == 1) {
            return new NBTTagByte(bytes[0]);
        }
        return new NBTTagByteArray(bytes);
    }

    public static <E extends Enum<E>> EnumSet<E> readEnumSet(NBTBase tag, Class<E> clazz) {
        byte[] bytes;
        Enum[] constants = (Enum[])clazz.getEnumConstants();
        if (constants == null) {
            throw new IllegalArgumentException("Not an enum type " + clazz);
        }
        if (tag instanceof NBTTagByte) {
            bytes = new byte[]{((NBTTagByte)tag).func_150290_f()};
        } else if (tag instanceof NBTTagByteArray) {
            bytes = ((NBTTagByteArray)tag).func_150292_c();
        } else {
            bytes = new byte[]{};
            BCLog.logger.warn("[lib.nbt] Tried to read an enum set from " + tag);
        }
        BitSet bitset = BitSet.valueOf(bytes);
        EnumSet<Enum> set = EnumSet.noneOf(clazz);
        for (Enum e : constants) {
            if (!bitset.get(e.ordinal())) continue;
            set.add(e);
        }
        return set;
    }

    public static NBTTagList writeCompoundList(Stream<NBTTagCompound> stream) {
        NBTTagList list = new NBTTagList();
        stream.forEach(arg_0 -> ((NBTTagList)list).func_74742_a(arg_0));
        return list;
    }

    public static Stream<NBTTagCompound> readCompoundList(NBTBase list) {
        if (list == null) {
            return Stream.empty();
        }
        if (!(list instanceof NBTTagList)) {
            throw new IllegalArgumentException();
        }
        return IntStream.range(0, ((NBTTagList)list).func_74745_c()).mapToObj(arg_0 -> ((NBTTagList)((NBTTagList)list)).func_150305_b(arg_0));
    }

    public static NBTTagList writeStringList(Stream<String> stream) {
        NBTTagList list = new NBTTagList();
        stream.map(NBTTagString::new).forEach(arg_0 -> ((NBTTagList)list).func_74742_a(arg_0));
        return list;
    }

    public static Stream<String> readStringList(NBTBase list) {
        if (list == null) {
            return Stream.empty();
        }
        if (!(list instanceof NBTTagList)) {
            throw new IllegalArgumentException();
        }
        return IntStream.range(0, ((NBTTagList)list).func_74745_c()).mapToObj(arg_0 -> ((NBTTagList)((NBTTagList)list)).func_150307_f(arg_0));
    }

    public static NBTTagByteArray writeBooleanList(Stream<Boolean> stream) {
        Boolean[] booleans = (Boolean[])stream.toArray(Boolean[]::new);
        BitSet bitSet = new BitSet(booleans.length);
        for (int i = 0; i < booleans.length; ++i) {
            bitSet.set(i, bitSet.get(i));
        }
        return new NBTTagByteArray(bitSet.toByteArray());
    }

    public static Stream<Boolean> readBooleanList(NBTBase list) {
        if (list == null) {
            return Stream.empty();
        }
        if (!(list instanceof NBTTagByteArray)) {
            throw new IllegalArgumentException();
        }
        BitSet bitSet = BitSet.valueOf(((NBTTagByteArray)list).func_150292_c());
        return IntStream.range(0, bitSet.length()).mapToObj(bitSet::get);
    }
}

