/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import buildcraft.api.mj.MjAPI;
import buildcraft.lib.BCLibConfig;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class LocaleUtil {
    public static final boolean DEBUG = BCDebugging.shouldDebugLog("lib.locale");
    private static final Set<String> failedStrings = new HashSet<String>();
    private static final NumberFormat FORMAT_FLUID = NumberFormat.getNumberInstance();
    private static String localeKeyFluidStatic;
    private static String localeKeyFluidFlow;
    private static String localeKeyFluidStaticCap;
    private static String localeKeyFluidStaticEmpty;
    private static String localeKeyFluidStaticFull;
    private static String localeKeyMjStatic;
    private static String localeKeyMjFlow;

    public static void onConfigChanged() {
        boolean bucketStatic = BCLibConfig.useBucketsStatic;
        boolean bucketFlow = BCLibConfig.useBucketsFlow;
        String longName = BCLibConfig.useLongLocalizedName ? "long" : "short";
        String timeGap = BCLibConfig.displayTimeGap == BCLibConfig.TimeGap.SECONDS ? "seconds." : "";
        localeKeyFluidStatic = "buildcraft.fluid.static." + (bucketStatic ? "bucket." : "milli.") + longName;
        localeKeyFluidFlow = "buildcraft.fluid.flow." + (bucketFlow ? "bucket." : "milli.") + longName;
        localeKeyFluidStaticCap = "buildcraft.fluid.static.cap." + (bucketStatic ? "bucket." : "milli.") + longName;
        localeKeyFluidStaticEmpty = "buildcraft.fluid.empty." + (bucketFlow ? "bucket." : "milli.") + longName;
        localeKeyFluidStaticFull = "buildcraft.fluid.full." + (bucketFlow ? "bucket." : "milli.") + longName;
        localeKeyMjStatic = "buildcraft.mj.static." + longName;
        localeKeyMjFlow = "buildcraft.mj.flow." + timeGap + longName;
    }

    public static String localize(String key) {
        String localized = I18n.func_74838_a((String)key);
        if (localized == key) {
            if (DEBUG && failedStrings.add(localized)) {
                BCLog.logger.warn("[lib.locale] Attempted to localize '" + key + "' but no localization existed!");
            }
            return key;
        }
        return localized;
    }

    public static String localize(String key, Object ... args) {
        String localized = I18n.func_74838_a((String)key);
        if (localized == key) {
            if (DEBUG && failedStrings.add(localized)) {
                BCLog.logger.warn("[lib.locale] Attempted to localize '" + key + "' but no localization existed!");
            }
            return key + " " + Arrays.toString(args);
        }
        return String.format(localized, args);
    }

    public static boolean canLocalize(String key) {
        return I18n.func_94522_b((String)key);
    }

    public static String localizeColour(EnumDyeColor colour) {
        return LocaleUtil.localize("item.fireworksCharge." + colour.func_176762_d());
    }

    public static String localizeFacing(@Nullable EnumFacing face) {
        return LocaleUtil.localize("direction." + (face == null ? "center" : face.func_176610_l()));
    }

    public static String localizeFluidStatic(IFluidTank tank) {
        return LocaleUtil.localizeFluidStatic(tank.getFluid(), tank.getCapacity());
    }

    public static String localizeFluidStatic(FluidStack fluidStack) {
        return LocaleUtil.localizeFluidStatic(fluidStack, -1);
    }

    public static String localizeFluidStatic(FluidStack fluidStack, int capacity) {
        String cap;
        String amount;
        if (fluidStack == null || fluidStack.amount <= 0) {
            if (capacity > 0) {
                String cap2 = BCLibConfig.useBucketsStatic ? FORMAT_FLUID.format((double)capacity / 1000.0) : FORMAT_FLUID.format(capacity);
                return LocaleUtil.localize(localeKeyFluidStaticEmpty, cap2);
            }
            return LocaleUtil.localize("buildcraft.fluid.empty");
        }
        String fluid = fluidStack.getLocalizedName();
        if (BCLibConfig.useBucketsStatic) {
            amount = FORMAT_FLUID.format((double)fluidStack.amount / 1000.0);
            cap = FORMAT_FLUID.format((double)capacity / 1000.0);
        } else {
            amount = FORMAT_FLUID.format(fluidStack.amount);
            cap = FORMAT_FLUID.format(capacity);
        }
        if (capacity == fluidStack.amount) {
            return LocaleUtil.localize(localeKeyFluidStaticFull, amount, fluid);
        }
        return LocaleUtil.localize(capacity > 0 ? localeKeyFluidStaticCap : localeKeyFluidStatic, amount, fluid, cap);
    }

    public static String localizeFluidFlow(int milliBucketsPerTick) {
        String amount = BCLibConfig.useBucketsFlow ? FORMAT_FLUID.format((double)milliBucketsPerTick / 50.0) : FORMAT_FLUID.format(milliBucketsPerTick);
        return LocaleUtil.localize(localeKeyFluidFlow, amount);
    }

    public static String localizeMj(long mj) {
        return LocaleUtil.localize(localeKeyMjStatic, MjAPI.formatMj(mj));
    }

    public static String localizeMjFlow(long mj) {
        mj = BCLibConfig.displayTimeGap.convertTicksToGap(mj);
        return LocaleUtil.localize(localeKeyMjFlow, MjAPI.formatMj(mj));
    }

    public static String localizeHeat(double heat) {
        return String.format("%.2f \u00b0C", heat);
    }

    static {
        LocaleUtil.onConfigChanged();
    }
}

