/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.StreamSupport;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import org.apache.commons.lang3.ArrayUtils;

public class JsonUtil {
    public static <K, V> ImmutableMap<K, V> getSubAsImmutableMap(JsonObject obj, String sub, TypeToken<HashMap<K, V>> token) {
        if (!obj.has(sub)) {
            return ImmutableMap.of();
        }
        try {
            JsonElement elem = obj.get(sub);
            HashMap map = (HashMap)new Gson().fromJson(elem, token.getType());
            return ImmutableMap.copyOf((Map)map);
        }
        catch (IllegalStateException ise) {
            throw new JsonSyntaxException("Something was wrong with " + obj + " when deserializing it as a " + token, (Throwable)ise);
        }
    }

    public static <T> ImmutableList<T> getSubAsImmutableList(JsonObject obj, String sub, TypeToken<ArrayList<T>> token) {
        if (!obj.has(sub)) {
            return ImmutableList.of();
        }
        try {
            JsonElement elem = obj.get(sub);
            ArrayList list = (ArrayList)new Gson().fromJson(elem, token.getType());
            return ImmutableList.copyOf((Collection)list);
        }
        catch (IllegalStateException ise) {
            throw new JsonSyntaxException("Something was wrong with " + obj + " when deserializing it as a " + token, (Throwable)ise);
        }
    }

    public static float getAsFloat(JsonElement element) {
        if (!element.isJsonPrimitive()) {
            throw new JsonSyntaxException("Needed a primitive, but got " + element);
        }
        JsonPrimitive prim = element.getAsJsonPrimitive();
        try {
            return prim.getAsFloat();
        }
        catch (NumberFormatException nfe) {
            throw new JsonSyntaxException("Expected a valid float, but got " + prim, (Throwable)nfe);
        }
    }

    public static float[] getAsFloatArray(JsonElement elem) {
        if (elem.isJsonArray()) {
            JsonArray array = elem.getAsJsonArray();
            float[] floats = new float[array.size()];
            for (int i = 0; i < floats.length; ++i) {
                floats[i] = JsonUtil.getAsFloat(array.get(i));
            }
            return floats;
        }
        if (elem.isJsonPrimitive()) {
            return new float[]{JsonUtil.getAsFloat(elem)};
        }
        throw new JsonSyntaxException("Needed an array of floats or a single float but got " + elem);
    }

    public static float[] getSubAsFloatArray(JsonObject obj, String string) {
        if (!obj.has(string)) {
            throw new JsonSyntaxException("Required member " + string + " in " + obj);
        }
        return JsonUtil.getAsFloatArray(obj.get(string));
    }

    public static String getAsString(JsonElement element) {
        if (!element.isJsonPrimitive()) {
            throw new JsonSyntaxException("Needed a primitive, but got " + element);
        }
        return element.getAsString();
    }

    public static String[] getAsStringArray(JsonElement elem) {
        if (elem.isJsonArray()) {
            JsonArray array = elem.getAsJsonArray();
            String[] strings = new String[array.size()];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = JsonUtil.getAsString(array.get(i));
            }
            return strings;
        }
        if (elem.isJsonPrimitive()) {
            return new String[]{JsonUtil.getAsString(elem)};
        }
        throw new JsonSyntaxException("Needed an array of strings or a single string but got " + elem);
    }

    public static String[] getSubAsStringArray(JsonObject obj, String string) {
        if (!obj.has(string)) {
            throw new JsonSyntaxException("Required member " + string + " in " + obj);
        }
        return JsonUtil.getAsStringArray(obj.get(string));
    }

    public static Map<String, String> deserializeStringMap(JsonObject obj, String sub) {
        JsonElement element = obj.get(sub);
        if (element == null) {
            throw new JsonSyntaxException("Expected to have the element '" + sub + "' inside of '" + obj + "'");
        }
        if (!element.isJsonObject()) {
            throw new JsonSyntaxException("Expected to find an object, but got '" + element + "'");
        }
        return JsonUtil.deserializeStringMap(element.getAsJsonObject());
    }

    public static Map<String, String> deserializeStringMap(JsonObject obj) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry key : obj.entrySet()) {
            JsonElement value = (JsonElement)key.getValue();
            if (value.isJsonPrimitive()) {
                map.put((String)key.getKey(), value.getAsString());
                continue;
            }
            throw new JsonSyntaxException("Expected a string, but got '" + value + "'");
        }
        return map;
    }

    public static JsonObject inlineCustom(JsonObject obj) {
        if (obj.has("inlines")) {
            JsonElement inlineElems = obj.get("inlines");
            if (!inlineElems.isJsonObject()) {
                throw new JsonSyntaxException("Expected an object, but got '" + inlineElems + "'");
            }
            JsonObject inlines = inlineElems.getAsJsonObject();
            HashMap<String, JsonObject> inlineMap = new HashMap<String, JsonObject>();
            for (Map.Entry entry : inlines.entrySet()) {
                JsonElement elem = (JsonElement)entry.getValue();
                if (!elem.isJsonObject()) {
                    throw new JsonSyntaxException("Expected an object, but got '" + elem + "'");
                }
                inlineMap.put((String)entry.getKey(), elem.getAsJsonObject());
            }
            obj.remove("inlines");
            JsonUtil.inline(obj, inlineMap);
        }
        return obj;
    }

    private static void inline(JsonElement element, Map<String, JsonObject> inlineMap) {
        if (element instanceof JsonObject) {
            JsonUtil.inline((JsonObject)element, inlineMap);
        } else if (element instanceof JsonArray) {
            JsonArray arr = (JsonArray)element;
            for (JsonElement elem : arr) {
                JsonUtil.inline(elem, inlineMap);
            }
        }
    }

    private static void inline(JsonObject obj, Map<String, JsonObject> inlineMap) {
        if (obj.has("inline")) {
            JsonElement in = obj.remove("inline");
            if (!in.isJsonPrimitive() || !in.getAsJsonPrimitive().isString()) {
                throw new JsonSyntaxException("Expected a string, but got '" + in + "'");
            }
            String target = in.getAsString();
            JsonObject toInline = inlineMap.get(target);
            if (toInline == null) {
                throw new JsonSyntaxException("Didn't find the inline " + target);
            }
            for (Map.Entry entry : toInline.entrySet()) {
                String name = (String)entry.getKey();
                if ("inline".equals(name) || obj.has(name)) continue;
                obj.add(name, (JsonElement)entry.getValue());
            }
        }
        for (Map.Entry entry : obj.entrySet()) {
            JsonUtil.inline((JsonElement)entry.getValue(), inlineMap);
        }
    }

    public static GsonBuilder registerNbtSerializersDeserializers(GsonBuilder gsonBuilder) {
        return gsonBuilder.registerTypeAdapter(NBTBase.class, (src, typeOfSrc, context) -> {
            if (src == null) {
                return JsonNull.INSTANCE;
            }
            switch (src.func_74732_a()) {
                case 1: {
                    return context.serialize(src, NBTTagByte.class);
                }
                case 2: {
                    return context.serialize(src, NBTTagShort.class);
                }
                case 3: {
                    return context.serialize(src, NBTTagInt.class);
                }
                case 4: {
                    return context.serialize(src, NBTTagLong.class);
                }
                case 5: {
                    return context.serialize(src, NBTTagFloat.class);
                }
                case 6: {
                    return context.serialize(src, NBTTagDouble.class);
                }
                case 7: {
                    return context.serialize(src, NBTTagByteArray.class);
                }
                case 8: {
                    return context.serialize(src, NBTTagString.class);
                }
                case 9: {
                    return context.serialize(src, NBTTagList.class);
                }
                case 10: {
                    return context.serialize(src, NBTTagCompound.class);
                }
                case 11: {
                    return context.serialize(src, NBTTagIntArray.class);
                }
            }
            throw new IllegalArgumentException(src.toString());
        }).registerTypeAdapter(NBTBase.class, (json, typeOfT, context) -> {
            if (json.isJsonNull()) {
                return null;
            }
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
                Number number = json.getAsJsonPrimitive().getAsNumber();
                if (number instanceof BigInteger || number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof Byte) {
                    return (NBTBase)context.deserialize(json, NBTTagLong.class);
                }
                return (NBTBase)context.deserialize(json, NBTTagDouble.class);
            }
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isBoolean()) {
                return (NBTBase)context.deserialize((JsonElement)new JsonPrimitive((Number)(json.getAsJsonPrimitive().getAsBoolean() ? (byte)1 : (byte)0)), NBTTagByte.class);
            }
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                return (NBTBase)context.deserialize(json, NBTTagString.class);
            }
            if (json.isJsonArray()) {
                return (NBTBase)context.deserialize(json, NBTTagList.class);
            }
            if (json.isJsonObject()) {
                return (NBTBase)context.deserialize(json, NBTTagCompound.class);
            }
            throw new IllegalArgumentException(json.toString());
        }).registerTypeAdapter(NBTTagByte.class, (src, typeOfSrc, context) -> new JsonPrimitive((Number)src.func_150290_f())).registerTypeAdapter(NBTTagByte.class, (json, typeOfT, context) -> new NBTTagByte(json.getAsJsonPrimitive().getAsByte())).registerTypeAdapter(NBTTagShort.class, (src, typeOfSrc, context) -> new JsonPrimitive((Number)src.func_150289_e())).registerTypeAdapter(NBTTagShort.class, (json, typeOfT, context) -> new NBTTagShort(json.getAsJsonPrimitive().getAsShort())).registerTypeAdapter(NBTTagInt.class, (src, typeOfSrc, context) -> new JsonPrimitive((Number)src.func_150287_d())).registerTypeAdapter(NBTTagInt.class, (json, typeOfT, context) -> new NBTTagInt(json.getAsJsonPrimitive().getAsInt())).registerTypeAdapter(NBTTagLong.class, (src, typeOfSrc, context) -> new JsonPrimitive((Number)src.func_150291_c())).registerTypeAdapter(NBTTagLong.class, (json, typeOfT, context) -> new NBTTagLong(json.getAsJsonPrimitive().getAsLong())).registerTypeAdapter(NBTTagFloat.class, (src, typeOfSrc, context) -> new JsonPrimitive((Number)Float.valueOf(src.func_150288_h()))).registerTypeAdapter(NBTTagFloat.class, (json, typeOfT, context) -> new NBTTagFloat(json.getAsJsonPrimitive().getAsFloat())).registerTypeAdapter(NBTTagDouble.class, (src, typeOfSrc, context) -> new JsonPrimitive((Number)src.func_150286_g())).registerTypeAdapter(NBTTagDouble.class, (json, typeOfT, context) -> new NBTTagDouble(json.getAsJsonPrimitive().getAsDouble())).registerTypeAdapter(NBTTagByteArray.class, (src, typeOfSrc, context) -> {
            JsonArray jsonArray = new JsonArray();
            for (byte element : src.func_150292_c()) {
                jsonArray.add((JsonElement)new JsonPrimitive((Number)element));
            }
            return jsonArray;
        }).registerTypeAdapter(NBTTagByteArray.class, (json, typeOfT, context) -> new NBTTagByteArray(ArrayUtils.toPrimitive((Byte[])((Byte[])StreamSupport.stream(json.getAsJsonArray().spliterator(), false).map(JsonElement::getAsByte).toArray(Byte[]::new))))).registerTypeAdapter(NBTTagString.class, (src, typeOfSrc, context) -> new JsonPrimitive(src.func_150285_a_())).registerTypeAdapter(NBTTagString.class, (json, typeOfT, context) -> new NBTTagString(json.getAsJsonPrimitive().getAsString())).registerTypeAdapter(NBTTagList.class, (src, typeOfSrc, context) -> {
            JsonArray jsonArray = new JsonArray();
            for (int i = 0; i < src.func_74745_c(); ++i) {
                NBTBase element = src.func_179238_g(i);
                jsonArray.add(context.serialize((Object)element, NBTBase.class));
            }
            return jsonArray;
        }).registerTypeAdapter(NBTTagList.class, (json, typeOfT, context) -> {
            NBTTagList nbtTagList = new NBTTagList();
            StreamSupport.stream(json.getAsJsonArray().spliterator(), false).map(element -> (NBTBase)context.deserialize(element, NBTBase.class)).forEach(arg_0 -> ((NBTTagList)nbtTagList).func_74742_a(arg_0));
            return nbtTagList;
        }).registerTypeAdapter(NBTTagCompound.class, (src, typeOfSrc, context) -> {
            JsonObject jsonObject = new JsonObject();
            for (String key : src.func_150296_c()) {
                jsonObject.add(key, context.serialize((Object)src.func_74781_a(key), NBTBase.class));
            }
            return jsonObject;
        }).registerTypeAdapter(NBTTagCompound.class, (json, typeOfT, context) -> {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                nbtTagCompound.func_74782_a((String)entry.getKey(), (NBTBase)context.deserialize((JsonElement)entry.getValue(), NBTBase.class));
            }
            return nbtTagCompound;
        }).registerTypeAdapter(NBTTagIntArray.class, (src, typeOfSrc, context) -> {
            JsonArray jsonArray = new JsonArray();
            for (int element : src.func_150302_c()) {
                jsonArray.add((JsonElement)new JsonPrimitive((Number)element));
            }
            return jsonArray;
        }).registerTypeAdapter(NBTTagIntArray.class, (json, typeOfT, context) -> new NBTTagIntArray(StreamSupport.stream(json.getAsJsonArray().spliterator(), false).mapToInt(JsonElement::getAsByte).toArray()));
    }
}

