/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.lib.client.render.fluid.FluidRenderer;
import buildcraft.lib.fluid.Tank;
import buildcraft.lib.gui.ContainerBC_Neptune;
import buildcraft.lib.gui.GuiBC8;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.opengl.GL11;

public class GuiUtil {
    public static ToolTip createToolTip(final GuiBC8<?> gui, final Supplier<ItemStack> stackRef) {
        return new ToolTip(new String[0]){

            @Override
            public void refresh() {
                this.delegate().clear();
                ItemStack stack = (ItemStack)stackRef.get();
                if (!stack.func_190926_b()) {
                    EntityPlayer player = ((ContainerBC_Neptune)((Object)gui.container)).player;
                    boolean advanced = gui.field_146297_k.field_71474_y.field_82882_x;
                    this.delegate().addAll(stack.func_82840_a(player, advanced));
                }
            }
        };
    }

    public static <D> void drawVerticallyAppending(IGuiPosition element, Iterable<? extends D> iterable, IVerticalAppendingDrawer<D> drawer) {
        int x = element.getX();
        int y = element.getY();
        for (D drawable : iterable) {
            y += drawer.draw(drawable, x, y);
        }
    }

    public static int drawHoveringText(List<String> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, FontRenderer font) {
        if (!textLines.isEmpty()) {
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = font.func_78256_a(textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            int titleLinesCount = 1;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<String> wrappedTextLines = new ArrayList<String>();
                for (int i = 0; i < textLines.size(); ++i) {
                    String textLine = textLines.get(i);
                    List wrappedLine = font.func_78271_c(textLine, tooltipTextWidth);
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = font.func_78256_a(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY + tooltipHeight + 6 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 6;
            }
            int zLevel = 300;
            int backgroundColor = -267386864;
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)-267386864, (int)-267386864);
            int borderColorStart = 0x505000FF;
            int borderColorEnd = 1344798847;
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)0x505000FF, (int)1344798847);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)0x505000FF, (int)1344798847);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)0x505000FF, (int)0x505000FF);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)1344798847, (int)1344798847);
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                String line = textLines.get(lineNumber);
                font.func_175063_a(line, (float)tooltipX, (float)tooltipY, -1);
                if (lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
            return tooltipHeight + 5;
        }
        return 0;
    }

    public static void drawFluid(IGuiArea position, Tank tank) {
        GuiUtil.drawFluid(position, tank.getFluidForRender(), tank.getCapacity());
    }

    public static void drawFluid(IGuiArea position, FluidStack fluid, int capacity) {
        if (fluid == null || fluid.amount <= 0) {
            return;
        }
        GuiUtil.drawFluid(position, fluid, fluid.amount, capacity);
    }

    public static void drawFluid(IGuiArea position, FluidStack fluid, int amount, int capacity) {
        int endY;
        int startY;
        if (fluid == null || amount <= 0) {
            return;
        }
        int height = amount * position.getHeight() / capacity;
        int startX = position.getX();
        int endX = startX + position.getWidth();
        if (fluid.getFluid().isGaseous(fluid)) {
            startY = position.getY() + height;
            endY = position.getY();
        } else {
            startY = position.getEndY();
            endY = startY - height;
        }
        FluidRenderer.drawFluidForGui(fluid, startX, startY, endX, endY);
    }

    public static void scissor(int x, int y, int width, int height) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc);
        double scaleW = (double)mc.field_71443_c / res.func_78327_c();
        double scaleH = (double)mc.field_71440_d / res.func_78324_d();
        int rx = (int)((double)x * scaleW);
        int ry = (int)((double)mc.field_71440_d - (double)(y + height) * scaleH);
        GL11.glScissor((int)rx, (int)ry, (int)((int)((double)width * scaleW)), (int)((int)((double)height * scaleH)));
    }

    @FunctionalInterface
    public static interface IVerticalAppendingDrawer<D> {
        public int draw(D var1, int var2, int var3);
    }
}

