/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.api.core.IFluidFilter;
import buildcraft.api.core.IFluidHandlerAdv;
import buildcraft.lib.fluid.Tank;
import buildcraft.lib.misc.CapUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidUtilBC {
    public static void pushFluidAround(IBlockAccess world, BlockPos pos, Tank tank) {
        FluidStack actuallyDrained;
        FluidStack potential = tank.drain(tank.getFluidAmount(), false);
        int drained = 0;
        if (potential == null || potential.amount <= 0) {
            return;
        }
        FluidStack working = potential.copy();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            int used;
            IFluidHandler handler;
            if (potential.amount <= 0) break;
            TileEntity target = world.func_175625_s(pos.func_177972_a(side));
            if (target == null || (handler = (IFluidHandler)target.getCapability(CapUtil.CAP_FLUIDS, side.func_176734_d())) == null || (used = handler.fill(potential, true)) <= 0) continue;
            drained += used;
            potential.amount -= used;
        }
        if (drained > 0 && ((actuallyDrained = tank.drain(drained, true)) == null || actuallyDrained.amount != drained)) {
            throw new IllegalStateException("Bad tank! Could drain " + working + " but only drained " + actuallyDrained + "( tank " + tank.getClass() + ")");
        }
    }

    public static void pullFluidAround(IBlockAccess world, BlockPos pos, Tank tank) {
        int max = tank.getCapacity() - tank.getFluidAmount();
        if (max <= 0) {
            return;
        }
        max = Math.min(max, 1000);
        for (EnumFacing side : EnumFacing.field_82609_l) {
            FluidStack reallyDrained;
            int filled;
            FluidStack drained;
            IFluidHandler handler;
            TileEntity target = world.func_175625_s(pos.func_177972_a(side));
            if (target == null || (handler = (IFluidHandler)target.getCapability(CapUtil.CAP_FLUIDS, side.func_176734_d())) == null) continue;
            FluidStack fluidFilter = tank.getFluid();
            if (fluidFilter == null) {
                drained = handler.drain(max, false);
                if (drained == null || (filled = tank.fill(drained, true)) <= 0) continue;
                reallyDrained = handler.drain(filled, true);
                if (reallyDrained == null || reallyDrained.amount != filled) {
                    throw new IllegalStateException("Bad IFluidHandler.drain implementation! ( drained = " + drained + " reallyDrained = " + reallyDrained + " handler " + handler.getClass());
                }
                max -= filled;
                continue;
            }
            fluidFilter = fluidFilter.copy();
            fluidFilter.amount = max;
            drained = handler.drain(fluidFilter, false);
            if (drained == null || (filled = tank.fill(drained, true)) <= 0) continue;
            fluidFilter.amount = filled;
            reallyDrained = handler.drain(fluidFilter, true);
            if (reallyDrained == null || reallyDrained.amount != filled) {
                throw new IllegalStateException("Bad IFluidHandler.drain implementation! ( drained = " + drained + " reallyDrained = " + reallyDrained + " handler " + handler.getClass());
            }
            max -= filled;
        }
    }

    public static List<FluidStack> mergeSameFluids(List<FluidStack> fluids) {
        ArrayList<FluidStack> stacks = new ArrayList<FluidStack>();
        fluids.forEach(toAdd -> {
            boolean found = false;
            for (FluidStack stack : stacks) {
                if (!stack.isFluidEqual(toAdd)) continue;
                stack.amount += toAdd.amount;
                found = true;
            }
            if (!found) {
                stacks.add(toAdd.copy());
            }
        });
        return stacks;
    }

    public static boolean areFluidStackEqual(FluidStack a, FluidStack b) {
        return a == null && b == null || a != null && a.isFluidEqual(b) && a.amount == b.amount;
    }

    public static boolean areFluidsEqual(Fluid a, Fluid b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.getName().equals(b.getName());
    }

    @Nullable
    public static FluidStack move(IFluidHandler from, IFluidHandler to) {
        return FluidUtilBC.move(from, to, Integer.MAX_VALUE);
    }

    @Nullable
    public static FluidStack move(IFluidHandler from, IFluidHandler to, int max) {
        FluidStack toDrainPotential;
        if (from == null || to == null) {
            return null;
        }
        if (from instanceof IFluidHandlerAdv) {
            IFluidFilter filter = f -> to.fill(f, false) > 0;
            toDrainPotential = ((IFluidHandlerAdv)from).drain(filter, max, false);
        } else {
            toDrainPotential = from.drain(max, false);
        }
        int accepted = to.fill(toDrainPotential, false);
        if (accepted <= 0) {
            return null;
        }
        FluidStack toDrain = new FluidStack(toDrainPotential, accepted);
        FluidStack drained = from.drain(toDrain, true);
        if (!toDrain.isFluidEqual(drained) || toDrain.amount != drained.amount) {
            throw new IllegalStateException("Drained fluid did not equal expected fluid! Bad impl - " + from.getClass());
        }
        int actuallyAccepted = to.fill(drained, true);
        if (actuallyAccepted != accepted) {
            throw new IllegalStateException("Mismatched IFluidHandler implementations!");
        }
        return new FluidStack(drained, accepted);
    }
}

