/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.api.tools.IToolWrench;
import buildcraft.lib.misc.BoundingBoxUtil;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class EntityUtil {
    public static NonNullList<ItemStack> collectItems(World world, BlockPos around, double radius) {
        return EntityUtil.collectItems(world, new Vec3d((Vec3i)around).func_72441_c(0.5, 0.5, 0.5), radius);
    }

    public static NonNullList<ItemStack> collectItems(World world, Vec3d around, double radius) {
        NonNullList stacks = NonNullList.func_191196_a();
        AxisAlignedBB aabb = BoundingBoxUtil.makeAround(around, radius);
        for (EntityItem ent : world.func_72872_a(EntityItem.class, aabb)) {
            if (ent.field_70128_L) continue;
            ent.field_70128_L = true;
            stacks.add((Object)ent.func_92059_d());
        }
        return stacks;
    }

    public static Vec3d getVec(Entity entity) {
        return new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public static EnumHand getWrenchHand(EntityLivingBase entity) {
        ItemStack stack = entity.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IToolWrench) {
            return EnumHand.MAIN_HAND;
        }
        stack = entity.func_184592_cb();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IToolWrench) {
            return EnumHand.OFF_HAND;
        }
        return null;
    }

    public static void activateWrench(EntityPlayer player) {
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IToolWrench) {
            IToolWrench wrench = (IToolWrench)stack.func_77973_b();
            wrench.wrenchUsed(player, EnumHand.MAIN_HAND, stack, null);
            return;
        }
        stack = player.func_184592_cb();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IToolWrench) {
            IToolWrench wrench = (IToolWrench)stack.func_77973_b();
            wrench.wrenchUsed(player, EnumHand.OFF_HAND, stack, null);
        }
    }

    @Nonnull
    public static ItemStack getArrowStack(EntityArrow arrow) {
        if (arrow instanceof EntitySpectralArrow) {
            return new ItemStack(Items.field_185166_h);
        }
        return new ItemStack(Items.field_151032_g);
    }
}

