/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DebuggingTools {
    public static final boolean ENABLE = BCDebugging.shouldDebugComplex("lib.debug.world");

    public static void fmlInit() {
        if (ENABLE) {
            MinecraftForge.EVENT_BUS.register((Object)new EventHook());
        }
    }

    private static class WorldListener
    implements IWorldEventListener {
        public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
            int i;
            StackTraceElement[] elements = new Throwable().getStackTrace();
            String[] bc = new String[elements.length];
            int bcIndex = 0;
            for (i = 1; i < elements.length; ++i) {
                StackTraceElement ste = elements[i];
                if (!ste.getClassName().startsWith("buildcraft")) continue;
                bc[bcIndex++] = ste.getClassName() + " # " + ste.getMethodName() + " : " + ste.getLineNumber();
            }
            if (bcIndex > 0) {
                BCLog.logger.info("[lib.debug.world] markBlockRangeForRenderUpdate(" + x1 + ", " + y1 + ", " + z1 + ", " + x2 + ", " + y2 + ", " + z2 + ")");
                for (i = 0; i < bcIndex; ++i) {
                    BCLog.logger.info("[lib.debug.world]   at " + bc[i]);
                }
            }
        }

        public void func_184376_a(World worldIn, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
        }

        public void func_174959_b(BlockPos pos) {
        }

        public void func_184375_a(EntityPlayer player, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
        }

        public void func_184377_a(SoundEvent soundIn, BlockPos pos) {
        }

        public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        }

        public void func_72703_a(Entity entityIn) {
        }

        public void func_72709_b(Entity entityIn) {
        }

        public void func_180440_a(int soundID, BlockPos pos, int data) {
        }

        public void func_180439_a(EntityPlayer player, int type, BlockPos blockPosIn, int data) {
        }

        public void func_180441_b(int breakerId, BlockPos pos, int progress) {
        }

        public void func_190570_a(int p_190570_1_, boolean p_190570_2_, boolean p_190570_3_, double p_190570_4_, double p_190570_6_, double p_190570_8_, double p_190570_10_, double p_190570_12_, double p_190570_14_, int ... p_190570_16_) {
        }
    }

    private static class EventHook {
        private EventHook() {
        }

        @SubscribeEvent
        public void worldLoadEvent(WorldEvent.Load load) {
            load.getWorld().func_72954_a((IWorldEventListener)new WorldListener());
        }
    }
}

