/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.api.core.BCLog;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigUtil {
    public static void setLang(Configuration cfg) {
        for (String s : cfg.getCategoryNames()) {
            ConfigCategory cat;
            ConfigCategory p = cat = cfg.getCategory(s);
            while (p != null) {
                p.setLanguageKey("config." + p.getQualifiedName());
                p = p.parent;
            }
            for (Property prop : cat.values()) {
                prop.setLanguageKey(cat.getLanguagekey() + "." + prop.getName());
            }
        }
    }

    public static <E extends Enum<E>> void setEnumProperty(Property prop, E[] possible) {
        String[] validValues = new String[possible.length];
        for (int i = 0; i < possible.length; ++i) {
            validValues[i] = ((Enum)possible[i]).name().toLowerCase(Locale.ROOT);
        }
        prop.setValidValues(validValues);
    }

    public static <E extends Enum<E>> E parseEnumForConfig(String cfgValue, E[] possible, E defaultOption) {
        LinkedList match = new LinkedList();
        Collections.addAll(match, possible);
        LinkedList<char[]> lowerCaseNames = new LinkedList<char[]>();
        for (Enum val : match) {
            lowerCaseNames.add(val.name().toLowerCase(Locale.ROOT).toCharArray());
        }
        char[] chars = cfgValue.toLowerCase(Locale.ROOT).toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            Iterator iter = match.iterator();
            Iterator iterNames = lowerCaseNames.iterator();
            while (iter.hasNext()) {
                iter.next();
                char[] name = (char[])iterNames.next();
                if (name.length >= i && name[i] == chars[i]) continue;
                iter.remove();
                iterNames.remove();
            }
            if (match.size() != 1) continue;
            return (E)ConfigUtil.getAssumingEqual(cfgValue, (Enum)match.peek());
        }
        return ConfigUtil.getAssumingEqual(cfgValue, defaultOption);
    }

    private static <E extends Enum<E>> E getAssumingEqual(String value, E mode) {
        if (!mode.name().equalsIgnoreCase(value)) {
            BCLog.logger.warn("[transport.config] Unknown PowerLossMode '" + value + "', assuming " + mode.name());
        }
        return mode;
    }
}

