/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.api.core.IBox;
import buildcraft.lib.misc.VecUtil;
import buildcraft.lib.misc.data.Box;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class BoundingBoxUtil {
    public static AxisAlignedBB makeFrom(BlockPos additional, @Nullable IBox box) {
        if (box == null) {
            return new AxisAlignedBB(additional);
        }
        BlockPos min = VecUtil.min(box.min(), additional);
        BlockPos max = VecUtil.max(box.max(), additional);
        return new AxisAlignedBB(min, max.func_177971_a((Vec3i)VecUtil.POS_ONE));
    }

    public static AxisAlignedBB makeFrom(BlockPos primary, BlockPos ... additional) {
        Box box = new Box(primary, primary);
        for (BlockPos a : additional) {
            box.extendToEncompass(a);
        }
        return box.getBoundingBox();
    }

    public static AxisAlignedBB makeFrom(BlockPos additional, @Nullable IBox box1, @Nullable IBox box2) {
        if (box1 == null) {
            return BoundingBoxUtil.makeFrom(additional, box2);
        }
        if (box2 == null) {
            return BoundingBoxUtil.makeFrom(additional, box1);
        }
        BlockPos min = VecUtil.min(box1.min(), box2.min(), additional);
        BlockPos max = VecUtil.max(box1.max(), box2.max(), additional);
        return new AxisAlignedBB(min, max.func_177971_a((Vec3i)VecUtil.POS_ONE));
    }

    public static AxisAlignedBB makeFrom(Vec3d from, Vec3d to) {
        return new AxisAlignedBB(from.field_72450_a, from.field_72448_b, from.field_72449_c, to.field_72450_a, to.field_72448_b, to.field_72449_c);
    }

    public static AxisAlignedBB makeFrom(Vec3d from, Vec3d to, double radius) {
        return BoundingBoxUtil.makeFrom(from, to).func_186662_g(radius);
    }

    public static AxisAlignedBB makeAround(Vec3d around, double radius) {
        return new AxisAlignedBB(around.field_72450_a, around.field_72448_b, around.field_72449_c, around.field_72450_a, around.field_72448_b, around.field_72449_c).func_186662_g(radius);
    }

    public static AxisAlignedBB makeFrom(BlockPos pos, @Nullable IBox box, @Nullable Collection<BlockPos> additional) {
        BlockPos max;
        BlockPos min = box == null ? pos : VecUtil.min(box.min(), pos);
        BlockPos blockPos = max = box == null ? pos : VecUtil.max(box.max(), pos);
        if (additional != null) {
            for (BlockPos p : additional) {
                min = VecUtil.min(min, p);
                max = VecUtil.max(max, p);
            }
        }
        return new AxisAlignedBB(min, max.func_177971_a((Vec3i)VecUtil.POS_ONE));
    }
}

