/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.marker;

import buildcraft.lib.marker.MarkerSubCache;
import buildcraft.lib.tile.TileMarker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class MarkerConnection<C extends MarkerConnection<C>> {
    public final MarkerSubCache<C> subCache;

    public MarkerConnection(MarkerSubCache<C> subCache) {
        this.subCache = subCache;
    }

    public abstract void removeMarker(BlockPos var1);

    public abstract Collection<BlockPos> getMarkerPositions();

    @SideOnly(value=Side.CLIENT)
    public abstract void renderInWorld();

    @SideOnly(value=Side.CLIENT)
    public void getDebugInfo(BlockPos caller, List<String> left) {
        Collection<BlockPos> positions = this.getMarkerPositions();
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(positions);
        if (positions instanceof Set) {
            Collections.sort(list);
        }
        for (BlockPos pos : list) {
            TileMarker<C> marker = this.subCache.getMarker(pos);
            String s = "  " + pos + " [";
            s = marker == null ? s + TextFormatting.RED + "U" : s + TextFormatting.GREEN + "L";
            s = pos.equals((Object)caller) ? s + TextFormatting.BLACK + "S" : s + TextFormatting.AQUA + "C";
            s = s + this.getTypeInfo(pos, marker);
            s = s + TextFormatting.RESET + "]";
            left.add(s);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected String getTypeInfo(BlockPos pos, @Nullable TileMarker<C> value) {
        return "";
    }
}

