/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.list;

import buildcraft.api.lists.ListMatchHandler;
import buildcraft.lib.list.ListOreDictionaryCache;
import buildcraft.lib.misc.StackUtil;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class ListMatchHandlerOreDictionary
extends ListMatchHandler {
    private static int getUppercaseCount(String s) {
        int j = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isUpperCase(s.codePointAt(i))) continue;
            ++j;
        }
        return j;
    }

    @Override
    public boolean matches(ListMatchHandler.Type type, @Nonnull ItemStack stack, @Nonnull ItemStack target, boolean precise) {
        block8: {
            Set<Integer> stackIds;
            String[] oreNames;
            int[] matchesIds;
            block7: {
                int[] oreIds = OreDictionary.getOreIDs((ItemStack)stack);
                if (oreIds.length == 0) {
                    if (type == ListMatchHandler.Type.TYPE) {
                        return StackUtil.isMatchingItem(stack, target, false, false);
                    }
                    return false;
                }
                matchesIds = OreDictionary.getOreIDs((ItemStack)target);
                oreNames = new String[oreIds.length];
                for (int i = 0; i < oreIds.length; ++i) {
                    oreNames[i] = OreDictionary.getOreName((int)oreIds[i]);
                }
                if (type != ListMatchHandler.Type.CLASS) break block7;
                for (int i : oreIds) {
                    for (int j : matchesIds) {
                        if (i != j) continue;
                        return true;
                    }
                }
                break block8;
            }
            String s = ListMatchHandlerOreDictionary.getBestOreString(oreNames);
            if (s == null || (stackIds = ListOreDictionaryCache.INSTANCE.getListOfPartialMatches(type == ListMatchHandler.Type.MATERIAL ? ListOreDictionaryCache.getMaterial(s) : ListOreDictionaryCache.getType(s))) == null) break block8;
            for (int j : stackIds) {
                for (int k : matchesIds) {
                    if (j != k) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isValidSource(ListMatchHandler.Type type, @Nonnull ItemStack stack) {
        if (OreDictionary.getOreIDs((ItemStack)stack).length > 0) {
            return true;
        }
        return type == ListMatchHandler.Type.TYPE && stack.func_77981_g();
    }

    private static String getBestOreString(String[] oreIds) {
        String s = null;
        int suc = 0;
        for (String st : oreIds) {
            int suct = ListMatchHandlerOreDictionary.getUppercaseCount(st);
            if (s != null && suct <= suc) continue;
            s = st;
            suc = suct;
        }
        return s;
    }

    @Override
    public NonNullList<ItemStack> getClientExamples(ListMatchHandler.Type type, @Nonnull ItemStack stack) {
        int[] oreIds = OreDictionary.getOreIDs((ItemStack)stack);
        NonNullList stacks = NonNullList.func_191196_a();
        if (oreIds.length == 0) {
            if (type == ListMatchHandler.Type.TYPE) {
                NonNullList tempStack = NonNullList.func_191196_a();
                stack.func_77973_b().func_150895_a(stack.func_77973_b(), CreativeTabs.field_78026_f, tempStack);
                for (ItemStack is : tempStack) {
                    if (is.func_77973_b() != stack.func_77973_b()) continue;
                    stacks.add((Object)is);
                }
            }
            return stacks;
        }
        String[] oreNames = new String[oreIds.length];
        for (int i = 0; i < oreIds.length; ++i) {
            oreNames[i] = OreDictionary.getOreName((int)oreIds[i]);
        }
        if (type == ListMatchHandler.Type.CLASS) {
            for (String s : oreNames) {
                stacks.addAll((Collection)OreDictionary.getOres((String)s));
            }
        } else {
            Set<Integer> stackIds;
            String s = ListMatchHandlerOreDictionary.getBestOreString(oreNames);
            if (s != null && (stackIds = ListOreDictionaryCache.INSTANCE.getListOfPartialMatches(type == ListMatchHandler.Type.MATERIAL ? ListOreDictionaryCache.getMaterial(s) : ListOreDictionaryCache.getType(s))) != null) {
                for (int j : stackIds) {
                    stacks.addAll((Collection)OreDictionary.getOres((String)OreDictionary.getOreName((int)j)));
                }
            }
        }
        NonNullList wildcard = NonNullList.func_191196_a();
        for (ItemStack is : stacks) {
            if (is == null || is.func_77952_i() != Short.MAX_VALUE || !is.func_77981_g()) continue;
            wildcard.add((Object)is);
        }
        for (ItemStack is : wildcard) {
            NonNullList wll = NonNullList.func_191196_a();
            is.func_77973_b().func_150895_a(is.func_77973_b(), CreativeTabs.field_78026_f, wll);
            if (wll.size() <= 0) continue;
            stacks.remove((Object)is);
            stacks.addAll((Collection)wll);
        }
        return stacks;
    }
}

