/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.item;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import buildcraft.lib.item.IItemBuildCraft;
import buildcraft.lib.registry.MigrationManager;
import buildcraft.lib.registry.RegistryHelper;
import buildcraft.lib.registry.TagManager;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemManager {
    static final boolean DEBUG = BCDebugging.shouldDebugLog("lib.item");
    private static List<IItemBuildCraft> registeredItems = new ArrayList<IItemBuildCraft>();

    public static <I extends Item> I register(I item) {
        return ItemManager.register(item, false);
    }

    public static <I extends Item> I register(I item, boolean force) {
        if (RegistryHelper.registerItem(item, force)) {
            registeredItems.add((IItemBuildCraft)item);
            MigrationManager.INSTANCE.addItemMigration(item, TagManager.getMultiTag(((IItemBuildCraft)item).id(), TagManager.EnumTagTypeMulti.OLD_REGISTRY_NAME));
            return item;
        }
        return null;
    }

    public static void fmlInit() {
        for (IItemBuildCraft item : registeredItems) {
            if (!TagManager.hasTag(item.id(), TagManager.EnumTagType.OREDICT_NAME)) continue;
            OreDictionary.registerOre((String)TagManager.getTag(item.id(), TagManager.EnumTagType.OREDICT_NAME), (Item)((Item)item));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void fmlInitClient() {
        for (IItemBuildCraft item : registeredItems) {
            TIntObjectHashMap variants = new TIntObjectHashMap();
            item.addModelVariants((TIntObjectHashMap<ModelResourceLocation>)variants);
            for (int meta : variants.keys()) {
                ModelResourceLocation mrl = (ModelResourceLocation)variants.get(meta);
                if (DEBUG) {
                    BCLog.logger.info("[lib.item][" + ((Item)item).getRegistryName() + "] Registering a variant " + meta + " -> " + mrl);
                }
                Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)item, meta, mrl);
            }
        }
    }
}

