/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.item;

import buildcraft.api.core.BCLog;
import buildcraft.lib.item.ItemManager;
import buildcraft.lib.registry.CreativeTabManager;
import buildcraft.lib.registry.TagManager;
import gnu.trove.map.hash.TIntObjectHashMap;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IItemBuildCraft {
    public String id();

    default public void init() {
        Item thisItem = (Item)this;
        thisItem.func_77655_b(TagManager.getTag(this.id(), TagManager.EnumTagType.UNLOCALIZED_NAME));
        thisItem.setRegistryName(TagManager.getTag(this.id(), TagManager.EnumTagType.REGISTRY_NAME));
        thisItem.func_77637_a(CreativeTabManager.getTab(TagManager.getTag(this.id(), TagManager.EnumTagType.CREATIVE_TAB)));
    }

    @SideOnly(value=Side.CLIENT)
    default public void addModelVariants(TIntObjectHashMap<ModelResourceLocation> variants) {
        this.addVariant(variants, 0, "");
    }

    default public void addVariant(TIntObjectHashMap<ModelResourceLocation> variants, int meta, String suffix) {
        String tag = TagManager.getTag(this.id(), TagManager.EnumTagType.MODEL_LOCATION);
        variants.put(meta, (Object)new ModelResourceLocation(tag + suffix, "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    default public void postRegisterClient() {
        Item thisItem = (Item)this;
        TIntObjectHashMap variants = new TIntObjectHashMap();
        this.addModelVariants((TIntObjectHashMap<ModelResourceLocation>)variants);
        for (int key : variants.keys()) {
            ModelResourceLocation variant = (ModelResourceLocation)variants.get(key);
            if (ItemManager.DEBUG) {
                BCLog.logger.info("[lib.item][" + thisItem.getRegistryName() + "] Registering a variant " + variant + " for damage " + key);
            }
            ModelBakery.registerItemVariants((Item)thisItem, (ResourceLocation[])new ResourceLocation[]{variant});
        }
    }
}

