/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.inventory.filter;

import buildcraft.api.core.IStackFilter;
import buildcraft.api.recipes.StackDefinition;
import buildcraft.lib.misc.StackUtil;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class ArrayStackFilter
implements IStackFilter {
    protected NonNullList<ItemStack> stacks;

    public ArrayStackFilter(ItemStack ... stacks) {
        this.stacks = StackUtil.listOf(stacks);
    }

    @Override
    public boolean matches(@Nonnull ItemStack stack) {
        if (this.stacks.size() == 0 || !this.hasFilter()) {
            return true;
        }
        for (ItemStack s : this.stacks) {
            if (!StackUtil.isMatchingItem(s, stack)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(IStackFilter filter2) {
        for (ItemStack s : this.stacks) {
            if (!filter2.matches(s)) continue;
            return true;
        }
        return false;
    }

    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }

    public boolean hasFilter() {
        for (ItemStack filter : this.stacks) {
            if (filter == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public NonNullList<ItemStack> getExamples() {
        return this.stacks;
    }

    public static StackDefinition definition(int count, ItemStack ... stacks) {
        return new StackDefinition(new ArrayStackFilter(stacks), count);
    }

    public static StackDefinition definition(ItemStack ... stacks) {
        return ArrayStackFilter.definition(1, stacks);
    }

    public static StackDefinition definition(int count, Block ... blocks) {
        return ArrayStackFilter.definition(count, (ItemStack[])Arrays.stream(blocks).map(ItemStack::new).toArray(ItemStack[]::new));
    }

    public static StackDefinition definition(Block ... blocks) {
        return ArrayStackFilter.definition(1, blocks);
    }

    public static StackDefinition definition(int count, Item ... items) {
        return ArrayStackFilter.definition(count, (ItemStack[])Arrays.stream(items).map(ItemStack::new).toArray(ItemStack[]::new));
    }

    public static StackDefinition definition(Item ... items) {
        return ArrayStackFilter.definition(1, items);
    }
}

